/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.zoom;

import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.task.internal.zoom.ZoomEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

abstract class AbstractZoomTask
extends AbstractNetworkViewTask {
    private final double factor;
    private final CyServiceRegistrar serviceRegistrar;

    AbstractZoomTask(CyNetworkView view, double factor, CyServiceRegistrar serviceRegistrar) {
        super(view);
        this.factor = factor;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Zoom View");
        tm.setProgress(0.0);
        double oldFactor = (Double)this.view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)(oldFactor * this.factor));
        tm.setProgress(0.2);
        this.view.updateView();
        tm.setProgress(0.4);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new ZoomEdit(this.view, this.factor));
        tm.setProgress(1.0);
    }
}

