/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.vizmap;

import java.io.File;
import java.util.HashMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.write.VizmapWriterManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.vizmap.VizmapWriter;
import org.cytoscape.task.write.ExportVizmapTaskFactory;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TunableSetter;

public class ExportVizmapTaskFactoryImpl
extends AbstractTaskFactory
implements ExportVizmapTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public ExportVizmapTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        VizmapWriterManager writerManager = (VizmapWriterManager)this.serviceRegistrar.getService(VizmapWriterManager.class);
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        return new TaskIterator(2, new Task[]{new VizmapWriter(writerManager, applicationManager, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(File file) {
        HashMap<String, File> m = new HashMap<String, File>();
        m.put("OutputFile", file);
        VizmapWriterManager writerManager = (VizmapWriterManager)this.serviceRegistrar.getService(VizmapWriterManager.class);
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        VizmapWriter writer = new VizmapWriter(writerManager, applicationManager, this.serviceRegistrar);
        writer.setDefaultFileFormatUsingFileExt(file);
        TunableSetter tunableSetter = (TunableSetter)this.serviceRegistrar.getService(TunableSetter.class);
        return tunableSetter.createTaskIterator(new TaskIterator(2, new Task[]{writer}), m);
    }
}

