/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.vizmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewCollectionTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.util.ListSingleSelection;

public class ApplyVisualStyleTask
extends AbstractNetworkViewCollectionTask
implements ObservableTask {
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="Network", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui", required=true)
    public CyNetwork network;
    @Tunable(description="Style:", longDescription="Name of Style to be applied to the selected views.", exampleStringValue="Minimal", required=true)
    public ListSingleSelection<VisualStyle> styles;
    private Collection<CyNetworkView> selectedNetworkViews;
    private VisualStyle selectedStyle;

    @ProvidesTitle
    public String getTitle() {
        return "Apply Style";
    }

    public ApplyVisualStyleTask(Collection<CyNetworkView> views, CyServiceRegistrar serviceRegistrar) {
        super(views);
        this.serviceRegistrar = serviceRegistrar;
        VisualMappingManager vmManager = (VisualMappingManager)serviceRegistrar.getService(VisualMappingManager.class);
        ArrayList vsList = new ArrayList(vmManager.getAllVisualStyles());
        this.styles = new ListSingleSelection(vsList);
        if (!vsList.isEmpty()) {
            this.styles.setSelectedValue((Object)((VisualStyle)vsList.get(0)));
        }
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Apply Style");
        tm.setProgress(0.0);
        VisualMappingManager vmManager = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        this.selectedNetworkViews = this.network != null ? ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews(this.network) : this.networkViews;
        int viewCount = this.selectedNetworkViews.size();
        this.selectedStyle = (VisualStyle)this.styles.getSelectedValue();
        if (viewCount == 0) {
            throw new RuntimeException("No network views selected.");
        }
        if (this.selectedStyle == null) {
            throw new RuntimeException("No style selected.");
        }
        tm.setStatusMessage("Applying style '" + this.selectedStyle.getTitle() + "' to " + viewCount + " view(s)...");
        int i = 0;
        for (CyNetworkView view : this.selectedNetworkViews) {
            if (this.cancelled) {
                return;
            }
            tm.setStatusMessage(i + 1 + ": '" + DataUtils.getViewTitle(view) + "'...");
            this.selectedStyle.apply(view);
            view.updateView();
            vmManager.setVisualStyle(this.selectedStyle, view);
            tm.setProgress((double)(++i) / (double)viewCount);
        }
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        if (type == String.class) {
            Object res = "";
            if (this.selectedNetworkViews != null && !this.selectedNetworkViews.isEmpty()) {
                res = (String)res + "Style applied to views:\n";
                for (CyNetworkView view : this.selectedNetworkViews) {
                    res = (String)res + DataUtils.getViewTitle(view) + " (SUID: " + view.getSUID() + ")\n";
                }
                res = ((String)res).substring(0, ((String)res).length() - 1);
            } else {
                res = "Please select one or more views before applying a style.";
            }
            return res;
        }
        if (type == JSONResult.class) {
            String json = ((CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class)).cyIdentifiablesToJson(this.selectedNetworkViews);
            JSONResult res = () -> "{\"views\":" + json + "}";
            return res;
        }
        return this.selectedNetworkViews != null ? new ArrayList<CyNetworkView>(this.selectedNetworkViews) : Collections.emptyList();
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

