/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.view;

import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.view.NodeLocations;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.undo.AbstractCyEdit;

final class CreateNetworkViewEdit
extends AbstractCyEdit {
    private final CyNetwork network;
    private Map<CyNode, NodeLocations> nodesAndLocations;
    private double networkCenterX;
    private double networkCenterY;
    private double networkCenterZ;
    private double networkScaleFactor;
    private final CyServiceRegistrar serviceRegistrar;

    CreateNetworkViewEdit(CyNetwork network, CyServiceRegistrar serviceRegistrar) {
        super("Create Network View");
        this.network = network;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void redo() {
        CyNetworkView view = ((CyNetworkViewFactory)this.serviceRegistrar.getService(CyNetworkViewFactory.class)).createNetworkView(this.network);
        ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).addNetworkView(view);
        for (View nv : view.getNodeViews()) {
            this.nodesAndLocations.get(nv.getModel()).restoreLocations((View<CyNode>)nv);
        }
        view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, (Object)this.networkCenterX);
        view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, (Object)this.networkCenterY);
        view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION, (Object)this.networkCenterZ);
        view.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)this.networkScaleFactor);
        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).flushPayloadEvents();
        view.updateView();
    }

    public void undo() {
        CyNetworkViewManager netViewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
        Collection views = netViewManager.getNetworkViews(this.network);
        CyNetworkView view = null;
        if (views.size() != 0) {
            view = (CyNetworkView)views.iterator().next();
        }
        this.networkCenterX = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION);
        this.networkCenterY = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION);
        this.networkCenterZ = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION);
        this.networkScaleFactor = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        Collection nodeViews = view.getNodeViews();
        this.nodesAndLocations = new WeakHashMap<CyNode, NodeLocations>(nodeViews.size());
        for (View nv : nodeViews) {
            this.nodesAndLocations.put((CyNode)nv.getModel(), new NodeLocations((View<CyNode>)nv));
        }
        netViewManager.destroyNetworkView(view);
    }
}

