/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.view;

import java.util.Collection;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;

public class CopyExistingViewTask
extends AbstractTask
implements ObservableTask {
    private final CyNetworkView newView;
    private final CyNetworkView sourceView;
    private final VisualStyle style;
    private final Map<CyNode, CyNode> new2sourceNodeMap;
    private final Map<CyEdge, CyEdge> new2sourceEdgeMap;
    private final boolean fitContent;
    private final CyServiceRegistrar serviceRegistrar;

    public CopyExistingViewTask(CyNetworkView newView, CyNetworkView sourceView, VisualStyle style, Map<CyNode, CyNode> new2sourceNodeMap, Map<CyEdge, CyEdge> new2sourceEdgeMap, boolean fitContent, CyServiceRegistrar serviceRegistrar) {
        this.newView = newView;
        this.sourceView = sourceView;
        this.style = style;
        this.new2sourceNodeMap = new2sourceNodeMap;
        this.new2sourceEdgeMap = new2sourceEdgeMap;
        this.fitContent = fitContent;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Copy Existing Network View");
        tm.setProgress(0.0);
        if (this.sourceView == null) {
            throw new NullPointerException("source network view is null.");
        }
        if (this.newView == null) {
            throw new NullPointerException("new network view is null.");
        }
        RenderingEngineManager renderingEngineMgr = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
        Collection engines = renderingEngineMgr.getAllRenderingEngines();
        Collection nodeProps = null;
        Collection edgeProps = null;
        if (!engines.isEmpty()) {
            for (RenderingEngine engine : engines) {
                if (!engine.getRendererId().equals(this.sourceView.getRendererId())) continue;
                VisualLexicon lexicon = engine.getVisualLexicon();
                nodeProps = lexicon.getAllDescendants(BasicVisualLexicon.NODE);
                edgeProps = lexicon.getAllDescendants(BasicVisualLexicon.EDGE);
            }
            if (nodeProps == null || nodeProps.isEmpty()) {
                throw new IllegalArgumentException("Couldn't find network visual lexicon");
            }
        }
        if (!this.fitContent) {
            this.newView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, (Object)((Double)this.sourceView.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION)));
            this.newView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, (Object)((Double)this.sourceView.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION)));
            this.newView.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION, (Object)((Double)this.sourceView.getVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION)));
            this.newView.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)((Double)this.sourceView.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR)));
            this.newView.setVisualProperty(BasicVisualLexicon.NETWORK_WIDTH, (Object)((Double)this.sourceView.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH)));
            this.newView.setVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT, (Object)((Double)this.sourceView.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT)));
            this.newView.setVisualProperty(BasicVisualLexicon.NETWORK_DEPTH, (Object)((Double)this.sourceView.getVisualProperty(BasicVisualLexicon.NETWORK_DEPTH)));
        }
        tm.setStatusMessage("Copying node views...");
        tm.setProgress(0.1);
        for (View newNodeView : this.newView.getNodeViews()) {
            if (this.cancelled) {
                return;
            }
            View<CyNode> origNodeView = this.getOriginalNodeView((View<CyNode>)newNodeView);
            if (origNodeView == null) continue;
            newNodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)((Double)origNodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION)));
            newNodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)((Double)origNodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)));
            if (nodeProps == null) continue;
            for (VisualProperty vp : nodeProps) {
                if (!origNodeView.isValueLocked(vp)) continue;
                newNodeView.setLockedValue(vp, origNodeView.getVisualProperty(vp));
            }
        }
        tm.setStatusMessage("Copying edge views...");
        tm.setProgress(0.5);
        for (View newEdgeView : this.newView.getEdgeViews()) {
            if (this.cancelled) {
                return;
            }
            View<CyEdge> origEdgeView = this.getOriginalEdgeView((View<CyEdge>)newEdgeView);
            if (origEdgeView == null || edgeProps == null) continue;
            for (VisualProperty vp : edgeProps) {
                if (!origEdgeView.isValueLocked(vp)) continue;
                newEdgeView.setLockedValue(vp, origEdgeView.getVisualProperty(vp));
            }
        }
        tm.setStatusMessage("Applying style...");
        tm.setProgress(0.9);
        if (this.cancelled) {
            return;
        }
        if (this.style != null) {
            this.style.apply(this.newView);
            this.newView.updateView();
        }
        if (this.cancelled) {
            return;
        }
        if (this.fitContent) {
            this.newView.fitContent();
        }
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        return String.class.equals((Object)type) ? this.newView.toString() : this.newView;
    }

    private View<CyNode> getOriginalNodeView(View<CyNode> newNodeView) {
        if (this.new2sourceNodeMap != null) {
            CyNode origNode = this.new2sourceNodeMap.get(newNodeView.getModel());
            return origNode == null ? null : this.sourceView.getNodeView(origNode);
        }
        return this.sourceView.getNodeView((CyNode)newNodeView.getModel());
    }

    private View<CyEdge> getOriginalEdgeView(View<CyEdge> newEdgeView) {
        if (this.new2sourceEdgeMap != null) {
            CyEdge origEdge = this.new2sourceEdgeMap.get(newEdgeView.getModel());
            return origEdge == null ? null : this.sourceView.getEdgeView(origEdge);
        }
        return this.sourceView.getEdgeView((CyEdge)newEdgeView.getModel());
    }
}

