/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.utils;

import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.command.util.EdgeList;
import org.cytoscape.command.util.NodeList;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.Tunable;

public class NodeAndEdgeTunable {
    final CyServiceRegistrar serviceRegistrar;
    final boolean useRootNetwork;
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network = null;
    public NodeList nodeList = null;
    public EdgeList edgeList = null;

    @Tunable(description="List of nodes", context="nogui", longDescription="Specifies a list of nodes. The keywords ```all```, ```selected```, or ```unselected``` can be used to specify nodes by their selection state. The pattern ```COLUMN:VALUE``` sets this parameter to any rows that contain the specified column value; if the ```COLUMN``` prefix is not used, the NAME column is matched by default. A list of ```COLUMN:VALUE``` pairs of the format ```COLUMN1:VALUE1,COLUMN2:VALUE2,...``` can be used to match multiple values.", exampleStringValue="selected")
    public NodeList getnodeList() {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                return null;
            }
        }
        Object net = this.useRootNetwork ? ((CySubNetwork)this.network).getRootNetwork() : this.network;
        if (this.nodeList == null) {
            this.nodeList = new NodeList(net);
        } else {
            this.nodeList.setNetwork(net);
        }
        return this.nodeList;
    }

    public void setnodeList(NodeList setValue) {
    }

    @Tunable(description="List of edges", context="nogui", longDescription="Specifies a list of edges. The keywords ```all```, ```selected```, or ```unselected``` can be used to specify edges by their selection state. The pattern ```COLUMN:VALUE``` sets this parameter to any rows that contain the specified column value; if the ```COLUMN``` prefix is not used, the NAME column is matched by default. A list of ```COLUMN:VALUE``` pairs of the format ```COLUMN1:VALUE1,COLUMN2:VALUE2,...``` can be used to match multiple values.", exampleStringValue="selected")
    public EdgeList getedgeList() {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        }
        Object net = this.useRootNetwork ? ((CySubNetwork)this.network).getRootNetwork() : this.network;
        if (this.edgeList == null) {
            this.edgeList = new EdgeList(net);
        } else {
            this.edgeList.setNetwork(net);
        }
        return this.edgeList;
    }

    public void setedgeList(EdgeList setValue) {
    }

    public NodeAndEdgeTunable(CyServiceRegistrar serviceRegistrar, boolean useRootNetwork) {
        this.serviceRegistrar = serviceRegistrar;
        this.useRootNetwork = useRootNetwork;
    }

    public NodeAndEdgeTunable(CyServiceRegistrar serviceRegistrar) {
        this(serviceRegistrar, false);
    }

    public CyNetwork getNetwork() {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        }
        return this.network;
    }

    public List<CyNode> getNodeList() {
        return this.getNodeList(true);
    }

    public List<CyNode> getNodeList(boolean useAllForDefault) {
        if (this.nodeList == null || this.nodeList.getValue() == null) {
            if (useAllForDefault) {
                return this.getNetwork().getNodeList();
            }
            return null;
        }
        return this.nodeList.getValue();
    }

    public List<CyEdge> getEdgeList() {
        return this.getEdgeList(true);
    }

    public List<CyEdge> getEdgeList(boolean useAllForDefault) {
        if (this.edgeList == null || this.edgeList.getValue() == null) {
            if (useAllForDefault) {
                return this.getNetwork().getEdgeList();
            }
            return null;
        }
        return this.edgeList.getValue();
    }
}

