/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public final class RenameColumnCommandTask
extends AbstractTask
implements ObservableTask {
    private CyTable table;
    @Tunable(description="New Column Name", longDescription="The new name of the column.", exampleStringValue="NewColumnName", required=true)
    public String newColumnName;
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="Column name", longDescription="The name of the column that will be renamed.", exampleStringValue="ColumnName", context="nogui", required=true)
    public String columnName;
    CyColumn column;

    @ProvidesTitle
    public String getTitle() {
        return "Rename Column";
    }

    RenameColumnCommandTask(CyServiceRegistrar serviceRegistrar) {
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        this.table = this.tableTunable.getTable();
        if (this.table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.columnName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column name must be specified");
            return;
        }
        if (this.newColumnName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "New column name must be specified");
            return;
        }
        this.column = this.table.getColumn(this.columnName);
        if (this.column == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find column " + this.columnName + " in table " + this.table.toString());
            return;
        }
        this.column.setName(this.newColumnName);
    }

    public <R> R getResults(Class<? extends R> type) {
        if (type.equals(String.class)) {
            if (this.column == null) {
                return (R)"Unable to rename column";
            }
            String res = "Renamed column " + this.columnName + " in table " + this.tableTunable.getTable() + " to " + this.newColumnName;
            return (R)res;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.table == null || this.column == null) {
                    return "{}";
                }
                return "{\"table\":" + this.table.getSUID() + ", \"column\":\"" + this.newColumnName + "\"}";
            };
            return (R)res;
        }
        return (R)this.column;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyColumn.class, String.class, JSONResult.class);
    }
}

