/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;

public final class MapGlobalToLocalTableTask
extends AbstractTask {
    private final CyTable globalTable;
    @Tunable(description="Link Selected Table to:")
    public ListMultipleSelection<String> localTables;
    private final Map<String, CyTable> name2tableMap;

    MapGlobalToLocalTableTask(CyTable globalTable, CyTableManager tableManager, CyNetworkManager networkManager) {
        Set allNetworks = networkManager.getNetworkSet();
        if (globalTable == null) {
            throw new IllegalStateException("No Global Table is selected.");
        }
        if (allNetworks.size() == 0) {
            throw new IllegalStateException("No network in current session.  You need at least one network.");
        }
        this.name2tableMap = new HashMap<String, CyTable>();
        this.globalTable = globalTable;
        ArrayList<String> locals = new ArrayList<String>();
        for (CyNetwork network : allNetworks) {
            locals.add(network.getDefaultNodeTable().getTitle());
            this.name2tableMap.put(network.getDefaultNodeTable().getTitle(), network.getDefaultNodeTable());
            locals.add(network.getDefaultEdgeTable().getTitle());
            this.name2tableMap.put(network.getDefaultEdgeTable().getTitle(), network.getDefaultEdgeTable());
            locals.add(network.getDefaultNetworkTable().getTitle());
            this.name2tableMap.put(network.getDefaultNetworkTable().getTitle(), network.getDefaultNetworkTable());
        }
        this.name2tableMap.put(this.globalTable.getTitle(), this.globalTable);
        this.localTables = new ListMultipleSelection(locals);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        for (String selected : this.localTables.getSelectedValues()) {
            CyTable localTable = this.name2tableMap.get(selected);
            this.mapTable(localTable, this.globalTable);
        }
    }

    private void mapTable(CyTable localTable, CyTable globalTable) {
        if (globalTable.getPrimaryKey().getType() != String.class) {
            throw new IllegalStateException("Local table's primary key should be type String.");
        }
        CyColumn trgCol = localTable.getColumn("name");
        if (trgCol != null) {
            localTable.addVirtualColumns(globalTable, "name", false);
        }
    }
}

