/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.RowTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListRowsTask
extends AbstractTableDataTask
implements ObservableTask {
    List<CyRow> rowList;
    CyTable table;
    @ContainsTunables
    public RowTunable rowTunable;

    public ListRowsTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.rowTunable = new RowTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        this.table = this.rowTunable.getTable();
        if (this.table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.rowTunable.getTableString() + "'");
            return;
        }
        this.rowList = this.rowTunable.getRowList();
        if (this.rowList == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "No rows returned");
            return;
        }
        String primaryKey = this.table.getPrimaryKey().getName();
        CyColumn nameColumn = this.table.getColumn("name");
        String nameKey = null;
        if (nameColumn != null) {
            nameKey = nameColumn.getName();
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Retreived " + this.rowList.size() + " rows:");
        for (CyRow row : this.rowList) {
            String message = "     Key: " + row.getRaw(primaryKey).toString();
            if (nameKey != null) {
                message = message + " Name: " + (String)row.get(nameKey, String.class);
            }
            tm.showMessage(TaskMonitor.Level.INFO, message);
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return DataUtils.convertData(this.rowList);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                String out = this.rowListAsJson();
                return out;
            };
            return res;
        }
        return this.rowList;
    }

    String rowListAsJson() {
        if (this.rowList == null || this.rowList.size() == 0) {
            return "{}";
        }
        String primaryKey = this.table.getPrimaryKey().getName();
        StringJoiner rows = new StringJoiner(",", "[", "]");
        for (CyRow row : this.rowList) {
            rows.add("\"" + row.getRaw(primaryKey).toString() + "\"");
        }
        return "{\"table\":" + this.table.getSUID() + ", \"rows\": " + rows.toString() + "}";
    }
}

