/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class ListColumnsTask
extends AbstractTableDataTask
implements ObservableTask {
    List<CyColumn> columns;
    @ContainsTunables
    public TableTunable table;

    public ListColumnsTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.table = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        CyTable requestedTable = this.table.getTable();
        if (requestedTable == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.table.getTableString() + "'");
            return;
        }
        this.columns = new ArrayList<CyColumn>(requestedTable.getColumns());
        tm.showMessage(TaskMonitor.Level.INFO, "Columns for table " + this.getTableDescription(requestedTable) + ":");
        for (CyColumn column : this.columns) {
            tm.showMessage(TaskMonitor.Level.INFO, "         " + column.toString());
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class) && this.columns != null) {
            return DataUtils.convertData(this.columns);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.columns == null) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                return cyJSONUtil.cyColumnsToJson(this.columns);
            };
            return res;
        }
        if (requestedType.equals(List.class)) {
            return this.columns;
        }
        return null;
    }

    private String getTableDescription(CyTable table) {
        String result = "[" + table.getSUID() + "]";
        int rows = table.getRowCount();
        int cols = table.getColumns().size();
        result = result + " is a " + (table.isPublic() ? "public" : "private") + " table with ";
        result = result + rows + " rows and " + cols + " columns with title:\n";
        result = result + "        " + table.getTitle();
        return result;
    }
}

