/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.task.internal.table.SaveColumn;
import org.cytoscape.work.undo.AbstractCyEdit;

final class DeleteColumnEdit
extends AbstractCyEdit {
    private final CyTable table;
    private final String columnName;
    private final Class<?> columnType;
    private SaveColumn savedColumn;

    DeleteColumnEdit(CyColumn column) {
        super("Delete Column");
        this.table = column.getTable();
        this.columnName = column.getName();
        this.columnType = column.getType();
        this.savedColumn = new SaveColumn(this.table, this.columnName);
    }

    public void redo() {
        this.savedColumn = new SaveColumn(this.table, this.columnName);
        this.table.deleteColumn(this.columnName);
    }

    public void undo() {
        this.table.createColumn(this.columnName, this.columnType, false);
        this.savedColumn.restoreColumn(this.table, this.columnName);
        this.savedColumn = null;
    }
}

