/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.ColumnTypeTunable;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class CreateColumnTask
extends AbstractTableDataTask
implements ObservableTask {
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="Name of column", context="nogui", longDescription="The new column name", exampleStringValue="Uncertainty")
    public String columnName;
    @ContainsTunables
    public ColumnTypeTunable columnType;
    private CyTable table;

    public CreateColumnTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
        this.columnType = new ColumnTypeTunable();
    }

    public void run(TaskMonitor tm) {
        this.table = this.tableTunable.getTable();
        if (this.table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.columnName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column name must be specified");
            return;
        }
        this.columnName = this.columnName.trim();
        if (this.columnName.isEmpty()) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column name must not be blank");
            return;
        }
        CyColumn c = this.table.getColumn(this.columnName);
        if (c != null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column '" + this.columnName + "' already exists in table: " + this.table.toString());
            return;
        }
        String baseTypeName = this.columnType.getColumnType();
        if (baseTypeName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Column type must be specified.");
            return;
        }
        Class baseType = DataUtils.getType(baseTypeName);
        if (baseType.equals(List.class)) {
            String listTypeName = this.columnType.getListElementType();
            if (listTypeName == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "List element type must be specified for list columns.");
                return;
            }
            Class listType = DataUtils.getType(listTypeName);
            this.table.createListColumn(this.columnName, listType, false);
            tm.showMessage(TaskMonitor.Level.INFO, "Created list column: " + this.columnName);
        } else {
            this.table.createColumn(this.columnName, baseType, false);
            tm.showMessage(TaskMonitor.Level.INFO, "Created column: " + this.columnName);
        }
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(CyColumn.class, String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(CyColumn.class)) {
            return this.tableTunable.getTable().getColumn(this.columnName);
        }
        if (requestedType.equals(String.class)) {
            return this.columnName;
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.table == null || this.columnName == null) {
                    return "{}";
                }
                return "{\"table\":" + this.table.getSUID() + ",\"column\" : \"" + this.columnName + "\"}";
            };
            return res;
        }
        return null;
    }
}

