/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableCellTask;
import org.cytoscape.task.internal.table.CopyValueToColumnEdit;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

final class CopyValueToColumnTask
extends AbstractTableCellTask {
    private final boolean selectedOnly;
    private final String taskFactoryName;
    private final CyServiceRegistrar serviceRegistrar;

    CopyValueToColumnTask(CyColumn column, Object primaryKeyValue, boolean selectedOnly, String taskFactoryName, CyServiceRegistrar serviceRegistrar) {
        super(column, primaryKeyValue);
        this.selectedOnly = selectedOnly;
        this.taskFactoryName = taskFactoryName;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Copying...");
        CyRow sourceRow = this.column.getTable().getRow(this.primaryKeyValue);
        String columnName = this.column.getName();
        Object sourceValue = sourceRow.getRaw(columnName);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new CopyValueToColumnEdit(this.column, sourceValue, this.taskFactoryName));
        List rows = this.column.getTable().getAllRows();
        int total = rows.size() - 1;
        int count = 0;
        for (CyRow row : rows) {
            if (row == sourceRow || this.selectedOnly && !((Boolean)row.get("selected", Boolean.class)).booleanValue()) continue;
            row.set(columnName, sourceValue);
            if (++count % 1000 != 0) continue;
            taskMonitor.setProgress(100.0 * (double)count / (double)total);
        }
    }
}

