/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.task.internal.table.SaveColumn;
import org.cytoscape.work.undo.AbstractCyEdit;

final class CopyValueToColumnEdit
extends AbstractCyEdit {
    private final CyTable table;
    private final String columnName;
    private final Object value;
    private SaveColumn savedColumn;

    CopyValueToColumnEdit(CyColumn column, Object value, String taskFactoryName) {
        super(taskFactoryName);
        this.table = column.getTable();
        this.columnName = column.getName();
        this.value = value;
        this.savedColumn = new SaveColumn(this.table, this.columnName);
    }

    public void redo() {
        this.savedColumn = new SaveColumn(this.table, this.columnName);
        List rows = this.table.getAllRows();
        for (CyRow row : rows) {
            row.set(this.columnName, this.value);
        }
    }

    public void undo() {
        this.savedColumn.restoreColumn(this.table, this.columnName);
        this.savedColumn = null;
    }
}

