/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.session;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.cg.event.CustomGraphicsReadyToBeLoadedEvent;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.read.CySessionReaderManager;
import org.cytoscape.io.util.RecentlyOpenedTracker;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.task.internal.session.AbstractOpenSessionTask;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSessionCommandTask
extends AbstractOpenSessionTask {
    public static final String TEMP_FILE_EXT = ".tmpCYS";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    @Tunable(description="Session file to load:", longDescription="The path to the session file (.cys) to be loaded.", exampleStringValue="/Users/johndoe/Downloads/MySession.cys", params="fileCategory=session;input=true", context="nogui")
    public File file;
    @Tunable(description="URL from which to load the session file:", longDescription="A URL that provides a session file.", exampleStringValue="/Users/johndoe/Downloads/MySession.cys", params="fileCategory=session;input=true", context="nogui")
    public String url;
    private File tmpFile;

    @ProvidesTitle
    public String getTitle() {
        return "Open Session";
    }

    public OpenSessionCommandTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor tm) throws Exception {
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        CySessionManager sessionManager = (CySessionManager)this.serviceRegistrar.getService(CySessionManager.class);
        try {
            try {
                tm.setTitle("Open Session");
                tm.setStatusMessage("Opening Session File.\n\nIt may take a while.\nPlease wait...");
                tm.setProgress(0.0);
                if (this.url != null) {
                    this.url = this.url.trim();
                }
                if (this.file == null && (this.url == null || this.url.isEmpty())) {
                    throw new NullPointerException("No file or URL specified.");
                }
                CySessionReaderManager readerMgr = (CySessionReaderManager)this.serviceRegistrar.getService(CySessionReaderManager.class);
                if (this.url != null && this.file == null && !this.url.toLowerCase().startsWith("file://")) {
                    FileOutputStream tmpStream = null;
                    try (ReadableByteChannel channel = Channels.newChannel(new URL(this.url).openStream());){
                        this.tmpFile = File.createTempFile(this.url, TEMP_FILE_EXT);
                        this.tmpFile.deleteOnExit();
                        tmpStream = new FileOutputStream(this.tmpFile);
                        tmpStream.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
                        this.file = this.tmpFile;
                    }
                    catch (Exception e) {
                        logger.error("Cannot create temp file for remote session file.", (Throwable)e);
                    }
                    finally {
                        if (tmpStream != null) {
                            try {
                                tmpStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                this.reader = this.file != null ? readerMgr.getReader(this.file.toURI(), this.file.getName()) : readerMgr.getReader(new URI(this.url), this.url);
                if (this.reader == null) {
                    throw new NullPointerException("Failed to find appropriate reader for file: " + this.file);
                }
                eventHelper.fireEvent((CyEvent)new SessionAboutToBeLoadedEvent((Object)this));
                tm.setProgress(0.1);
                ((CySessionManager)this.serviceRegistrar.getService(CySessionManager.class)).disposeCurrentSession();
                tm.setProgress(0.2);
                if (!this.cancelled) {
                    this.reader.run(tm);
                    tm.setProgress(0.7);
                    eventHelper.fireEvent((CyEvent)new CustomGraphicsReadyToBeLoadedEvent((Object)this, this.reader.getSession()));
                }
                tm.setProgress(0.8);
            }
            catch (Exception e) {
                this.disposeCancelledSession(e, sessionManager);
                throw e;
            }
            if (this.cancelled) {
                this.disposeCancelledSession(null, sessionManager);
            } else {
                this.changeCurrentSession(sessionManager, tm);
            }
        }
        finally {
            this.reader = null;
            if (this.tmpFile != null) {
                try {
                    this.tmpFile.delete();
                }
                catch (Exception e) {
                    logger.error("Cannot delete temp cys file.", (Throwable)e);
                }
                this.file = null;
                this.tmpFile = null;
            }
        }
    }

    private void changeCurrentSession(CySessionManager sessionManager, TaskMonitor tm) throws Exception {
        CySession newSession = this.reader.getSession();
        if (newSession == null) {
            throw new NullPointerException("Session could not be read for: " + (Serializable)(this.file != null ? this.file : this.url));
        }
        String fileName = this.file != null ? this.file.getAbsolutePath() : FilenameUtils.getName((String)new URL(this.url).getPath());
        sessionManager.setCurrentSession(newSession, fileName);
        CyApplicationManager appManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        RenderingEngine currentEngine = appManager.getCurrentRenderingEngine();
        if (currentEngine != null) {
            appManager.setCurrentRenderingEngine(currentEngine);
        }
        tm.setProgress(1.0);
        tm.setStatusMessage("Session file " + fileName + " successfully loaded.");
        if (this.file != null) {
            ((RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class)).add(this.file.toURI().toURL());
        }
    }
}

