/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.select.SelectionEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class SelectFromFileListTask
extends AbstractSelectTask {
    @Tunable(description="Node selection file:", params="input=true", longDescription="Path to file containing list of nodes to select")
    public File file;

    @ProvidesTitle
    public String getTitle() {
        return "Select Nodes using ID File";
    }

    public SelectFromFileListTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        if (this.file == null) {
            throw new NullPointerException("You must specify a non-null file to load.");
        }
        CyNetworkView view = this.getNetworkView(this.network);
        SelectionEdit edit = new SelectionEdit("Select Nodes From File", this.network, view, SelectionEdit.SelectionFilter.NODES_ONLY, this.serviceRegistrar);
        tm.setProgress(0.1);
        try {
            String s;
            FileReader fin = new FileReader(this.file);
            BufferedReader bin = new BufferedReader(fin);
            HashSet<String> fileNodes = new HashSet<String>();
            tm.setProgress(0.2);
            while ((s = bin.readLine()) != null) {
                String trimName = s.trim();
                if (trimName.length() <= 0) continue;
                fileNodes.add(trimName);
            }
            fin.close();
            tm.setProgress(0.6);
            List nodeList = this.network.getNodeList();
            for (CyNode node : nodeList) {
                if (!fileNodes.contains(this.network.getRow((CyIdentifiable)node).get("name", String.class))) continue;
                this.network.getRow((CyIdentifiable)node).set("selected", (Object)true);
            }
            tm.setProgress(0.8);
            this.updateView();
        }
        catch (Exception e) {
            throw new Exception("Error reading file: " + this.file.getAbsolutePath(), e);
        }
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)edit);
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class);
    }
}

