/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.HashSet;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.SelectUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class SelectFirstNeighborsNodeViewTask
extends AbstractTask {
    private View<CyNode> nodeView;
    private CyNetworkView netView;
    private final CyEdge.Type direction;
    private final SelectUtils selectUtils;

    public SelectFirstNeighborsNodeViewTask(View<CyNode> nodeView, CyNetworkView netView, CyEdge.Type direction, CyServiceRegistrar serviceRegistrar) {
        this.nodeView = nodeView;
        this.netView = netView;
        this.direction = direction;
        this.selectUtils = new SelectUtils(serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Select First Neighbors (Node View)");
        tm.setProgress(0.0);
        if (this.nodeView == null) {
            throw new NullPointerException("node view is null");
        }
        if (this.netView == null) {
            throw new NullPointerException("network view is null");
        }
        HashSet<CyNode> selNodes = new HashSet<CyNode>();
        CyNode node = (CyNode)this.nodeView.getModel();
        CyNetwork net = (CyNetwork)this.netView.getModel();
        tm.setProgress(0.1);
        selNodes.add(node);
        tm.setProgress(0.4);
        selNodes.addAll(net.getNeighborList(node, this.direction));
        tm.setProgress(0.6);
        this.selectUtils.setSelectedNodes(net, selNodes, true);
        tm.setProgress(0.8);
        this.netView.updateView();
        tm.setProgress(1.0);
    }
}

