/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.HashSet;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.AbstractSelectTask;
import org.cytoscape.task.internal.select.SelectionEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class SelectEdgesBetweenSelectedNodesTask
extends AbstractSelectTask {
    public SelectEdgesBetweenSelectedNodesTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        super(net, serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Select Edgdes between Selected Nodes");
        tm.setProgress(0.0);
        CyNetworkView view = this.getNetworkView(this.network);
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new SelectionEdit("Select Edgdes between Selected Nodes", this.network, view, SelectionEdit.SelectionFilter.EDGES_ONLY, this.serviceRegistrar));
        tm.setStatusMessage("Selecting Edges...");
        tm.setProgress(0.2);
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true);
        HashSet<CyEdge> edgeSet = new HashSet<CyEdge>();
        for (CyNode node1 : selectedNodes) {
            for (CyNode node2 : selectedNodes) {
                edgeSet.addAll(this.network.getConnectingEdgeList(node1, node2, CyEdge.Type.ANY));
            }
        }
        tm.setProgress(0.3);
        this.selectUtils.setSelectedEdges(this.network, edgeSet, true);
        tm.setStatusMessage("Updating View...");
        tm.setProgress(0.9);
        this.updateView();
        tm.setProgress(1.0);
    }
}

