/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.Collection;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.SelectUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTask;

public abstract class AbstractSelectTask
extends AbstractTask {
    protected CyNetwork network;
    protected final SelectUtils selectUtils;
    protected final CyServiceRegistrar serviceRegistrar;

    public AbstractSelectTask(CyNetwork net, CyServiceRegistrar serviceRegistrar) {
        this.network = net;
        this.selectUtils = new SelectUtils(serviceRegistrar);
        this.serviceRegistrar = serviceRegistrar;
    }

    protected CyNetworkView getNetworkView(CyNetwork network) {
        CyNetworkView view = null;
        CyNetworkView currentView = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        if (currentView != null && ((CyNetwork)currentView.getModel()).equals(network)) {
            view = currentView;
        } else {
            Collection views = ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews(network);
            if (!views.isEmpty()) {
                view = (CyNetworkView)views.iterator().next();
            }
        }
        return view;
    }

    protected final void updateView() {
        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).flushPayloadEvents();
    }
}

