/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.networkobjects.AbstractPropertyTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class SetNetworkPropertiesTask
extends AbstractPropertyTask {
    @Tunable(description="Whether or not to lock the property", context="nogui", longDescription="Locking a visual property will override any mappings.  This is the same as the ```Bypass``` column in the user interface", exampleStringValue="true")
    public boolean bypass = false;
    @Tunable(description="Network to set properties for", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network = null;
    @Tunable(description="Properties to set the values for", context="nogui", longDescription="A comma-separated list of network properties", exampleStringValue="background paint,title", required=true)
    public String propertyList = null;
    @Tunable(description="Values to set for the properties", context="nogui", required=true, longDescription="A comma-separated list of property values.  This list must have the same number of elements as the ``propertyList``.  Each value will be applied to the property specified in the same position in the ``propertyList``", exampleStringValue="white,My network title")
    public String valueList = null;

    public SetNetworkPropertiesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        String[] values;
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        if (this.propertyList == null || this.propertyList.length() == 0) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Property list must be specified");
            throw new RuntimeException("Property list must be specified");
        }
        if (this.valueList == null || this.valueList.length() == 0) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Value list must be specified");
            throw new RuntimeException("Value list must be specified");
        }
        String[] props = this.propertyList.split(",");
        if (props.length != (values = DataUtils.getCSV(this.valueList)).length) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Property list and value list are not the same length");
            throw new RuntimeException("Property list and value list are not the same length");
        }
        int valueIndex = 0;
        for (String property : props) {
            String value = values[valueIndex];
            try {
                VisualProperty<?> vp = this.getProperty(this.network, (CyIdentifiable)this.network, property.trim());
                this.setPropertyValue(this.network, (CyIdentifiable)this.network, vp, value, this.bypass);
                tm.showMessage(TaskMonitor.Level.INFO, DataUtils.getNetworkName(this.network) + " " + vp.getDisplayName() + " set to " + value.toString());
            }
            catch (Exception e) {
                tm.showMessage(TaskMonitor.Level.ERROR, e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

