/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.networkobjects;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.undo.AbstractCyEdit;

final class DeleteEdit
extends AbstractCyEdit {
    private final List<CyNode> nodes;
    private final Set<CyEdge> edges;
    private final double[] xPos;
    private final double[] yPos;
    private final Map<CyIdentifiable, Map<VisualProperty<?>, Object>> bypassMap;
    private final CySubNetwork net;
    private final CyNetworkViewManager netViewMgr;
    private final VisualMappingManager visualMappingManager;
    private final CyEventHelper eventHelper;

    DeleteEdit(CySubNetwork net, List<CyNode> nodes, Set<CyEdge> edges, CyNetworkViewManager netViewMgr, VisualMappingManager visualMappingManager, CyEventHelper eventHelper) {
        super("Delete");
        if (net == null) {
            throw new NullPointerException("network is null");
        }
        this.net = net;
        if (netViewMgr == null) {
            throw new NullPointerException("network manager is null");
        }
        this.netViewMgr = netViewMgr;
        if (nodes == null) {
            throw new NullPointerException("nodes is null");
        }
        this.nodes = nodes;
        if (edges == null) {
            throw new NullPointerException("edges is null");
        }
        this.edges = edges;
        if (visualMappingManager == null) {
            throw new NullPointerException("visualMappingManager is null");
        }
        this.visualMappingManager = visualMappingManager;
        if (eventHelper == null) {
            throw new NullPointerException("eventHelper is null");
        }
        this.eventHelper = eventHelper;
        this.bypassMap = new HashMap();
        this.xPos = new double[nodes.size()];
        this.yPos = new double[nodes.size()];
        Collection views = netViewMgr.getNetworkViews((CyNetwork)net);
        CyNetworkView netView = null;
        if (views.size() != 0) {
            netView = (CyNetworkView)views.iterator().next();
        }
        if (netView != null) {
            VisualLexicon lexicon = (VisualLexicon)visualMappingManager.getAllVisualLexicon().iterator().next();
            Collection nodeProps = lexicon.getAllDescendants(BasicVisualLexicon.NODE);
            Collection edgeProps = lexicon.getAllDescendants(BasicVisualLexicon.EDGE);
            int i = 0;
            for (CyNode n : nodes) {
                View nv = netView.getNodeView(n);
                this.saveLockedValues((View<? extends CyIdentifiable>)nv, nodeProps);
                this.xPos[i] = (Double)nv.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
                this.yPos[i] = (Double)nv.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
                ++i;
            }
            for (CyEdge e : edges) {
                View ev = netView.getEdgeView(e);
                this.saveLockedValues((View<? extends CyIdentifiable>)ev, edgeProps);
            }
        }
    }

    public void redo() {
        this.net.removeEdges(this.edges);
        this.net.removeNodes(this.nodes);
        Collection views = this.netViewMgr.getNetworkViews((CyNetwork)this.net);
        CyNetworkView netView = null;
        if (views.size() != 0) {
            netView = (CyNetworkView)views.iterator().next();
        }
        netView.updateView();
    }

    public void undo() {
        for (CyNode n : this.nodes) {
            this.net.addNode(n);
        }
        for (CyEdge e : this.edges) {
            this.net.addEdge(e);
        }
        this.eventHelper.flushPayloadEvents();
        Collection views = this.netViewMgr.getNetworkViews((CyNetwork)this.net);
        CyNetworkView netView = null;
        if (views.size() != 0) {
            netView = (CyNetworkView)views.iterator().next();
        }
        VisualStyle style = this.visualMappingManager.getVisualStyle(netView);
        if (netView != null) {
            int i = 0;
            for (CyNode node : this.nodes) {
                View nodeView = netView.getNodeView(node);
                if (nodeView == null) continue;
                nodeView.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)this.xPos[i]);
                nodeView.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)this.yPos[i]);
                this.setLockedValues((View<? extends CyIdentifiable>)nodeView);
                style.apply(this.net.getRow((CyIdentifiable)node), nodeView);
                ++i;
            }
            for (CyEdge edge : this.edges) {
                View edgeView = netView.getEdgeView(edge);
                if (edgeView == null) continue;
                this.setLockedValues((View<? extends CyIdentifiable>)edgeView);
                style.apply(this.net.getRow((CyIdentifiable)edge), edgeView);
            }
        }
        netView.updateView();
    }

    private void saveLockedValues(View<? extends CyIdentifiable> view, Collection<VisualProperty<?>> visualProps) {
        for (VisualProperty<?> vp : visualProps) {
            if (!view.isValueLocked(vp)) continue;
            Map<VisualProperty<?>, Object> vpMap = this.bypassMap.get(view.getModel());
            if (vpMap == null) {
                vpMap = new HashMap();
                this.bypassMap.put((CyIdentifiable)view.getModel(), vpMap);
            }
            vpMap.put(vp, view.getVisualProperty(vp));
        }
    }

    private void setLockedValues(View<? extends CyIdentifiable> view) {
        Map<VisualProperty<?>, Object> vpMap = this.bypassMap.get(view.getModel());
        if (vpMap != null) {
            for (Map.Entry<VisualProperty<?>, Object> entry : vpMap.entrySet()) {
                view.setLockedValue(entry.getKey(), entry.getValue());
            }
        }
    }
}

