/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.VirtualColumnInfo;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CyNetworkNaming;
import org.cytoscape.task.internal.network.AbstractCreationTask;
import org.cytoscape.task.internal.network.GroupUtils;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.view.CreateNetworkViewTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.events.TableViewAddedEvent;
import org.cytoscape.view.model.events.TableViewAddedListener;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.table.BasicTableVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

abstract class AbstractNetworkFromSelectionTask
extends AbstractCreationTask {
    protected final CyApplicationManager applicationManager;
    protected final CyRootNetworkManager rootNetManager;
    protected final CyNetworkManager netManager;
    protected final CyNetworkViewManager viewManager;
    protected final CyNetworkViewFactory viewFactory;
    protected final CyNetworkNaming netNaming;
    protected final CyGroupManager groupManager;
    protected final CyTableViewManager tableViewManager;
    protected final RenderingEngineManager renderingEngineManager;
    protected final CyEventHelper eventHelper;
    protected CySubNetwork newNet;

    public AbstractNetworkFromSelectionTask(CyNetwork parentNetwork, CyServiceRegistrar serviceRegistrar) {
        super(parentNetwork, serviceRegistrar);
        this.applicationManager = (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class);
        this.rootNetManager = (CyRootNetworkManager)serviceRegistrar.getService(CyRootNetworkManager.class);
        this.netManager = (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class);
        this.viewManager = (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class);
        this.viewFactory = (CyNetworkViewFactory)serviceRegistrar.getService(CyNetworkViewFactory.class);
        this.netNaming = (CyNetworkNaming)serviceRegistrar.getService(CyNetworkNaming.class);
        this.groupManager = (CyGroupManager)serviceRegistrar.getService(CyGroupManager.class);
        this.tableViewManager = (CyTableViewManager)serviceRegistrar.getService(CyTableViewManager.class);
        this.renderingEngineManager = (RenderingEngineManager)serviceRegistrar.getService(RenderingEngineManager.class);
        this.eventHelper = (CyEventHelper)serviceRegistrar.getService(CyEventHelper.class);
    }

    abstract Set<CyNode> getNodes(CyNetwork var1);

    abstract Set<CyEdge> getEdges(CyNetwork var1);

    String getNetworkName() {
        return this.netNaming.getSuggestedSubnetworkTitle(this.parentNetwork);
    }

    public void run(TaskMonitor tm) {
        NetworkViewRenderer networkViewRenderer;
        tm.setProgress(0.0);
        if (this.parentNetwork == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Source network must be specified.");
            return;
        }
        Collection views = this.viewManager.getNetworkViews(this.parentNetwork);
        CyNetworkView sourceView = null;
        if (views.size() != 0) {
            sourceView = (CyNetworkView)views.iterator().next();
        }
        tm.setProgress(0.1);
        Set<CyNode> nodes = this.getNodes(this.parentNetwork);
        tm.setProgress(0.2);
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("No nodes are selected.");
        }
        this.newNet = this.rootNetManager.getRootNetwork(this.parentNetwork).addSubNetwork();
        this.addColumns(this.parentNetwork.getTable(CyNode.class, "LOCAL_ATTRS"), this.newNet.getTable(CyNode.class, "LOCAL_ATTRS"));
        this.addColumns(this.parentNetwork.getTable(CyEdge.class, "LOCAL_ATTRS"), this.newNet.getTable(CyEdge.class, "LOCAL_ATTRS"));
        this.addColumns(this.parentNetwork.getTable(CyNetwork.class, "LOCAL_ATTRS"), this.newNet.getTable(CyNetwork.class, "LOCAL_ATTRS"));
        tm.setProgress(0.3);
        for (CyNode node : nodes) {
            this.newNet.addNode(node);
            this.cloneRow(this.parentNetwork.getRow((CyIdentifiable)node), this.newNet.getRow((CyIdentifiable)node));
            this.newNet.getRow((CyIdentifiable)node).set("selected", (Object)false);
            if (!this.groupManager.isGroup(node, this.parentNetwork)) continue;
            CyGroup group = this.groupManager.getGroup(node, this.parentNetwork);
            GroupUtils.addGroupToNetwork(group, this.parentNetwork, (CyNetwork)this.newNet);
        }
        tm.setProgress(0.4);
        for (CyEdge edge : this.getEdges(this.parentNetwork)) {
            this.newNet.addEdge(edge);
            this.cloneRow(this.parentNetwork.getRow((CyIdentifiable)edge), this.newNet.getRow((CyIdentifiable)edge));
            this.newNet.getRow((CyIdentifiable)edge).set("selected", (Object)false);
        }
        tm.setProgress(0.5);
        this.newNet.getRow((CyIdentifiable)this.newNet).set("name", (Object)this.getNetworkName());
        DataUtils.saveParentNetworkSUID(this.newNet, this.parentNetwork.getSUID());
        this.netManager.addNetwork((CyNetwork)this.newNet, false);
        tm.setProgress(0.6);
        CopyTableVisualPropertiesListener nodeTableListener = new CopyTableVisualPropertiesListener(this.serviceRegistrar, this.parentNetwork.getTable(CyNode.class, "USER"), this.newNet.getTable(CyNode.class, "USER"));
        CopyTableVisualPropertiesListener edgeTableListener = new CopyTableVisualPropertiesListener(this.serviceRegistrar, this.parentNetwork.getTable(CyEdge.class, "USER"), this.newNet.getTable(CyEdge.class, "USER"));
        CopyTableVisualPropertiesListener netTableListener = new CopyTableVisualPropertiesListener(this.serviceRegistrar, this.parentNetwork.getTable(CyNetwork.class, "USER"), this.newNet.getTable(CyNetwork.class, "USER"));
        this.serviceRegistrar.registerService((Object)nodeTableListener, TableViewAddedListener.class);
        this.serviceRegistrar.registerService((Object)edgeTableListener, TableViewAddedListener.class);
        this.serviceRegistrar.registerService((Object)netTableListener, TableViewAddedListener.class);
        HashSet<CyNetwork> networks = new HashSet<CyNetwork>();
        networks.add((CyNetwork)this.newNet);
        CyNetworkViewFactory sourceViewFactory = this.viewFactory;
        if (sourceView != null && (networkViewRenderer = this.applicationManager.getNetworkViewRenderer(sourceView.getRendererId())) != null) {
            sourceViewFactory = networkViewRenderer.getNetworkViewFactory();
        }
        CreateNetworkViewTask createViewTask = new CreateNetworkViewTask(networks, sourceViewFactory, this.netManager, null, this.applicationManager, sourceView, this.serviceRegistrar);
        this.insertTasksAfterCurrentTask(new Task[]{createViewTask});
        tm.setProgress(1.0);
    }

    private void addColumns(CyTable parentTable, CyTable subTable) {
        ArrayList<CyColumn> colsToAdd = new ArrayList<CyColumn>();
        for (CyColumn col : parentTable.getColumns()) {
            if (subTable.getColumn(col.getName()) != null) continue;
            colsToAdd.add(col);
        }
        for (CyColumn col : colsToAdd) {
            VirtualColumnInfo colInfo = col.getVirtualColumnInfo();
            if (colInfo.isVirtual()) {
                this.addVirtualColumn(col, subTable);
                continue;
            }
            this.copyColumn(col, subTable);
        }
    }

    private void addVirtualColumn(CyColumn col, CyTable subTable) {
        VirtualColumnInfo colInfo = col.getVirtualColumnInfo();
        CyColumn checkCol = subTable.getColumn(col.getName());
        if (checkCol == null) {
            subTable.addVirtualColumn(col.getName(), colInfo.getSourceColumn(), colInfo.getSourceTable(), colInfo.getTargetJoinKey(), col.isImmutable());
        } else if (!(checkCol.getVirtualColumnInfo().isVirtual() && checkCol.getVirtualColumnInfo().getSourceTable().equals(colInfo.getSourceTable()) && checkCol.getVirtualColumnInfo().getSourceColumn().equals(colInfo.getSourceColumn()))) {
            subTable.addVirtualColumn(col.getName(), colInfo.getSourceColumn(), colInfo.getSourceTable(), colInfo.getTargetJoinKey(), col.isImmutable());
        }
    }

    private void copyColumn(CyColumn col, CyTable subTable) {
        if (List.class.isAssignableFrom(col.getType())) {
            subTable.createListColumn(col.getName(), col.getListElementType(), false);
        } else {
            subTable.createColumn(col.getName(), col.getType(), false);
        }
    }

    private void cloneRow(CyRow from, CyRow to) {
        for (CyColumn column : from.getTable().getColumns()) {
            if (column.getVirtualColumnInfo().isVirtual()) continue;
            to.set(column.getName(), from.getRaw(column.getName()));
        }
    }

    private static class CopyTableVisualPropertiesListener
    implements TableViewAddedListener {
        private final CyServiceRegistrar registrar;
        private final CyTable parentTable;
        private final CyTable subTable;

        public CopyTableVisualPropertiesListener(CyServiceRegistrar registrar, CyTable parentTable, CyTable subTable) {
            this.registrar = registrar;
            this.parentTable = parentTable;
            this.subTable = subTable;
        }

        public void handleEvent(TableViewAddedEvent e) {
            CyTableView tableView = e.getTableView();
            if (tableView.getModel() == this.subTable) {
                this.registrar.unregisterService((Object)this, TableViewAddedListener.class);
                SynchronousTaskManager taskManager = (SynchronousTaskManager)this.registrar.getService(SynchronousTaskManager.class);
                CopyTableVisualPropertiesTask copyTask = new CopyTableVisualPropertiesTask(this.registrar, this.parentTable, this.subTable);
                taskManager.execute(new TaskIterator(new Task[]{copyTask}));
            }
        }
    }

    private static class CopyTableVisualPropertiesTask
    extends AbstractTask {
        private final CyServiceRegistrar registrar;
        private final CyTable parentTable;
        private final CyTable subTable;

        public CopyTableVisualPropertiesTask(CyServiceRegistrar registrar, CyTable parentTable, CyTable subTable) {
            this.registrar = registrar;
            this.parentTable = parentTable;
            this.subTable = subTable;
        }

        public void run(TaskMonitor tm) throws Exception {
            tm.setTitle("Copy Table Visual Properties");
            tm.setProgress(0.0);
            this.copyVisualProperties(this.parentTable, this.subTable);
            tm.setProgress(1.0);
        }

        private void copyVisualProperties(CyTable parentTable, CyTable subTable) {
            CyTableViewManager tableViewManager = (CyTableViewManager)this.registrar.getService(CyTableViewManager.class);
            RenderingEngineManager renderingEngineManager = (RenderingEngineManager)this.registrar.getService(RenderingEngineManager.class);
            CyTableView parentTableView = tableViewManager.getTableView(parentTable);
            CyTableView subTableView = tableViewManager.getTableView(subTable);
            if (parentTableView != null && subTableView != null) {
                Collection engines = renderingEngineManager.getRenderingEngines((View)parentTableView);
                VisualLexicon lexicon = engines.isEmpty() ? renderingEngineManager.getDefaultVisualLexicon() : ((RenderingEngine)engines.iterator().next()).getVisualLexicon();
                for (CyColumn col : parentTable.getColumns()) {
                    View parentColView = parentTableView.getColumnView(col.getName());
                    View subColView = subTableView.getColumnView(col.getName());
                    if (parentColView == null || subColView == null) continue;
                    this.copyColumnVisualProperties((View<CyColumn>)parentColView, (View<CyColumn>)subColView, lexicon);
                }
            }
        }

        private void copyColumnVisualProperties(View<CyColumn> parentColView, View<CyColumn> subColView, VisualLexicon lexicon) {
            for (VisualProperty vp : lexicon.getAllVisualProperties()) {
                if (vp.getTargetDataType() != CyColumn.class || vp == BasicTableVisualLexicon.COLUMN_SELECTED || !parentColView.isSet(vp)) continue;
                Object val = parentColView.getVisualProperty(vp);
                if (parentColView.isDirectlyLocked(vp)) {
                    subColView.setLockedValue(vp, val);
                    continue;
                }
                subColView.setVisualProperty(vp, val);
            }
        }
    }
}

