/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.layout;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewCollectionTaskFactory;
import org.cytoscape.task.internal.layout.ApplyPreferredLayoutTask;
import org.cytoscape.task.visualize.ApplyPreferredLayoutTaskFactory;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class ApplyPreferredLayoutTaskFactoryImpl
extends AbstractNetworkViewCollectionTaskFactory
implements ApplyPreferredLayoutTaskFactory,
TaskFactory {
    private final CyServiceRegistrar serviceRegistrar;
    private final boolean selectedOnly;

    public ApplyPreferredLayoutTaskFactoryImpl(CyServiceRegistrar serviceRegistrar, boolean selectedOnly) {
        this.serviceRegistrar = serviceRegistrar;
        this.selectedOnly = selectedOnly;
    }

    public TaskIterator createTaskIterator(Collection<CyNetworkView> networkViews) {
        return new TaskIterator(2, new Task[]{new ApplyPreferredLayoutTask(this.serviceRegistrar, networkViews, this.selectedOnly)});
    }

    public TaskIterator createTaskIterator() {
        List<CyNetworkView> networkViews = Collections.singletonList(((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView());
        return new TaskIterator(2, new Task[]{new ApplyPreferredLayoutTask(this.serviceRegistrar, networkViews, this.selectedOnly)});
    }

    public boolean isReady() {
        return true;
    }

    public boolean isReady(Collection<CyNetworkView> networkViews) {
        if (networkViews == null || networkViews.isEmpty()) {
            return false;
        }
        if (!this.selectedOnly) {
            return true;
        }
        CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm layout = layoutMgr.getDefaultLayout();
        if (!layout.getSupportsSelectedOnly()) {
            return false;
        }
        for (CyNetworkView networkView : networkViews) {
            if (ApplyPreferredLayoutTaskFactoryImpl.hasSelectedNodes(networkView)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSelectedNodes(CyNetworkView networkView) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        CyTable nodeTable = network.getDefaultNodeTable();
        if (nodeTable.countMatchingRows("selected", (Object)Boolean.TRUE) == 0) {
            return false;
        }
        for (View view : networkView.getNodeViews()) {
            CyRow row = network.getRow((CyIdentifiable)view.getModel());
            if (!((Boolean)row.get("selected", Boolean.class)).booleanValue() || !((Boolean)view.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

