/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.layout;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewCollectionTask;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class ApplyPreferredLayoutTask
extends AbstractNetworkViewCollectionTask {
    @Tunable(description="Network view to apply the layout currently set as default to", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork networkSelected;
    @Tunable(description="If true the layout will be applied only to selected nodes. Note, the layout must support this option, if not then the layout will be applied to all nodes.", context="nogui")
    public boolean selectedOnly = false;
    private final CyServiceRegistrar serviceRegistrar;

    public ApplyPreferredLayoutTask(CyServiceRegistrar serviceRegistrar, Collection<CyNetworkView> networkViews, boolean selectedOnly) {
        super(networkViews);
        this.serviceRegistrar = serviceRegistrar;
        this.selectedOnly = selectedOnly;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Apply Preferred Layout");
        tm.setProgress(0.0);
        CyLayoutAlgorithmManager layoutMgr = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
        CyLayoutAlgorithm layout = layoutMgr.getDefaultLayout();
        if (layout == null) {
            throw new IllegalArgumentException("Couldn't find default layout algorithm");
        }
        tm.setStatusMessage("Applying " + layout.getName() + "...");
        Collection views = this.networkViews;
        if (this.networkSelected != null) {
            views = ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews(this.networkSelected);
        }
        tm.setProgress(0.1);
        int i = 0;
        int viewCount = views.size();
        for (CyNetworkView view : views) {
            if (this.cancelled) {
                return;
            }
            Set<View<CyNode>> nodes = ApplyPreferredLayoutTask.getLayoutNodes(layout, view, this.selectedOnly);
            String layoutAttribute = layoutMgr.getLayoutAttribute(layout, view);
            TaskIterator tasks = layout.createTaskIterator(view, layout.getDefaultLayoutContext(), nodes, layoutAttribute);
            if (tasks != null) {
                this.insertTasksAfterCurrentTask(tasks);
            }
            tm.setProgress((double)(++i) / (double)viewCount);
        }
        tm.setProgress(1.0);
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }

    private static Set<View<CyNode>> getLayoutNodes(CyLayoutAlgorithm layout, CyNetworkView networkView, boolean selectedNodesOnly) {
        if (layout.getSupportsSelectedOnly() && selectedNodesOnly) {
            HashSet<View<CyNode>> nodeViews = new HashSet<View<CyNode>>();
            CyNetwork network = (CyNetwork)networkView.getModel();
            for (View view : networkView.getNodeViews()) {
                if (!((Boolean)network.getRow((CyIdentifiable)view.getModel()).get("selected", Boolean.class)).booleanValue() || !((Boolean)view.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).booleanValue()) continue;
                nodeViews.add((View<CyNode>)view);
            }
            return nodeViews;
        }
        return CyLayoutAlgorithm.ALL_NODE_VIEWS;
    }
}

