/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import java.util.ArrayList;
import java.util.Collection;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTask;
import org.cytoscape.task.internal.hide.HideEdit;
import org.cytoscape.task.internal.hide.HideUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class UnHideTask
extends AbstractNetworkViewTask {
    private final String description;
    private Collection<CyNode> nodes;
    private Collection<CyEdge> edges;
    private final CyServiceRegistrar serviceRegistrar;

    public UnHideTask(String description, Collection<CyNode> nodes, Collection<CyEdge> edges, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        super(view);
        this.description = description;
        this.nodes = nodes;
        this.edges = edges;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Show Nodes and Edges");
        tm.setProgress(0.0);
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.nodes != null) {
            elements.addAll(this.nodes);
        }
        if (this.cancelled) {
            return;
        }
        tm.setProgress(0.1);
        if (this.edges != null) {
            elements.addAll(this.edges);
        }
        tm.setProgress(0.2);
        UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        tm.setProgress(0.3);
        if (this.nodes != null) {
            HideUtils.setVisibleNodes(this.nodes, true, this.view);
        }
        if (this.cancelled) {
            return;
        }
        tm.setProgress(0.5);
        if (this.edges != null) {
            HideUtils.setVisibleEdges(this.edges, true, this.view);
        }
        if (this.cancelled) {
            return;
        }
        tm.setProgress(0.7);
        undoSupport.postEdit((AbstractCyEdit)new HideEdit(this.description, this.view, elements, true, eventHelper, vmMgr));
        vmMgr.getVisualStyle(this.view).apply(this.view);
        this.view.updateView();
        tm.setProgress(1.0);
    }
}

