/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.hide.HideUtils;
import org.cytoscape.task.internal.utils.NodeAndEdgeTunable;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class UnHideCommandTask
extends AbstractTask
implements ObservableTask {
    private CyServiceRegistrar serviceRegistrar;
    private List<CyEdge> edges;
    private List<CyNode> nodes;
    private CyNetwork network;
    @ContainsTunables
    public NodeAndEdgeTunable tunable;

    public UnHideCommandTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.tunable = new NodeAndEdgeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor e) {
        e.setProgress(0.0);
        this.edges = this.tunable.getEdgeList();
        this.nodes = this.tunable.getNodeList();
        this.network = this.tunable.getNetwork();
        if (!(this.edges != null && this.edges.size() != 0 || this.nodes != null && this.nodes.size() != 0)) {
            e.showMessage(TaskMonitor.Level.ERROR, "Must specify nodes or edges to show");
            return;
        }
        Collection views = ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews(this.network);
        if (views == null || views.size() == 0) {
            e.showMessage(TaskMonitor.Level.ERROR, "Network " + this.network.toString() + " doesn't have a view");
            return;
        }
        int nodeCount = 0;
        int edgeCount = 0;
        VisualMappingManager vmMgr = (VisualMappingManager)this.serviceRegistrar.getService(VisualMappingManager.class);
        for (CyNetworkView view : views) {
            VisualStyle style = vmMgr.getVisualStyle(view);
            if (this.nodes != null) {
                HideUtils.setVisibleNodes(this.nodes, true, view);
                nodeCount = this.nodes.size();
                for (CyNode node : this.nodes) {
                    View nodeView = view.getNodeView(node);
                    style.apply(this.network.getRow((CyIdentifiable)node), nodeView);
                }
            }
            if (this.edges != null) {
                HideUtils.setVisibleEdges(this.edges, true, view);
                edgeCount = this.edges.size();
                for (CyEdge edge : this.edges) {
                    View edgeView = view.getEdgeView(edge);
                    style.apply(this.network.getRow((CyIdentifiable)edge), edgeView);
                }
            }
            view.updateView();
        }
        e.showMessage(TaskMonitor.Level.INFO, "Showed " + nodeCount + " nodes and " + edgeCount + " edges");
        e.setProgress(1.0);
    }

    public Object getResults(Class type) {
        ArrayList<Object> identifiables = new ArrayList<Object>();
        if (this.nodes != null) {
            identifiables.addAll(this.nodes);
        }
        if (this.edges != null) {
            identifiables.addAll(this.edges);
        }
        if (type.equals(List.class)) {
            return identifiables;
        }
        if (type.equals(String.class)) {
            if (identifiables.size() == 0) {
                return "<none>";
            }
            Object ret = "";
            if (this.nodes != null && this.nodes.size() > 0) {
                ret = (String)ret + "Nodes unhidden: \n";
                for (CyNode node : this.nodes) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)node).get("name", String.class) + "\n";
                }
            }
            if (this.edges != null && this.edges.size() > 0) {
                ret = (String)ret + "Edges unhidden: \n";
                for (CyEdge edge : this.edges) {
                    ret = (String)ret + "   " + (String)this.network.getRow((CyIdentifiable)edge).get("name", String.class) + "\n";
                }
            }
            return ret;
        }
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (identifiables == null || identifiables.size() == 0) {
                    return "{}";
                }
                CyJSONUtil cyJSONUtil = (CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class);
                Object result = "{\"nodes\":";
                result = this.nodes == null || this.nodes.size() == 0 ? (String)result + "[]" : (String)result + cyJSONUtil.cyIdentifiablesToJson(this.nodes);
                result = (String)result + ", \"edges\":";
                result = this.edges == null || this.edges.size() == 0 ? (String)result + "[]" : (String)result + cyJSONUtil.cyIdentifiablesToJson(this.edges);
                result = (String)result + "}";
                return result;
            };
            return res;
        }
        return identifiables;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

