/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.hide;

import java.util.ArrayList;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewTaskFactory;
import org.cytoscape.task.internal.hide.HideFromSelectionTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public abstract class AbstractHideFromSelectionTaskFactory
extends AbstractNetworkViewTaskFactory {
    protected final String description;
    protected final boolean hideNodes;
    protected final boolean hideEdges;
    protected final boolean selectionValue;
    protected final CyServiceRegistrar serviceRegistrar;

    public AbstractHideFromSelectionTaskFactory(String description, boolean hideNodes, boolean hideEdges, boolean selectionValue, CyServiceRegistrar serviceRegistrar) {
        this.description = description;
        this.hideNodes = hideNodes;
        this.hideEdges = hideEdges;
        this.selectionValue = selectionValue;
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyNetworkView view) {
        return new TaskIterator(new Task[]{new HideFromSelectionTask(this.description, this.hideNodes, this.hideEdges, this.selectionValue, view, this.serviceRegistrar)});
    }

    public boolean isReady(CyNetworkView networkView) {
        if (super.isReady(networkView)) {
            if (networkView != null && !this.selectionValue) {
                CyNetwork network = (CyNetwork)networkView.getModel();
                ArrayList elements = new ArrayList();
                if (this.hideNodes) {
                    elements.addAll(CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)false));
                }
                if (this.hideEdges) {
                    elements.addAll(CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)false));
                }
                for (CyIdentifiable e : elements) {
                    View ev;
                    View nv;
                    if (!(e instanceof CyNode ? (nv = networkView.getNodeView((CyNode)e)) != null && Boolean.TRUE.equals(nv.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)) : e instanceof CyEdge && (ev = networkView.getEdgeView((CyEdge)e)) != null && Boolean.TRUE.equals(ev.getVisualProperty(BasicVisualLexicon.EDGE_VISIBLE)))) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }
}

