/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.help;

import org.cytoscape.application.CyVersion;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class HelpTask
extends AbstractTask {
    private final String URL_TEMPLATE = "https://manual.cytoscape.org/en/%s.%s.%s/Quick_Tour_of_Cytoscape.html";
    private final CyServiceRegistrar serviceRegistrar;

    public HelpTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        CyVersion cyVersion = (CyVersion)this.serviceRegistrar.getService(CyVersion.class);
        int major = cyVersion.getMajorVersion();
        int minor = cyVersion.getMinorVersion();
        int fix = cyVersion.getBugFixVersion();
        String url = String.format("https://manual.cytoscape.org/en/%s.%s.%s/Quick_Tour_of_Cytoscape.html", major, minor, fix);
        try {
            ((OpenBrowser)this.serviceRegistrar.getService(OpenBrowser.class)).openURL(url);
        }
        catch (Exception err) {
            System.out.println("Unable to open browser for " + url.toString());
        }
    }
}

