/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.group.AbstractGroupTask;
import org.cytoscape.task.internal.group.GroupEdit;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.NodeTunable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class UnGroupNodesTask
extends AbstractGroupTask
implements ObservableTask {
    @ContainsTunables
    public NodeTunable nodeTunable;
    private Set<CyGroup> groupSet;
    private CyNetworkView netView;

    public UnGroupNodesTask(CyNetwork net, Set<CyGroup> groups, CyNetworkView netView, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        if (net == null) {
            throw new NullPointerException("network is null");
        }
        this.net = net;
        this.netView = netView;
        this.groupSet = groups;
    }

    public UnGroupNodesTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.nodeTunable = new NodeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        if (this.nodeTunable != null) {
            this.net = this.nodeTunable.getNetwork();
            this.groupSet = this.getGroups(this.net, this.nodeTunable.getNodeList());
        }
        UndoSupport undoSupport = (UndoSupport)this.serviceRegistrar.getService(UndoSupport.class);
        GroupEdit edit = new GroupEdit(this.groupSet, this.serviceRegistrar);
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        for (CyGroup group : this.groupSet) {
            groupMgr.destroyGroup(group);
            tm.setProgress(1.0 / (double)this.groupSet.size());
        }
        undoSupport.postEdit((AbstractCyEdit)edit);
        if (this.netView != null) {
            this.netView.updateView();
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Ungrouped " + this.groupSet.size() + " groups");
        tm.setProgress(1.0);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return "Ungrouped: " + DataUtils.convertData(this.groupSet);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> "{\"groups\": [" + this.getGroupSetString(this.groupSet) + "]}";
            return res;
        }
        return null;
    }
}

