/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.group.AbstractGroupTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class ListGroupsTask
extends AbstractGroupTask
implements ObservableTask {
    private List<CyGroup> groups;
    private CyApplicationManager appMgr;
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;

    public ListGroupsTask(CyApplicationManager appMgr, CyGroupManager manager, CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.appMgr = appMgr;
    }

    public void run(TaskMonitor tm) throws Exception {
        if (this.network == null) {
            this.network = this.appMgr.getCurrentNetwork();
        }
        this.net = this.network;
        this.groups = this.getGroupList(tm, "all");
        if (this.groups == null) {
            return;
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Groups in network: " + this.network);
        for (CyGroup group : this.groups) {
            tm.showMessage(TaskMonitor.Level.INFO, "    " + this.getGroupDesc(group));
        }
        tm.setProgress(1.0);
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (this.groups == null) {
            return null;
        }
        if (requestedType.equals(String.class)) {
            return DataUtils.convertData(this.groups);
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> "{\"groups\": [" + this.getGroupSetString(this.groups) + "]}";
            return res;
        }
        return this.groups;
    }
}

