/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupFactory;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.undo.AbstractCyEdit;

public class GroupEdit
extends AbstractCyEdit {
    private CyGroup group;
    private Set<CyGroup> groupSet;
    private final CyServiceRegistrar serviceRegistrar;
    private Map<CyGroup, List<CyNode>> nodeMap;
    private Map<CyGroup, List<CyEdge>> edgesMap;
    private Map<CyGroup, List<CyNetwork>> networkMap;
    private Map<CyGroup, List<CyNetwork>> collapseMap;

    public GroupEdit(CyGroup group, CyServiceRegistrar serviceRegistrar) {
        super("Group Nodes");
        this.group = group;
        this.groupSet = null;
        this.serviceRegistrar = serviceRegistrar;
        this.initMaps();
        this.createShadowGroup(group);
    }

    public GroupEdit(Set<CyGroup> groupSet, CyServiceRegistrar serviceRegistrar) {
        super("Ungroup Nodes");
        this.group = null;
        this.groupSet = groupSet;
        this.serviceRegistrar = serviceRegistrar;
        this.initMaps();
        for (CyGroup group : groupSet) {
            this.createShadowGroup(group);
        }
    }

    public void undo() {
        if (this.group != null) {
            ((CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class)).destroyGroup(this.group);
        } else if (this.groupSet != null) {
            HashSet<CyGroup> newGroups = new HashSet<CyGroup>();
            for (CyGroup group : this.groupSet) {
                newGroups.add(this.reGroup(group));
            }
            this.initMaps();
            this.groupSet = newGroups;
            for (CyGroup group : this.groupSet) {
                this.createShadowGroup(group);
            }
        }
    }

    public void redo() {
        if (this.group != null) {
            this.group = this.reGroup(this.group);
            this.initMaps();
            this.createShadowGroup(this.group);
        } else if (this.groupSet != null) {
            CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
            for (CyGroup group : this.groupSet) {
                groupMgr.destroyGroup(group);
            }
        }
    }

    private CyGroup reGroup(CyGroup group) {
        List<CyNetwork> netList = this.networkMap.get(group);
        CyNetwork firstNet = netList.get(1);
        CyGroupFactory factory = (CyGroupFactory)this.serviceRegistrar.getService(CyGroupFactory.class);
        CyGroup newGroup = factory.createGroup(firstNet, this.nodeMap.get(group), this.edgesMap.get(group), true);
        if (netList.size() > 2) {
            for (int i = 2; i < netList.size(); ++i) {
                newGroup.addGroupToNetwork(netList.get(i));
            }
        }
        for (CyNetwork net : this.collapseMap.get(group)) {
            newGroup.collapse(net);
        }
        return newGroup;
    }

    private void initMaps() {
        this.nodeMap = new HashMap<CyGroup, List<CyNode>>();
        this.edgesMap = new HashMap<CyGroup, List<CyEdge>>();
        this.networkMap = new HashMap<CyGroup, List<CyNetwork>>();
        this.collapseMap = new HashMap<CyGroup, List<CyNetwork>>();
    }

    private void createShadowGroup(CyGroup group) {
        this.nodeMap.put(group, group.getNodeList());
        ArrayList edgesList = new ArrayList(group.getInternalEdgeList());
        edgesList.addAll(group.getExternalEdgeList());
        this.edgesMap.put(group, edgesList);
        ArrayList<CyNetwork> networks = new ArrayList<CyNetwork>();
        for (CyNetwork network : group.getNetworkSet()) {
            if (network instanceof CyRootNetwork) {
                networks.add(0, network);
                continue;
            }
            networks.add(network);
        }
        this.networkMap.put(group, networks);
        ArrayList<CyNetwork> collapseList = new ArrayList<CyNetwork>();
        for (CyNetwork net : group.getNetworkSet()) {
            if (!group.isCollapsed(net)) continue;
            collapseList.add(net);
        }
        this.collapseMap.put(group, collapseList);
    }
}

