/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.group.AbstractGroupTask;
import org.cytoscape.task.internal.utils.NodeAndEdgeTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class AddToGroupTask
extends AbstractGroupTask {
    @Tunable(description="Group", context="nogui", longDescription="Specifies the name used to identify the group. ", exampleStringValue="MyLocus")
    public String groupName;
    @ContainsTunables
    public NodeAndEdgeTunable nodesAndEdges;

    public AddToGroupTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.nodesAndEdges = new NodeAndEdgeTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) throws Exception {
        this.net = this.nodesAndEdges.getNetwork();
        if (this.groupName == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Group must be specified");
            return;
        }
        CyGroup grp = this.getGroup(this.groupName);
        if (grp == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Can't find group '" + this.groupName + "' in network: " + this.net.toString());
            return;
        }
        List<CyEdge> edgeList = this.nodesAndEdges.getEdgeList(false);
        List<CyNode> nodeList = this.nodesAndEdges.getNodeList(false);
        if (edgeList == null && nodeList == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Nothing to add");
            return;
        }
        int edges = 0;
        if (edgeList != null) {
            edges = edgeList.size();
        }
        int nodes = 0;
        if (nodeList != null) {
            nodes = nodeList.size();
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Adding " + nodes + " nodes and " + edges + " edges to group " + this.getGroupDesc(grp));
        if (edgeList != null && edgeList.size() > 0) {
            grp.addEdges(edgeList);
        }
        if (nodeList != null && nodeList.size() > 0) {
            grp.addNodes(nodeList);
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Added " + nodes + " nodes and " + edges + " edges to group " + this.getGroupDesc(grp));
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, CyGroup.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(CyGroup.class)) {
            return this.getGroup(this.groupName);
        }
        if (requestedType.equals(String.class)) {
            return this.groupName;
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }
}

