/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public abstract class AbstractGroupTask
extends AbstractTask {
    protected CyNetwork net;
    protected final CyServiceRegistrar serviceRegistrar;

    public AbstractGroupTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    protected List<CyGroup> getGroupList(TaskMonitor tm, String groupList) {
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        Set allGroups = groupMgr.getGroupSet(this.net);
        if (groupList.equalsIgnoreCase("all")) {
            return new ArrayList<CyGroup>(allGroups);
        }
        if (groupList.equalsIgnoreCase("selected")) {
            return this.getSelectedGroups();
        }
        if (groupList.equalsIgnoreCase("unselected")) {
            return this.getUnselectedGroups();
        }
        String[] groups = DataUtils.getCSV(groupList);
        ArrayList<CyGroup> returnGroups = new ArrayList<CyGroup>();
        for (String groupName : groups) {
            CyGroup group = this.getGroup(groupName);
            if (group == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find group '" + groupName + "' in network " + this.net);
                return null;
            }
            returnGroups.add(group);
        }
        return returnGroups;
    }

    protected CyGroup getGroup(String groupName) {
        CyRootNetwork rootNet = ((CySubNetwork)this.net).getRootNetwork();
        Set allGroups = ((CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class)).getGroupSet(this.net);
        for (CyGroup group : allGroups) {
            String suidString;
            CyRow groupRow = rootNet.getRow((CyIdentifiable)group.getGroupNode(), "SHARED_ATTRS");
            if (!(groupName.length() > 5 && groupName.substring(0, 5).equalsIgnoreCase("suid:") ? (suidString = ((Long)groupRow.get("SUID", Long.class)).toString()) != null && groupName.substring(5).equals(suidString) : groupName.equals(groupRow.get("shared name", String.class)))) continue;
            return group;
        }
        return null;
    }

    protected List<CyGroup> getSelectedGroups() {
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)this.net, (String)"selected", (boolean)true);
        return this.getGroupsFromNodes(selectedNodes);
    }

    protected List<CyGroup> getUnselectedGroups() {
        List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)this.net, (String)"selected", (boolean)false);
        return this.getGroupsFromNodes(selectedNodes);
    }

    protected List<CyGroup> getGroupsFromNodes(List<CyNode> nodes) {
        ArrayList<CyGroup> groups = new ArrayList<CyGroup>();
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        for (CyNode node : nodes) {
            CyGroup group = groupMgr.getGroup(node, this.net);
            if (group == null) continue;
            groups.add(group);
        }
        return groups;
    }

    protected String getGroupName(CyGroup group) {
        CyRootNetwork rootNet = ((CySubNetwork)this.net).getRootNetwork();
        CyRow groupRow = rootNet.getRow((CyIdentifiable)group.getGroupNode(), "SHARED_ATTRS");
        return (String)groupRow.get("shared name", String.class);
    }

    protected String getGroupDesc(CyGroup group) {
        Long suid = group.getGroupNode().getSUID();
        int nodes = group.getNodeList().size();
        int externalEdges = group.getExternalEdgeList().size();
        int internalEdges = group.getInternalEdgeList().size();
        return "Group: " + this.getGroupName(group) + " (suid: " + suid + ") with " + nodes + " nodes, " + internalEdges + " internal edges, and " + externalEdges + " external edges";
    }

    protected Set<CyGroup> getGroups(CyNetwork net, List<CyNode> nodeList) {
        HashSet<CyGroup> groupList = new HashSet<CyGroup>();
        CyGroupManager groupMgr = (CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class);
        for (CyNode node : nodeList) {
            if (groupMgr.isGroup(node, net)) {
                groupList.add(groupMgr.getGroup(node, net));
                continue;
            }
            if (groupMgr.getGroupsForNode(node, net) == null) continue;
            groupList.addAll(groupMgr.getGroupsForNode(node, net));
        }
        return groupList;
    }

    protected String getGroupSetString(Collection<CyGroup> groups) {
        StringBuilder buffer = new StringBuilder();
        StringJoiner joiner = new StringJoiner(",");
        for (CyGroup group : groups) {
            joiner.add(group.getGroupNode().getSUID().toString());
        }
        return joiner.toString();
    }
}

