/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.filter.TransformerContainer;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.io.write.CyTransformerWriter;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.filter.ContainerTunable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class GetFilterTask
extends AbstractTask
implements ObservableTask {
    @Tunable
    public String name = null;
    @ContainsTunables
    public ContainerTunable containerTunable = new ContainerTunable();
    private String jsonResult = null;
    private final CyServiceRegistrar serviceRegistrar;

    public GetFilterTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor taskMonitor) throws IOException {
        if (this.name == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "name must be provided");
            return;
        }
        TransformerContainer<CyNetwork, CyIdentifiable> container = this.containerTunable.getContainer(this.serviceRegistrar);
        if (container == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "container type not found: '" + this.containerTunable.getValue() + "'");
            return;
        }
        NamedTransformer namedTransformer = container.getNamedTransformer(this.name);
        if (namedTransformer == null) {
            taskMonitor.showMessage(TaskMonitor.Level.ERROR, "transformer not found: '" + this.name + "'");
            return;
        }
        CyTransformerWriter transformerWriter = (CyTransformerWriter)this.serviceRegistrar.getService(CyTransformerWriter.class);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            transformerWriter.write((OutputStream)out, new NamedTransformer[]{namedTransformer});
            this.jsonResult = out.toString();
        }
    }

    public <R> R getResults(Class<? extends R> type) {
        if (String.class.equals(type)) {
            return type.cast(this.jsonResult);
        }
        if (JSONResult.class.equals(type)) {
            JSONResult res = () -> this.jsonResult;
            return type.cast(res);
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }
}

