/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.web;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.write.CySessionWriterFactory;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.swing.RequestsUIHelper;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class ExportAsWebArchiveTask
extends AbstractTask
implements TunableValidator,
RequestsUIHelper {
    private static final String FILE_EXTENSION = ".zip";
    private static final String AS_SPA = "Full web application";
    private static final String AS_SIMPLE_PAGE = "Simple viewer for current network only";
    private static final String AS_ZIPPED_ARCHIVE = "Networks and Style JSON files only (No HTML)";
    private TunableUIHelper helper;
    public File file;
    @Tunable(description="Export as:")
    public ListSingleSelection<String> outputFormat;
    private final CySessionWriterFactory fullWriterFactory;
    private final CySessionWriterFactory simpleWriterFactory;
    private final CySessionWriterFactory zippedWriterFactory;
    private final CyServiceRegistrar serviceRegistrar;
    private CyWriter writer;

    @ProvidesTitle
    public String getTitle() {
        return "Export as Cytoscape.js Web Page";
    }

    @Tunable(description="Export Networks and Styles as:", params="fileCategory=archive;input=false", listenForChange={"outputFormat"})
    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null || file.getName().endsWith(FILE_EXTENSION)) {
            this.file = file;
        } else {
            this.file = new File(file.getAbsolutePath() + FILE_EXTENSION);
            if (this.helper != null) {
                this.helper.update((Object)this);
            }
        }
    }

    public ExportAsWebArchiveTask(CySessionWriterFactory fullWriterFactory, CySessionWriterFactory simpleWriterFactory, CySessionWriterFactory zippedWriterFactory, CyServiceRegistrar serviceRegistrar) {
        this.fullWriterFactory = fullWriterFactory;
        this.simpleWriterFactory = simpleWriterFactory;
        this.zippedWriterFactory = zippedWriterFactory;
        this.serviceRegistrar = serviceRegistrar;
        this.outputFormat = new ListSingleSelection((Object[])new String[]{AS_SPA, AS_SIMPLE_PAGE, AS_ZIPPED_ARCHIVE});
        this.file = this.getSuggestedFile();
        this.outputFormat.addListener((ListChangeListener)new ListChangeListener<String>(){

            public void selectionChanged(ListSelection<String> source) {
                ExportAsWebArchiveTask.this.file = ExportAsWebArchiveTask.this.getSuggestedFile();
            }

            public void listChanged(ListSelection<String> source) {
            }
        });
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setProgress(0.0);
        if (this.file == null) {
            return;
        }
        String exportType = (String)this.outputFormat.getSelectedValue();
        if (!this.file.getName().endsWith(FILE_EXTENSION)) {
            this.file = new File(this.file.getPath() + FILE_EXTENSION);
        }
        FileOutputStream os = new FileOutputStream(this.file);
        CyWriter writer = null;
        if (exportType.equals(AS_SPA)) {
            writer = this.fullWriterFactory.createWriter((OutputStream)os, null);
        } else if (exportType.equals(AS_SIMPLE_PAGE)) {
            writer = this.simpleWriterFactory.createWriter((OutputStream)os, null);
        } else if (exportType.equals(AS_ZIPPED_ARCHIVE)) {
            writer = this.zippedWriterFactory.createWriter((OutputStream)os, null);
        } else {
            os.close();
            throw new NullPointerException("Could not find web session writer.");
        }
        writer.run(tm);
        os.close();
        tm.setProgress(1.0);
    }

    public void cancel() {
        super.cancel();
        if (this.writer != null) {
            this.writer.cancel();
        }
    }

    private File getSuggestedFile() {
        String exportName = null;
        CySessionManager sessionManager = (CySessionManager)this.serviceRegistrar.getService(CySessionManager.class);
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        if (!((String)this.outputFormat.getSelectedValue()).equals(AS_SIMPLE_PAGE)) {
            exportName = FilenameUtils.getBaseName((String)sessionManager.getCurrentSessionFileName());
        } else {
            CyNetwork network = applicationManager.getCurrentNetwork();
            if (network == null) {
                throw new RuntimeException("No network to export");
            }
            exportName = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        }
        if (exportName == null || exportName.trim().isEmpty()) {
            exportName = "Untitled";
        }
        return new File(applicationManager.getCurrentDirectory(), exportName + FILE_EXTENSION);
    }

    public TunableValidator.ValidationState getValidationState(Appendable msg) {
        if (this.outputFormat.getSelectedValue() == null) {
            try {
                msg.append("Select a file type.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        if (this.file == null) {
            try {
                msg.append("Enter a file name.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        if (this.file.exists()) {
            try {
                msg.append("File already exists, are you sure you want to overwrite it?");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return TunableValidator.ValidationState.REQUEST_CONFIRMATION;
        }
        return TunableValidator.ValidationState.OK;
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.helper = helper;
    }
}

