/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.table.CyTableWriter;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.swing.RequestsUIHelper;
import org.cytoscape.work.swing.TunableUIHelper;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class SelectExportTableTask
extends AbstractTask
implements RequestsUIHelper,
TunableValidator {
    @Tunable(description="Select a table to export:", gravity=1.05, longDescription="Specifies the name of the table to export")
    public ListSingleSelection<String> selectTable;
    @ContainsTunables
    public CyTableWriter writer;
    private TunableUIHelper helper;
    private HashMap<CyTable, CyNetwork> tableNetworkMap = new HashMap();
    private HashMap<String, CyTable> titleTableMap = new HashMap();
    private final CyServiceRegistrar serviceRegistrar;

    public SelectExportTableTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.populateNetworkTableMap();
        this.populateSelectTable();
        this.updateWriter();
    }

    private void populateSelectTable() {
        ArrayList<String> options = new ArrayList<String>();
        CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        for (CyTable tbl : tableManager.getAllTables(false)) {
            String title = tbl.getTitle();
            options.add(title);
            this.titleTableMap.put(title, tbl);
        }
        Collections.sort(options);
        this.selectTable = new ListSingleSelection(options);
        this.selectTable.addListener((ListChangeListener)new ListChangeListener<String>(){

            public void selectionChanged(ListSelection<String> source) {
                SelectExportTableTask.this.updateWriter();
                if (SelectExportTableTask.this.helper != null) {
                    SelectExportTableTask.this.helper.refresh((Object)SelectExportTableTask.this);
                }
            }

            public void listChanged(ListSelection<String> source) {
            }
        });
    }

    private void populateNetworkTableMap() {
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        for (CyNetwork net : netManager.getNetworkSet()) {
            this.tableNetworkMap.put(net.getDefaultNetworkTable(), net);
            this.tableNetworkMap.put(net.getDefaultNodeTable(), net);
            this.tableNetworkMap.put(net.getDefaultEdgeTable(), net);
        }
    }

    private void updateWriter() {
        String selectedTitle = (String)this.selectTable.getSelectedValue();
        CyTable tbl = this.titleTableMap.get(selectedTitle);
        this.writer = tbl != null ? new CyTableWriter(tbl, this.serviceRegistrar) : null;
    }

    public void run(TaskMonitor tm) throws IOException {
        this.insertTasksAfterCurrentTask(new Task[]{this.writer});
    }

    @ProvidesTitle
    public String getTitle() {
        return "Export Table";
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.helper = helper;
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        if (this.selectTable.getPossibleValues().isEmpty()) {
            try {
                errMsg.append("No tables exist.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return TunableValidator.ValidationState.INVALID;
        }
        return this.writer.getValidationState(errMsg);
    }
}

