/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.table;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.table.CyTableWriter;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class NoGuiSelectExportTableTask
extends AbstractTask {
    @ContainsTunables
    public TableTunable selectTable;
    @ContainsTunables
    public CyTableWriter tableWriter;
    private CyTable tbl;
    private HashMap<CyTable, CyNetwork> tableNetworkMap = new HashMap();
    private final CyServiceRegistrar serviceRegistrar;

    public NoGuiSelectExportTableTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.populateNetworkTableMap();
        this.selectTable = new TableTunable(serviceRegistrar);
        CyTable table = this.getFirstTable();
        if (table == null) {
            throw new RuntimeException("No tables available to export");
        }
        this.tableWriter = new CyTableWriter(table, serviceRegistrar);
    }

    private void populateNetworkTableMap() {
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        for (CyNetwork net : netManager.getNetworkSet()) {
            this.tableNetworkMap.put(net.getDefaultNetworkTable(), net);
            this.tableNetworkMap.put(net.getDefaultNodeTable(), net);
            this.tableNetworkMap.put(net.getDefaultEdgeTable(), net);
        }
    }

    private CyTable getFirstTable() {
        CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        Iterator iterator = tableManager.getAllTables(true).iterator();
        if (iterator.hasNext()) {
            CyTable table = (CyTable)iterator.next();
            return table;
        }
        return null;
    }

    public void run(TaskMonitor tm) throws IOException {
        this.tbl = this.selectTable.getTable();
        this.tableWriter = new CyTableWriter(this.tbl, this.serviceRegistrar);
        this.insertTasksAfterCurrentTask(new Task[]{this.tableWriter});
    }

    @ProvidesTitle
    public String getTitle() {
        return "Export Table";
    }
}

