/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.io.IOException;
import java.net.URL;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.CyNetworkReaderManager;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.network.AbstractLoadNetworkTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class LoadNetworkURLTask
extends AbstractLoadNetworkTask {
    @Tunable(description="The URL to load:", longDescription="Select a URL that points to a network format file.  This command does not support csv or Excel files.  Use ``network import url`` for that.", exampleStringValue="http://www.mydomain.edu/exampleNetworks/galFiltered.sif", params="fileCategory=network;input=true", required=true)
    public URL url;
    static String BAD_INTERNET_SETTINGS_MSG = "<html><p>Cytoscape has failed to connect to the URL. Please ensure that:</p><p><ol><li>the URL is correct,</li><li>your computer is able to connect to the Internet, and</li><li>your proxy settings are correct.</li></ol></p><p>The reason for the failure is: %s</html>";
    private CyNetworkReader reader;

    public LoadNetworkURLTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        if (this.url == null) {
            throw new NullPointerException("url is null");
        }
        this.taskMonitor = taskMonitor;
        String urlString = this.url.getFile();
        String[] parts = urlString.split("/");
        this.name = parts[parts.length - 1];
        taskMonitor.setTitle(String.format("Loading Network from '%s'", this.name));
        taskMonitor.setStatusMessage("Checking URL...");
        try {
            ((StreamUtil)this.serviceRegistrar.getService(StreamUtil.class)).getURLConnection(this.url).connect();
        }
        catch (IOException e) {
            throw new Exception(String.format(BAD_INTERNET_SETTINGS_MSG, e.getMessage()), e);
        }
        if (this.cancelled) {
            return;
        }
        taskMonitor.setStatusMessage("Finding compatible network reader for this file...");
        this.reader = ((CyNetworkReaderManager)this.serviceRegistrar.getService(CyNetworkReaderManager.class)).getReader(this.url.toURI(), this.url.toString());
        if (this.cancelled) {
            return;
        }
        if (this.reader == null) {
            throw new NullPointerException("Failed to find reader for specified URL: " + this.name);
        }
        taskMonitor.setStatusMessage("Loading network...");
        this.loadNetwork(this.reader);
    }

    protected CyNetwork[] getCyNetworks() {
        return this.reader.getNetworks();
    }
}

