/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.io.File;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.CyNetworkReaderManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.network.AbstractLoadNetworkTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class LoadNetworkFileTask
extends AbstractLoadNetworkTask {
    @Tunable(description="Network file to load", longDescription="Select a network format file.  This command does not support csv or Excel files.  Use ``network import file`` for that.", params="fileCategory=network;input=true", required=true)
    public File file;

    @Override
    @ProvidesTitle
    public String getTitle() {
        return "Load Network from File";
    }

    public LoadNetworkFileTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        if (this.file == null) {
            throw new NullPointerException("No file specified.");
        }
        CyNetworkReader reader = ((CyNetworkReaderManager)this.serviceRegistrar.getService(CyNetworkReaderManager.class)).getReader(this.file.toURI(), this.file.getName());
        if (this.cancelled) {
            return;
        }
        if (reader == null) {
            throw new NullPointerException("Failed to find appropriate reader for file: " + this.file);
        }
        this.uri = this.file.toURI();
        this.name = this.file.getName();
        this.loadNetwork(reader);
    }
}

