/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import org.cytoscape.io.read.CyNetworkReader;
import org.cytoscape.io.read.CyNetworkReaderManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.network.LoadMultipleNetworksTask;
import org.cytoscape.task.read.LoadMultipleNetworkFilesTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadMultipleNetworkFilesTaskFactoryImpl
extends AbstractTaskFactory
implements LoadMultipleNetworkFilesTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public LoadMultipleNetworkFilesTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        return this.createTaskIterator(null, null);
    }

    public TaskIterator createTaskIterator(List<File> files, CyRootNetwork rootNetwork) {
        if (files == null || files.isEmpty()) {
            throw new IllegalArgumentException("'files' must not be empty");
        }
        return new TaskIterator(new Task[]{new FindReadersAndLoadFilesTask(files, rootNetwork)});
    }

    private class FindReadersAndLoadFilesTask
    extends AbstractTask {
        private final List<File> files;
        private final CyRootNetwork rootNetwork;

        public FindReadersAndLoadFilesTask(List<File> files, CyRootNetwork rootNetwork) {
            this.files = files;
            this.rootNetwork = rootNetwork;
        }

        public void run(TaskMonitor tm) throws Exception {
            tm.setTitle("Find Network Readers");
            tm.setStatusMessage("Finding readers for network files...");
            tm.setProgress(0.0);
            LinkedHashMap<String, CyNetworkReader> readers = new LinkedHashMap<String, CyNetworkReader>();
            CyNetworkReaderManager netReaderManager = (CyNetworkReaderManager)LoadMultipleNetworkFilesTaskFactoryImpl.this.serviceRegistrar.getService(CyNetworkReaderManager.class);
            float total = this.files.size();
            int count = 1;
            for (File f : this.files) {
                if (this.cancelled) {
                    return;
                }
                try {
                    CyNetworkReader netReader = netReaderManager.getReader(f.toURI(), f.toURI().toString());
                    if (netReader != null) {
                        readers.put(f.getName(), netReader);
                    }
                }
                catch (Exception e) {
                    logger.warn("Cannot load file", (Throwable)e);
                }
                tm.setProgress((double)((float)count / total));
                ++count;
            }
            if (this.cancelled) {
                return;
            }
            if (readers.isEmpty()) {
                logger.warn("Failed to find appropriate network readers for the input files.");
                return;
            }
            tm.setProgress(1.0);
            this.insertTasksAfterCurrentTask(new Task[]{new LoadMultipleNetworksTask(readers, this.rootNetwork, LoadMultipleNetworkFilesTaskFactoryImpl.this.serviceRegistrar)});
        }
    }
}

