/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export.network;

import java.io.File;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.write.ExportNetworkTaskFactory;
import org.cytoscape.task.write.ExportNetworkViewTaskFactory;
import org.cytoscape.task.write.ExportSelectedNetworkTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskIterator;

public class ExportSelectedNetworkTaskFactoryImpl
implements ExportSelectedNetworkTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public ExportSelectedNetworkTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView view = applicationManager.getCurrentNetworkView();
        if (view != null) {
            return this.getExportNetworkViewTaskFactory().createTaskIterator(view);
        }
        CyNetwork network = applicationManager.getCurrentNetwork();
        if (network != null) {
            return this.getExportNetworkTaskFactory().createTaskIterator(network);
        }
        return null;
    }

    public TaskIterator createTaskIterator(File file) {
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView view = applicationManager.getCurrentNetworkView();
        if (view != null) {
            return this.getExportNetworkViewTaskFactory().createTaskIterator(view, file);
        }
        CyNetwork network = applicationManager.getCurrentNetwork();
        if (network != null) {
            return this.getExportNetworkTaskFactory().createTaskIterator(network, file);
        }
        return null;
    }

    public boolean isReady() {
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        return applicationManager.getCurrentNetworkView() != null || applicationManager.getCurrentNetwork() != null;
    }

    private ExportNetworkTaskFactory getExportNetworkTaskFactory() {
        return (ExportNetworkTaskFactory)this.serviceRegistrar.getService(ExportNetworkTaskFactory.class, "(id=exportNetworkTaskFactory)");
    }

    private ExportNetworkViewTaskFactory getExportNetworkViewTaskFactory() {
        return (ExportNetworkViewTaskFactory)this.serviceRegistrar.getService(ExportNetworkViewTaskFactory.class, "(id=exportNetworkViewTaskFactory)");
    }
}

