/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export;

import java.io.File;
import java.io.OutputStream;
import java.util.Objects;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.PresentationWriterFactory;
import org.cytoscape.io.write.PresentationWriterManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.export.TunableAbstractCyWriter;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListSelection;

public final class ViewWriter
extends TunableAbstractCyWriter<PresentationWriterFactory, PresentationWriterManager> {
    private static String defaultFormat = "PNG";
    public CyNetworkView view = null;
    private RenderingEngine<?> re;
    private final CyServiceRegistrar serviceRegistrar;

    @Tunable(description="Network View to export", longDescription="Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.", exampleStringValue="current", context="nogui")
    public CyNetworkView getView() {
        return this.view;
    }

    public void setView(CyNetworkView view) {
        this.view = view;
        if (view != null) {
            RenderingEngine engine = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentRenderingEngine();
            String engineId = view.getRendererId();
            RenderingEngineManager engineManager = (RenderingEngineManager)this.serviceRegistrar.getService(RenderingEngineManager.class);
            for (RenderingEngine e : engineManager.getRenderingEngines((View)view)) {
                if (!engineId.equals(e.getRendererId())) continue;
                engine = e;
                break;
            }
            this.re = engine;
        }
    }

    public ViewWriter(CyServiceRegistrar serviceRegistrar) {
        super((PresentationWriterManager)serviceRegistrar.getService(PresentationWriterManager.class), (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class));
        this.serviceRegistrar = serviceRegistrar;
        this.initDefaultFormat();
    }

    public ViewWriter(CyNetworkView view, RenderingEngine<?> re, CyServiceRegistrar serviceRegistrar) {
        super((PresentationWriterManager)serviceRegistrar.getService(PresentationWriterManager.class), (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class));
        this.serviceRegistrar = serviceRegistrar;
        this.view = Objects.requireNonNull(view, "CyNetworkView is null");
        this.re = Objects.requireNonNull(re, "RenderingEngine is null");
        this.initDefaultFormat();
        this.outputFile = this.getSuggestedFile();
    }

    private void initDefaultFormat() {
        for (String fileTypeDesc : this.getFileFilterDescriptions()) {
            if (!fileTypeDesc.contains(defaultFormat)) continue;
            this.options.setSelectedValue((Object)fileTypeDesc);
            break;
        }
        if (this.writer == null) {
            try {
                this.writer = this.getWriter(this.getFileFilter(this.getExportFileFormat()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.options.addListener((ListChangeListener)new ListChangeListener<String>(){

            public void selectionChanged(ListSelection<String> source) {
                defaultFormat = (String)ViewWriter.this.options.getSelectedValue();
            }
        });
    }

    @Override
    protected CyWriter getWriter(CyFileFilter filter) throws Exception {
        if (this.view == null) {
            return null;
        }
        return ((PresentationWriterManager)this.writerManager).getWriter((View)this.view, this.re, filter, (OutputStream)this.outputStream);
    }

    @Override
    @Tunable(description="Save Image as:", longDescription="The path name of the file where the view must be saved to. By default, the view's title is used as the file name.", exampleStringValue="/Users/johndoe/Downloads/View1.png", params="fileCategory=image;input=false", dependsOn="options!=", gravity=1.1)
    public File getOutputFile() {
        if (this.outputFile == null) {
            this.outputFile = this.getSuggestedFile();
        }
        return this.outputFile;
    }

    @ProvidesTitle
    public String getTitle() {
        return "Export Network as Image";
    }

    @Override
    protected String getExportName() {
        String name = (String)this.view.getVisualProperty(BasicVisualLexicon.NETWORK_TITLE);
        if (name == null || name.trim().isEmpty()) {
            name = (String)((CyNetwork)this.view.getModel()).getRow((CyIdentifiable)this.view.getModel()).get("name", String.class);
        }
        return name;
    }
}

