/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.CyFileFilter;
import org.cytoscape.io.write.CyWriter;
import org.cytoscape.io.write.CyWriterFactory;
import org.cytoscape.io.write.CyWriterManager;
import org.cytoscape.task.internal.export.DelegatingOutputStream;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public abstract class AbstractCyWriter<S extends CyWriterFactory, T extends CyWriterManager<S>>
extends AbstractTask
implements CyWriter {
    protected File outputFile;
    protected DelegatingOutputStream outputStream;
    private final Map<String, CyFileFilter> descriptionFilterMap;
    private final Map<String, CyFileFilter> extensionFilterMap;
    protected final T writerManager;
    protected final CyApplicationManager cyApplicationManager;

    public abstract File getOutputFile();

    public abstract void setOutputFile(File var1);

    protected abstract String getExportFileFormat();

    protected abstract String getExportName();

    protected abstract CyWriter getWriter();

    public AbstractCyWriter(T writerManager, CyApplicationManager cyApplicationManager) {
        if (writerManager == null) {
            throw new NullPointerException("CyWriterManager is null");
        }
        this.writerManager = writerManager;
        this.cyApplicationManager = cyApplicationManager;
        this.outputStream = new DelegatingOutputStream();
        this.descriptionFilterMap = new TreeMap<String, CyFileFilter>();
        this.extensionFilterMap = new TreeMap<String, CyFileFilter>();
        for (CyFileFilter f : writerManager.getAvailableWriterFilters()) {
            this.descriptionFilterMap.put(f.getDescription(), f);
            for (String ext : f.getExtensions()) {
                this.extensionFilterMap.put(ext.toLowerCase(), f);
            }
        }
    }

    public final void run(TaskMonitor tm) throws Exception {
        this.outputStream.setDelegate(new FileOutputStream(this.outputFile));
        CyWriter writeTask = this.getWriter();
        AbstractTask closeTask = new AbstractTask(){

            public void run(TaskMonitor tm) throws IOException {
                AbstractCyWriter.this.outputStream.close();
            }
        };
        this.insertTasksAfterCurrentTask(new Task[]{writeTask, closeTask});
    }

    protected abstract CyWriter getWriter(CyFileFilter var1) throws Exception;

    protected File getSuggestedFile() {
        String exportName = this.getExportName();
        if (exportName == null || exportName.trim().isEmpty()) {
            exportName = "Untitled";
        }
        return new File(this.cyApplicationManager.getCurrentDirectory(), exportName + "." + (String)this.getFileFilter(this.getExportFileFormat()).getExtensions().iterator().next());
    }

    protected final Collection<String> getFileFilterDescriptions() {
        return this.descriptionFilterMap.keySet();
    }

    protected final CyFileFilter getFileFilter(String description) {
        if (description == null) {
            return null;
        }
        CyFileFilter f = this.descriptionFilterMap.get(description);
        if (f != null) {
            return f;
        }
        return this.extensionFilterMap.get(description.toLowerCase());
    }

    protected final boolean fileExtensionIsOk(File file) {
        String exportFileFormat = this.getExportFileFormat();
        if (exportFileFormat == null) {
            return true;
        }
        CyFileFilter filter = this.getFileFilter(exportFileFormat);
        if (filter == null) {
            return true;
        }
        return filter.getExtensions().contains(FilenameUtils.getExtension((String)file.getName()));
    }

    protected final File addOrReplaceExtension(File file) {
        CyFileFilter filter = this.getFileFilter(this.getExportFileFormat());
        if (filter == null) {
            return file;
        }
        Iterator extensions = filter.getExtensions().iterator();
        if (!extensions.hasNext()) {
            return file;
        }
        String filterExtension = (String)extensions.next();
        Object fileName = file.getAbsolutePath();
        String fileExtension = FilenameUtils.getExtension((String)fileName);
        if (!filterExtension.trim().equals(fileExtension.trim())) {
            fileName = FilenameUtils.removeExtension((String)fileName) + "." + filterExtension;
        }
        return new File((String)fileName);
    }
}

