/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cxio;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Settings {
    public static final Settings INSTANCE = new Settings();
    private static final boolean IGNORE_SELECTED_COLUMN_DEFAULT = false;
    private static final boolean IGNORE_SUID_COLUMN_DEFAULT = true;
    private static final boolean WRITE_SELECTED_ONLY_IF_TRUE_DEFAULT = true;
    private static final boolean TIMING_DEFAULT = true;
    public static final Set<String> IGNORE_EDGE_ATTRIBUTES = new HashSet<String>();
    public static final Set<String> IGNORE_NODE_ATTRIBUTES = new HashSet<String>();
    public static final Set<String> IGNORE_NETWORK_ATTRIBUTES = new HashSet<String>();
    public static final Set<String> IGNORE_SINGLE_NETWORK_EDGE_ATTRIBUTES = new HashSet<String>();
    public static final Set<String> IGNORE_SINGLE_NETWORK_NODE_ATTRIBUTES = new HashSet<String>();
    public static final Set<String> IGNORE_SINGLE_NETWORK_NETWORK_ATTRIBUTES = new HashSet<String>();
    public static final Set<String> CX2_IGNORE_NODE_ATTRIBUTES = new HashSet<String>(Arrays.asList("shared name"));
    public static final Set<String> CX2_IGNORE_EDGE_ATTRIBUTES = new HashSet<String>(Arrays.asList("name", "shared name", "shared interaction"));
    public static final Set<String> cytoscapeBuiltinEdgeTableAttributes = new HashSet<String>(Arrays.asList("name", "selected", "SUID", "interaction", "shared name", "shared interaction"));
    public static final Set<String> cytoscapeBuiltinTableAttributes = new HashSet<String>(Arrays.asList("name", "selected", "SUID", "shared name"));
    private boolean _timing = true;
    private boolean _ignore_selected_column = false;
    private boolean _write_selected_only_if_true = true;
    private boolean _ignore_suid_column = true;

    public boolean isIgnoreSelectedColumn() {
        return this._ignore_selected_column;
    }

    public boolean isIgnoreSuidColumn() {
        return this._ignore_suid_column;
    }

    public boolean isTiming() {
        return this._timing;
    }

    public boolean isWriteSelectedOnlyIfTrue() {
        return this._write_selected_only_if_true;
    }

    public void setIgnoreSelectedColumn(boolean ignore_selected_column) {
        this._ignore_selected_column = ignore_selected_column;
    }

    public void setIgnoreSuidColumn(boolean ignore_suid_column) {
        this._ignore_suid_column = ignore_suid_column;
    }

    public void setTiming(boolean timing) {
        this._timing = timing;
    }

    public void setWriteSelectedOnlyIfTrue(boolean write_selected_only_if_true) {
        this._write_selected_only_if_true = write_selected_only_if_true;
    }

    public static final boolean isIgnore(String column_name, Set<String> additional_to_ignore, Object value) {
        if (value instanceof String && ((String)value).isEmpty()) {
            return true;
        }
        if (value instanceof List && ((List)value).isEmpty()) {
            return true;
        }
        switch (column_name) {
            case "SUID": {
                return INSTANCE.isIgnoreSuidColumn();
            }
            case "selected": {
                Boolean boolVal = value == null ? false : Boolean.valueOf(value.toString());
                return INSTANCE.isIgnoreSelectedColumn() || boolVal != true && INSTANCE.isWriteSelectedOnlyIfTrue();
            }
            case "CX Element ID": 
            case "CX MetaData": {
                return true;
            }
        }
        return additional_to_ignore != null && additional_to_ignore.contains(column_name);
    }

    private Settings() {
    }

    static {
        IGNORE_NODE_ATTRIBUTES.add("represents");
        IGNORE_SINGLE_NETWORK_NODE_ATTRIBUTES.add("name");
        IGNORE_SINGLE_NETWORK_NODE_ATTRIBUTES.add("shared name");
        IGNORE_SINGLE_NETWORK_EDGE_ATTRIBUTES.add("interaction");
        IGNORE_SINGLE_NETWORK_EDGE_ATTRIBUTES.add("shared interaction");
        IGNORE_SINGLE_NETWORK_EDGE_ATTRIBUTES.add("shared name");
        IGNORE_SINGLE_NETWORK_NETWORK_ATTRIBUTES.add("shared name");
        IGNORE_SINGLE_NETWORK_NETWORK_ATTRIBUTES.add("selected");
    }
}

