/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cxio;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.group.CyGroup;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.io.internal.AspectSet;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cx_writer.VisualPropertiesGatherer;
import org.cytoscape.io.internal.cxio.CxUtil;
import org.cytoscape.io.internal.cxio.Settings;
import org.cytoscape.io.internal.cxio.TimingUtil;
import org.cytoscape.io.internal.cxio.VisualPropertyType;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.TaskMonitor;
import org.ndexbio.cx2.aspect.element.core.CxAspectElement;
import org.ndexbio.cx2.aspect.element.core.CxAttributeDeclaration;
import org.ndexbio.cx2.aspect.element.core.CxEdge;
import org.ndexbio.cx2.aspect.element.core.CxEdgeBypass;
import org.ndexbio.cx2.aspect.element.core.CxMetadata;
import org.ndexbio.cx2.aspect.element.core.CxNetworkAttribute;
import org.ndexbio.cx2.aspect.element.core.CxNode;
import org.ndexbio.cx2.aspect.element.core.CxNodeBypass;
import org.ndexbio.cx2.aspect.element.core.CxVisualProperty;
import org.ndexbio.cx2.aspect.element.core.DeclarationEntry;
import org.ndexbio.cx2.aspect.element.core.DefaultVisualProperties;
import org.ndexbio.cx2.aspect.element.core.MappingDefinition;
import org.ndexbio.cx2.aspect.element.core.TableColumnVisualStyle;
import org.ndexbio.cx2.aspect.element.core.VPMappingType;
import org.ndexbio.cx2.aspect.element.core.VisualPropertyMapping;
import org.ndexbio.cx2.aspect.element.cytoscape.CxTableVisualProperty;
import org.ndexbio.cx2.aspect.element.cytoscape.DefaultTableType;
import org.ndexbio.cx2.aspect.element.cytoscape.VisualEditorProperties;
import org.ndexbio.cx2.converter.CXToCX2VisualPropertyConverter;
import org.ndexbio.cx2.io.CXWriter;
import org.ndexbio.cxio.aspects.datamodels.ATTRIBUTE_DATA_TYPE;
import org.ndexbio.cxio.aspects.datamodels.AbstractAttributesAspectElement;
import org.ndexbio.cxio.aspects.datamodels.AttributesAspectUtils;
import org.ndexbio.cxio.aspects.datamodels.CartesianLayoutElement;
import org.ndexbio.cxio.aspects.datamodels.CyGroupsElement;
import org.ndexbio.cxio.aspects.datamodels.CyTableColumnElement;
import org.ndexbio.cxio.aspects.datamodels.CyTableVisualPropertiesElement;
import org.ndexbio.cxio.aspects.datamodels.EdgeAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.EdgesElement;
import org.ndexbio.cxio.aspects.datamodels.HiddenAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NetworkAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NetworkRelationsElement;
import org.ndexbio.cxio.aspects.datamodels.NodeAttributesElement;
import org.ndexbio.cxio.aspects.datamodels.NodesElement;
import org.ndexbio.cxio.aspects.datamodels.SubNetworkElement;
import org.ndexbio.cxio.core.CxWriter;
import org.ndexbio.cxio.core.OpaqueAspectIterator;
import org.ndexbio.cxio.core.interfaces.AspectElement;
import org.ndexbio.cxio.core.interfaces.AspectFragmentWriter;
import org.ndexbio.cxio.metadata.MetaDataCollection;
import org.ndexbio.cxio.metadata.MetaDataElement;
import org.ndexbio.cxio.misc.AspectElementCounts;
import org.ndexbio.cxio.misc.OpaqueElement;
import org.ndexbio.cxio.util.CxioUtil;
import org.ndexbio.model.exceptions.NdexException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CxExporter {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean writeSiblings;
    private final boolean useCxId;
    private final CyNetwork baseNetwork;
    private final List<CySubNetwork> subnetworks;
    private boolean omitOpaqueAspects = false;
    private List<String> nodeColumns;
    private List<String> edgeColumns;
    private List<String> networkColumns;
    private HashMap<String, Long> idCounters = new HashMap();
    private Set<CyGroup> collapsed_groups;
    private final CyGroupManager group_manager;
    private final CyNetworkViewManager _networkview_manager;
    private CxWriter writer;
    private String ID_STRING = "_id";
    private CyNetworkView view;
    private TaskMonitor taskMonitor;

    public CxExporter(CyNetwork network, CyNetworkView view, boolean useCxId, TaskMonitor taskMonitor) throws NdexException {
        this(network, false, useCxId, taskMonitor);
        if (!((CyNetwork)view.getModel()).getSUID().equals(network.getSUID())) {
            throw new NdexException("The specified network (SUID=" + network.getSUID() + ") doesn't have a view with SUID=" + view.getSUID() + ".");
        }
        this.view = view;
    }

    public CxExporter(CyNetwork network, boolean writeSiblings, boolean useCxId, TaskMonitor taskMonitor) {
        if (writeSiblings && useCxId) {
            throw new IllegalArgumentException("Cannot export a collection with CX IDs.");
        }
        this.writeSiblings = writeSiblings;
        this.useCxId = useCxId;
        this.view = null;
        this.taskMonitor = taskMonitor;
        this.subnetworks = this.makeSubNetworkList((CySubNetwork)network);
        if (this.subnetworks.isEmpty()) {
            throw new IllegalArgumentException("Could not find subnetworks to export");
        }
        this.baseNetwork = writeSiblings ? this.subnetworks.get(0).getRootNetwork() : network;
        this.group_manager = CyServiceModule.getService(CyGroupManager.class);
        this._networkview_manager = CyServiceModule.getService(CyNetworkViewManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeNetwork(Collection<String> aspects, OutputStream out) throws IOException {
        AspectElementCounts counts;
        if (aspects == null || aspects.isEmpty()) {
            aspects = AspectSet.getAspectNames();
        }
        if (aspects.size() != AspectSet.getAspectNames().size()) {
            this.omitOpaqueAspects = true;
        }
        String net_type = this.writeSiblings ? "collection" : "subnetwork";
        String id_type = this.useCxId ? "CX IDs" : "SUIDs";
        this.logger.info("Exporting network as " + net_type + " with " + id_type);
        this.logger.info("Aspect filter: " + String.valueOf(aspects));
        this.logger.info("NodeCol filter: " + String.valueOf(this.nodeColumns));
        this.logger.info("EdgeCol filter: " + String.valueOf(this.edgeColumns));
        this.logger.info("NetworkCol filter: " + String.valueOf(this.networkColumns));
        CySessionManager session_manager = CyServiceModule.getService(CySessionManager.class);
        session_manager.getCurrentSession();
        if (!aspects.contains("cySubNetworks")) {
            if (aspects.contains("cyVisualProperties")) {
                throw new IllegalArgumentException("need to write sub-networks in order to write visual properties");
            }
            if (aspects.contains("cartesianLayout")) {
                throw new IllegalArgumentException("need to write sub-networks in order to write cartesian layout");
            }
        }
        this.writer = CxWriter.createInstance((OutputStream)out, (boolean)false);
        for (AspectFragmentWriter aspect_writer : AspectSet.getAspectFragmentWriters(aspects)) {
            this.writer.addAspectFragmentWriter(aspect_writer);
        }
        MetaDataCollection meta_data = this.writePreMetaData(aspects);
        this.writer.start();
        String msg = null;
        boolean success = true;
        this.collapsed_groups = this.expandGroups();
        try {
            this.writeTableColumns();
            this.writeNetworkAttributes();
            this.writeNodes();
            this.writeEdges();
            this.writeNodeAttributes();
            this.writeEdgeAttributes();
            if (this.writeSiblings) {
                this.writeCxIds();
            }
            this.writeSubNetworks();
            this.writeTableVisualStyles(null);
            this.writeHiddenAttributes();
            AspectElementCounts aspects_counts = this.writer.getAspectElementCounts();
            this.writePostMetadata(meta_data, aspects_counts);
            CxUtil.setMetaData(this.baseNetwork, meta_data);
        }
        catch (Exception e) {
            e.printStackTrace();
            msg = "Failed to create cx network: " + e.getMessage();
            success = false;
        }
        finally {
            this.collapsed_groups.forEach(group -> {
                for (CyNetwork net : group.getNetworkSet()) {
                    if (!(net instanceof CySubNetwork)) continue;
                    group.collapse(net);
                }
            });
        }
        this.writer.end(success, msg);
        if (success && (counts = this.writer.getAspectElementCounts()) != null) {
            System.out.println("Aspects elements written out:");
            System.out.println(counts);
        }
    }

    private MetaDataCollection writePreMetaData(Collection<String> aspects) {
        MetaDataCollection pre_meta_data = CxUtil.getMetaData(this.baseNetwork);
        if (pre_meta_data.isEmpty()) {
            for (AspectFragmentWriter aspect : AspectSet.getAspectFragmentWriters(aspects)) {
                if (aspect.getAspectName().equals("edges")) {
                    if (this.baseNetwork.getEdgeCount() <= 0) continue;
                    CxExporter.addDataToMetaDataCollection(pre_meta_data, aspect.getAspectName(), null, null);
                    continue;
                }
                if (aspect.getAspectName().equals("edgeAttributes")) {
                    if (this.baseNetwork.getEdgeCount() <= 0) continue;
                    CxExporter.addDataToMetaDataCollection(pre_meta_data, aspect.getAspectName(), null, null);
                    continue;
                }
                CxExporter.addDataToMetaDataCollection(pre_meta_data, aspect.getAspectName(), null, null);
            }
        }
        this.writer.addPreMetaData(pre_meta_data);
        return pre_meta_data;
    }

    private List<CxMetadata> getCx2Metadata(Collection<String> aspects, CxAttributeDeclaration attrDecls) {
        ArrayList<CxMetadata> result = new ArrayList<CxMetadata>();
        List<CxMetadata> opapqueAspects = CxUtil.getOpaqueAspects(this.baseNetwork);
        if (!attrDecls.getDeclarations().isEmpty()) {
            result.add(new CxMetadata("attributeDeclarations", 1L));
        }
        if (aspects == null || aspects.size() == 0) {
            CySubNetwork subnet;
            Collection views;
            Iterator<CySubNetwork> iterator;
            int nodeCount;
            int edgeCount;
            if (attrDecls.getAttributesInAspect("networkAttributes") != null) {
                result.add(new CxMetadata("networkAttributes", 1L));
            }
            if ((edgeCount = this.baseNetwork.getEdgeCount()) > 0) {
                result.add(new CxMetadata("edges", (long)edgeCount));
            }
            if ((nodeCount = this.baseNetwork.getNodeCount()) > 0) {
                result.add(new CxMetadata("nodes", (long)nodeCount));
            }
            if ((iterator = this.subnetworks.iterator()).hasNext() && !(views = this._networkview_manager.getNetworkViews((CyNetwork)(subnet = iterator.next()))).isEmpty()) {
                result.add(new CxMetadata("visualProperties", 1L));
                result.add(new CxMetadata("visualEditorProperties", 1L));
                result.add(new CxMetadata("edgeBypasses"));
                result.add(new CxMetadata("nodeBypasses"));
            }
            result.add(new CxMetadata("tableVisualProperties"));
            result.addAll(opapqueAspects);
        }
        return result;
    }

    private final void writePostMetadata(MetaDataCollection meta_data, AspectElementCounts aspects_counts) {
        if (meta_data == null) {
            throw new IllegalArgumentException("Cannot populate null post metaData");
        }
        for (String name : aspects_counts.getAllAspectNames()) {
            long count = aspects_counts.getAspectElementCount(name);
            Long idCounter = this.idCounters.getOrDefault(name, null);
            if (count <= 0L) continue;
            CxExporter.addDataToMetaDataCollection(meta_data, name, count, idCounter);
        }
        long t0 = System.currentTimeMillis();
        this.writer.addPostMetaData(meta_data);
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, "post meta-data", -1);
        }
    }

    private final void writeTableColumns() throws IOException {
        ArrayList<AspectElement> elements = new ArrayList<AspectElement>();
        if (this.writeSiblings) {
            this.addTableColumnsHelper(this.baseNetwork, "network_table", elements, "SHARED_ATTRS");
            this.addTableColumnsHelper(this.baseNetwork, "node_table", elements, "SHARED_ATTRS");
            this.addTableColumnsHelper(this.baseNetwork, "edge_table", elements, "SHARED_ATTRS");
        }
        for (CySubNetwork subnet : this.subnetworks) {
            this.addTableColumnsHelper((CyNetwork)subnet, "node_table", elements, "USER");
            this.addTableColumnsHelper((CyNetwork)subnet, "edge_table", elements, "USER");
            this.addTableColumnsHelper((CyNetwork)subnet, "network_table", elements, "USER");
        }
        this.writeAspectElements(elements);
    }

    private final void addTableColumnsHelper(CyNetwork network, String applies_to, List<AspectElement> elements, String namespace) {
        CyTable table = null;
        Set<String> additional_ignore = switch (applies_to) {
            case "node_table" -> {
                table = network.getTable(CyNode.class, namespace);
                yield Settings.IGNORE_NODE_ATTRIBUTES;
            }
            case "edge_table" -> {
                table = network.getTable(CyEdge.class, namespace);
                yield Settings.IGNORE_EDGE_ATTRIBUTES;
            }
            case "network_table" -> {
                table = network.getTable(CyNetwork.class, namespace);
                yield Settings.IGNORE_NETWORK_ATTRIBUTES;
            }
            default -> throw new IllegalArgumentException("Unknown applies_to in CyTableColumn: " + applies_to);
        };
        Collection c = table.getColumns();
        for (CyColumn col : c) {
            String colName = col.getName();
            if (Settings.isIgnore(colName, additional_ignore, null) || colName.startsWith("CX_OPAQUE::") || applies_to.equals("edge_table") && (colName.startsWith("node::Source_") || colName.startsWith("node::Target_"))) continue;
            ATTRIBUTE_DATA_TYPE type = ATTRIBUTE_DATA_TYPE.STRING;
            type = col.getType() != List.class ? CxUtil.toAttributeType(col.getType()) : CxUtil.toListAttributeType(col.getListElementType());
            Long subnetId = this.getAspectSubnetworkId(network);
            if (this.writeSiblings && network instanceof CySubNetwork && col.getVirtualColumnInfo().isVirtual()) continue;
            CyTableColumnElement x = new CyTableColumnElement(subnetId, applies_to, col.getName(), type);
            elements.add((AspectElement)x);
        }
    }

    private static Map<String, DeclarationEntry> getTableAttributes(CyNetwork network, String applies_to) {
        String namespace = "USER";
        CyTable table = null;
        Set<String> additional_ignore = switch (applies_to) {
            case "node_table" -> {
                table = network.getTable(CyNode.class, namespace);
                yield Settings.CX2_IGNORE_NODE_ATTRIBUTES;
            }
            case "edge_table" -> {
                table = network.getTable(CyEdge.class, namespace);
                yield Settings.IGNORE_EDGE_ATTRIBUTES;
            }
            case "network_table" -> {
                table = network.getTable(CyNetwork.class, namespace);
                yield Settings.IGNORE_NETWORK_ATTRIBUTES;
            }
            default -> throw new IllegalArgumentException("Unknown applies_to in CyTableColumn: " + applies_to);
        };
        HashMap<String, DeclarationEntry> result = new HashMap<String, DeclarationEntry>();
        Collection c = table.getColumns();
        for (CyColumn col : c) {
            String colName = col.getName();
            if (Settings.isIgnore(colName, additional_ignore, true) || applies_to.equals("network_table") && colName.startsWith("CX_OPAQUE::") || applies_to.equals("edge_table") && (colName.startsWith("node::Source_") || colName.startsWith("node::Target_"))) continue;
            ATTRIBUTE_DATA_TYPE type = ATTRIBUTE_DATA_TYPE.STRING;
            type = col.getType() != List.class ? CxUtil.toAttributeType(col.getType()) : CxUtil.toListAttributeType(col.getListElementType());
            result.put(col.getName(), new DeclarationEntry(type, null, null));
        }
        return result;
    }

    private final void writeNetworkAttributes() throws IOException {
        ArrayList<AbstractAttributesAspectElement> elements = new ArrayList<AbstractAttributesAspectElement>();
        if (this.writeSiblings) {
            this.addNetworkAttributesHelper("USER", this.baseNetwork, elements);
        }
        for (CySubNetwork subnet : this.subnetworks) {
            this.addNetworkAttributesHelper("USER", (CyNetwork)subnet, elements);
        }
        this.writeAspectElements(elements);
    }

    private void writeCx2NetworkAttributes(CXWriter cx2writer) throws JsonGenerationException, JsonMappingException, IOException, NdexException {
        block2: {
            Map values;
            CySubNetwork subnet;
            CyRow row;
            CxNetworkAttribute result = new CxNetworkAttribute();
            Iterator<CySubNetwork> iterator = this.subnetworks.iterator();
            if (!iterator.hasNext() || (row = (subnet = iterator.next()).getRow((CyIdentifiable)subnet, "USER")) == null || (values = row.getAllValues()) == null) break block2;
            for (Map.Entry e : values.entrySet()) {
                String columnName = (String)e.getKey();
                if (e.getValue() == null || Settings.isIgnore(columnName, Settings.IGNORE_NETWORK_ATTRIBUTES, e.getValue()) || this.networkColumns != null && !this.networkColumns.contains(columnName)) continue;
                if (columnName.startsWith("CX_OPAQUE::")) {
                    String opaqueAspName = columnName.substring("CX_OPAQUE::".length());
                    cx2writer.writeAspectFromJSONString(columnName, (String)e.getValue());
                    continue;
                }
                Object v = e.getValue();
                if (!CxExporter.isNotNullandFinite(v)) continue;
                result.add(columnName, v);
            }
            cx2writer.writeFullAspectFragment(Arrays.asList(result));
        }
    }

    private void writeTableVisualStyles(CXWriter cx2Writer) throws IOException, NdexException {
        CyApplicationManager appManager = CyServiceModule.getService(CyApplicationManager.class);
        CyTableViewManager tableViewManager = CyServiceModule.getService(CyTableViewManager.class);
        TableVisualMappingManager tableVisualMappingManager = CyServiceModule.getService(TableVisualMappingManager.class);
        ArrayList<CyTableVisualPropertiesElement> tableStyles = new ArrayList<CyTableVisualPropertiesElement>();
        if (this.writeSiblings) {
            for (CySubNetwork subnet : this.subnetworks) {
                CyTableVisualPropertiesElement styles = new CyTableVisualPropertiesElement();
                styles.setSubnetId(this.getAspectSubnetworkId((CyNetwork)subnet));
                CxExporter.processCyTableVisualStyles(DefaultTableType.Network, subnet.getDefaultNetworkTable(), appManager, tableVisualMappingManager, tableViewManager, styles);
                CxExporter.processCyTableVisualStyles(DefaultTableType.Node, subnet.getDefaultNodeTable(), appManager, tableVisualMappingManager, tableViewManager, styles);
                CxExporter.processCyTableVisualStyles(DefaultTableType.Edge, subnet.getDefaultEdgeTable(), appManager, tableVisualMappingManager, tableViewManager, styles);
                if (styles.getTableStyles().isEmpty()) continue;
                tableStyles.add(styles);
            }
        } else {
            CyTableVisualPropertiesElement styles = new CyTableVisualPropertiesElement();
            CxExporter.processCyTableVisualStyles(DefaultTableType.Network, this.baseNetwork.getDefaultNetworkTable(), appManager, tableVisualMappingManager, tableViewManager, styles);
            CxExporter.processCyTableVisualStyles(DefaultTableType.Node, this.baseNetwork.getDefaultNodeTable(), appManager, tableVisualMappingManager, tableViewManager, styles);
            CxExporter.processCyTableVisualStyles(DefaultTableType.Edge, this.baseNetwork.getDefaultEdgeTable(), appManager, tableVisualMappingManager, tableViewManager, styles);
            if (!styles.getTableStyles().isEmpty()) {
                tableStyles.add(styles);
            }
        }
        if (!tableStyles.isEmpty()) {
            if (cx2Writer != null) {
                cx2Writer.writeFullAspectFragment(tableStyles.stream().map(x -> new CxTableVisualProperty(x)).collect(Collectors.toList()));
            } else {
                this.writeAspectElements(tableStyles.stream().map(x -> x).collect(Collectors.toList()));
            }
        }
    }

    private static <T> void processCyTableVisualStyles(DefaultTableType type, CyTable table, CyApplicationManager appManager, TableVisualMappingManager tableVisualMappingManager, CyTableViewManager tableViewManager, CyTableVisualPropertiesElement tableStyles) {
        CyTableView tableView;
        if (table != null && (tableView = tableViewManager.getTableView(table)) != null) {
            TableViewRenderer renderer = appManager.getTableViewRenderer(tableView.getRendererId());
            RenderingEngineFactory factory = renderer.getRenderingEngineFactory("");
            VisualLexicon lexicon = factory.getVisualLexicon();
            Set allVisualProperties = lexicon.getAllVisualProperties();
            HashMap<String, HashMap<String, TableColumnVisualStyle>> styleEntry = new HashMap<String, HashMap<String, TableColumnVisualStyle>>();
            for (View colView : tableView.getColumnViews()) {
                VisualStyle style = tableVisualMappingManager.getVisualStyle(colView);
                if (style == null) continue;
                for (VisualProperty vpo : allVisualProperties) {
                    VisualProperty vp = vpo;
                    Object v = style.getDefaultValue(vp);
                    if (v == null) continue;
                    VisualMappingFunction f = style.getVisualMappingFunction(vp);
                    if (v.equals(vp.getDefault()) && f == null) continue;
                    TableColumnVisualStyle s = new TableColumnVisualStyle();
                    if (!v.equals(vp.getDefault())) {
                        s.setDefaultValue(CxUtil.cvtVisualPropertyValueAsCX2Obj(v, vp));
                    }
                    if (f != null) {
                        s.setMapping(CxExporter.cvtMapping(f, vp));
                    }
                    CyColumn col = (CyColumn)colView.getModel();
                    String colName = col.getName();
                    boolean isVirtual = col.getVirtualColumnInfo().isVirtual();
                    System.out.println(colName + " is virtual = " + isVirtual);
                    HashMap<String, TableColumnVisualStyle> columStyle = (HashMap<String, TableColumnVisualStyle>)styleEntry.get(colName);
                    if (columStyle == null) {
                        columStyle = new HashMap<String, TableColumnVisualStyle>();
                    }
                    columStyle.put(vp.getIdString(), s);
                    styleEntry.put(((CyColumn)colView.getModel()).getName(), columStyle);
                }
            }
            if (!styleEntry.isEmpty()) {
                tableStyles.getTableStyles().put(type, styleEntry);
            }
        }
    }

    private static <T> VisualPropertyMapping cvtMapping(VisualMappingFunction<?, T> mapping, VisualProperty<T> vp) {
        VisualPropertyMapping result = new VisualPropertyMapping();
        MappingDefinition defObj = new MappingDefinition();
        result.setMappingDef(defObj);
        String col = mapping.getMappingColumnName();
        defObj.setAttributeName(col);
        if (mapping instanceof PassthroughMapping) {
            result.setType(VPMappingType.PASSTHROUGH);
        } else if (mapping instanceof DiscreteMapping) {
            DiscreteMapping dm = (DiscreteMapping)mapping;
            Map map = dm.getAll();
            ArrayList m = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                HashMap<String, Object> mapEntry = new HashMap<String, Object>(2);
                mapEntry.put("v", entry.getKey());
                mapEntry.put("vp", CxUtil.cvtVisualPropertyValueAsCX2Obj(value, vp));
                m.add(mapEntry);
            }
            defObj.setMapppingList(m);
            result.setType(VPMappingType.DISCRETE);
        } else if (mapping instanceof ContinuousMapping) {
            ContinuousMapping cm = (ContinuousMapping)mapping;
            ArrayList m = new ArrayList();
            Object min = null;
            Boolean includeMin = null;
            Object minVP = null;
            int counter = 0;
            HashMap<String, Object> currentMapping = new HashMap<String, Object>();
            for (ContinuousMappingPoint cp : cm.getAllPoints()) {
                Object lesser = cp.getRange().lesserValue;
                Object equal = cp.getRange().equalValue;
                Object greater = cp.getRange().greaterValue;
                Object OV = cp.getValue();
                currentMapping.put("maxVPValue", CxUtil.cvtVisualPropertyValueAsCX2Obj(lesser, vp));
                currentMapping.put("includeMax", equal.equals(lesser));
                currentMapping.put("max", OV);
                if (counter == 0) {
                    currentMapping.put("includeMin", Boolean.FALSE);
                } else {
                    currentMapping.put("includeMin", includeMin);
                    currentMapping.put("minVPValue", minVP);
                    currentMapping.put("min", min);
                }
                m.add(currentMapping);
                includeMin = equal.equals(greater);
                min = OV;
                minVP = CxUtil.cvtVisualPropertyValueAsCX2Obj(greater, vp);
                currentMapping = new HashMap();
                ++counter;
            }
            currentMapping.put("includeMin", includeMin);
            currentMapping.put("includeMax", Boolean.FALSE);
            currentMapping.put("minVPValue", minVP);
            currentMapping.put("min", min);
            m.add(currentMapping);
            defObj.setMapppingList(m);
            result.setType(VPMappingType.CONTINUOUS);
        }
        return result;
    }

    private final void writeHiddenAttributes() throws IOException {
        ArrayList<AbstractAttributesAspectElement> elements = new ArrayList<AbstractAttributesAspectElement>();
        if (this.writeSiblings) {
            this.addNetworkAttributesHelper("HIDDEN", this.baseNetwork, elements);
        }
        for (CySubNetwork subnet : this.subnetworks) {
            this.addNetworkAttributesHelper("HIDDEN", (CyNetwork)subnet, elements);
        }
        List<AspectElement> cleanedAttributes = elements.stream().filter(x -> !x.getName().equals("NDEx UUID") && !x.getName().equals("NDEx Modification Timestamp")).collect(Collectors.toList());
        this.writeAspectElements(cleanedAttributes);
    }

    private void writeOpaqueElement(String column, String value) throws JsonParseException, IOException {
        if (this.omitOpaqueAspects) {
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
        OpaqueAspectIterator iter = new OpaqueAspectIterator((InputStream)in);
        this.writer.startAspectFragment(column);
        while (iter.hasNext()) {
            OpaqueElement el = iter.next();
            JsonNode node = el.getData().get("@id");
            if (node != null) {
                Long max = Long.max(node.asLong(), this.idCounters.getOrDefault(column, 0L));
                this.idCounters.put(column, max);
            }
            this.writer.writeOpaqueAspectElement(el);
        }
        this.writer.endAspectFragment();
    }

    private final void writeNodes() throws IOException {
        HashMap<String, List<AspectElement>> elementMap = new HashMap<String, List<AspectElement>>();
        elementMap.put("nodes", new ArrayList());
        elementMap.put("cyGroups", new ArrayList());
        for (CyNode cy_node : this.baseNetwork.getNodeList()) {
            this.addNodesAndGroupsElements(elementMap, cy_node, this.baseNetwork);
        }
        for (String aspect : elementMap.keySet()) {
            this.writeAspectElements(elementMap.get(aspect));
        }
    }

    private void writeCx2Nodes(CXWriter cx2Writer, CySubNetwork subnet) throws IOException, NdexException {
        if (subnet.getNodeCount() == 0) {
            return;
        }
        boolean z_used = false;
        if (this.view != null) {
            for (View node_view : this.view.getNodeViews()) {
                Double z = (Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION);
                if (z == null || !(Math.abs(z) > 1.0E-9)) continue;
                z_used = true;
                break;
            }
        }
        cx2Writer.startAspectFragment("nodes");
        for (CyNode cyNode : subnet.getNodeList()) {
            Long nodeId = CxUtil.getElementId((CyIdentifiable)cyNode, (CyNetwork)subnet, this.useCxId);
            LinkedHashMap nodeAttrs = new LinkedHashMap();
            CyRow row = subnet.getRow((CyIdentifiable)cyNode, "USER");
            for (Map.Entry e : row.getAllValues().entrySet()) {
                Object value = e.getValue();
                String name = (String)e.getKey();
                if (!CxExporter.isNotNullandFinite(value) || Settings.isIgnore(name, Settings.IGNORE_NODE_ATTRIBUTES, value) || this.nodeColumns != null && !this.nodeColumns.contains(name)) continue;
                nodeAttrs.put(name, value);
            }
            CxNode cx2Node = new CxNode(nodeId, nodeAttrs);
            if (this.view != null) {
                View nodeView = this.view.getNodeView(cyNode);
                cx2Node.setX((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION));
                cx2Node.setY((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION));
                if (z_used) {
                    cx2Node.setZ((Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION));
                }
            }
            cx2Writer.writeElementInFragment((CxAspectElement)cx2Node);
        }
        cx2Writer.endAspectFragment();
    }

    private static boolean isNotNullandFinite(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Double) {
            return Double.isFinite((Double)value);
        }
        return true;
    }

    private final void writeEdges() throws IOException {
        ArrayList<AspectElement> edgeElements = new ArrayList<AspectElement>();
        for (CyEdge edge : this.baseNetwork.getEdgeList()) {
            edgeElements.add((AspectElement)this.createEdgeElement(edge, this.baseNetwork));
        }
        this.writeAspectElements(edgeElements);
    }

    private void writeCx2Edges(CXWriter cx2Writer) throws IOException, NdexException {
        block4: {
            Iterator<CySubNetwork> iterator = this.subnetworks.iterator();
            if (!iterator.hasNext()) break block4;
            CySubNetwork subnet = iterator.next();
            if (subnet.getEdgeCount() == 0) {
                return;
            }
            cx2Writer.startAspectFragment("edges");
            for (CyEdge cyEdge : subnet.getEdgeList()) {
                CxEdge cxEdge = new CxEdge(CxUtil.getElementId((CyIdentifiable)cyEdge, (CyNetwork)subnet, this.useCxId), CxUtil.getElementId((CyIdentifiable)cyEdge.getSource(), (CyNetwork)subnet, this.useCxId), CxUtil.getElementId((CyIdentifiable)cyEdge.getTarget(), (CyNetwork)subnet, this.useCxId));
                LinkedHashMap edgeAttrs = new LinkedHashMap();
                CyRow row = subnet.getRow((CyIdentifiable)cyEdge, "USER");
                for (Map.Entry e : row.getAllValues().entrySet()) {
                    String name = (String)e.getKey();
                    Object value = e.getValue();
                    if (!CxExporter.isNotNullandFinite(value) || Settings.isIgnore(name, Settings.IGNORE_NODE_ATTRIBUTES, value) || this.edgeColumns != null && !this.edgeColumns.contains(name) || name.startsWith("node::Source_") || name.startsWith("node::Target_")) continue;
                    edgeAttrs.put(name, value);
                }
                if (!edgeAttrs.isEmpty()) {
                    cxEdge.setAttributes(edgeAttrs);
                }
                cx2Writer.writeElementInFragment((CxAspectElement)cxEdge);
            }
            cx2Writer.endAspectFragment();
        }
    }

    private void writeNodeAttributes() throws IOException {
        ArrayList<AspectElement> nodeAttributes = new ArrayList<AspectElement>();
        ArrayList shared_cols = new ArrayList();
        if (this.writeSiblings) {
            CyTable table = this.baseNetwork.getTable(CyNode.class, "SHARED_ATTRS");
            table.getColumns().forEach(col -> shared_cols.add(col.getName()));
            for (CyNode node : this.baseNetwork.getNodeList()) {
                CyRow row = this.baseNetwork.getRow((CyIdentifiable)node, "SHARED_ATTRS");
                row.getAllValues().forEach((name, value) -> this.addNodeAttributesElement((List<AspectElement>)nodeAttributes, this.baseNetwork, node, (String)name, value));
            }
        }
        for (CySubNetwork network : this.subnetworks) {
            for (CyNode node : network.getNodeList()) {
                CyRow row = network.getRow((CyIdentifiable)node, "USER");
                row.getAllValues().forEach((name, value) -> {
                    if (!shared_cols.contains(name)) {
                        this.addNodeAttributesElement((List<AspectElement>)nodeAttributes, (CyNetwork)network, node, (String)name, value);
                    }
                });
            }
        }
        this.writeAspectElements(nodeAttributes);
    }

    private void writeEdgeAttributes() throws IOException {
        ArrayList<AspectElement> edgeAttributes = new ArrayList<AspectElement>();
        ArrayList shared_cols = new ArrayList();
        if (this.writeSiblings) {
            CyTable table = this.baseNetwork.getTable(CyEdge.class, "SHARED_ATTRS");
            table.getColumns().forEach(col -> shared_cols.add(col.getName()));
            for (CyEdge edge : this.baseNetwork.getEdgeList()) {
                CyRow row = this.baseNetwork.getRow((CyIdentifiable)edge, "SHARED_ATTRS");
                row.getAllValues().forEach((name, value) -> this.addEdgeAttributesElement((List<AspectElement>)edgeAttributes, this.baseNetwork, edge, (String)name, value));
            }
        }
        for (CySubNetwork network : this.subnetworks) {
            for (CyEdge edge : network.getEdgeList()) {
                CyRow row = network.getRow((CyIdentifiable)edge);
                row.getAllValues().entrySet().stream().filter(entry -> !shared_cols.contains(entry.getKey())).forEach(e -> this.addEdgeAttributesElement(edgeAttributes, (CyNetwork)network, edge, (String)e.getKey(), e.getValue()));
            }
        }
        this.writeAspectElements(edgeAttributes);
    }

    private static void addDataToMetaDataCollection(MetaDataCollection meta_data, String aspect_name, Long count, Long id_counter) {
        if (count != null && count == 0L) {
            return;
        }
        MetaDataElement e = meta_data.getMetaDataElement(aspect_name);
        if (e == null) {
            e = new MetaDataElement(aspect_name, "1.0");
            meta_data.add(e);
        }
        if (count != null) {
            e.setElementCount(count);
        }
        if (id_counter != null) {
            e.setIdCounter(id_counter);
        }
    }

    private void addNetworkAttributesHelper(String namespace, CyNetwork my_network, List<AbstractAttributesAspectElement> elements) throws JsonParseException, IOException {
        CyRow row = my_network.getRow((CyIdentifiable)my_network, namespace);
        if (row == null) {
            return;
        }
        Map values = row.getAllValues();
        if (values == null) {
            return;
        }
        for (String column_name : values.keySet()) {
            System.out.println("writing column: " + column_name + " from " + my_network.toString());
            Object value = values.get(column_name);
            if (value == null || Settings.isIgnore(column_name, Settings.IGNORE_NETWORK_ATTRIBUTES, value) || this.networkColumns != null && !this.networkColumns.contains(column_name)) continue;
            if (column_name.startsWith("CX_OPAQUE::")) {
                this.writeOpaqueElement(column_name.substring("CX_OPAQUE::".length()), (String)value);
                continue;
            }
            Long subnet = this.getAspectSubnetworkId(my_network);
            Object element = null;
            ATTRIBUTE_DATA_TYPE type = AttributesAspectUtils.determineDataType(value);
            if (value instanceof List) {
                ArrayList<String> attr_values = new ArrayList<String>();
                for (Object v : (List)value) {
                    attr_values.add(String.valueOf(v));
                }
                if (!attr_values.isEmpty()) {
                    element = namespace.equals("HIDDEN") ? new HiddenAttributesElement(subnet, column_name, attr_values, type) : new NetworkAttributesElement(subnet, column_name, attr_values, type);
                }
            } else if (namespace.equals("HIDDEN")) {
                if (!column_name.equals("__parentNetwork.SUID") || subnet != null) {
                    element = new HiddenAttributesElement(subnet, column_name, String.valueOf(value), type);
                }
            } else {
                element = new NetworkAttributesElement(subnet, column_name, String.valueOf(value), type);
            }
            if (element == null) continue;
            elements.add((AbstractAttributesAspectElement)element);
        }
    }

    private void addNetworkRelationsElements(List<AspectElement> elements, CySubNetwork subnetwork) throws IOException {
        String name = CxUtil.getNetworkName((CyNetwork)subnetwork);
        elements.add((AspectElement)new NetworkRelationsElement(null, subnetwork.getSUID(), "subnetwork", name));
        Collection views = this._networkview_manager.getNetworkViews((CyNetwork)subnetwork);
        int i = 0;
        for (CyNetworkView view : views) {
            Object title = (String)view.getVisualProperty(BasicVisualLexicon.NETWORK_TITLE);
            if (title == null || ((String)title).isEmpty()) {
                title = name + " view";
                if (views.size() > 1) {
                    title = (String)title + " " + ++i;
                }
            }
            Long viewId = this.getViewId(view);
            elements.add((AspectElement)new NetworkRelationsElement(subnetwork.getSUID(), viewId, "view", (String)title));
        }
    }

    private void addNodesAndGroupsElements(Map<String, List<AspectElement>> elementMap, CyNode node, CyNetwork network) throws JsonProcessingException {
        List<AspectElement> nodes = elementMap.get("nodes");
        if (this.group_manager.isGroup(node, network)) {
            Long cxId = CxUtil.getElementId((CyIdentifiable)node, network, this.useCxId);
            nodes.add((AspectElement)new NodesElement(cxId.longValue(), null, null));
            List<AspectElement> groups = elementMap.get("cyGroups");
            CyGroup group = this.group_manager.getGroup(node, network);
            this.addGroupElement(groups, network, group);
        } else {
            nodes.add((AspectElement)this.createNodeElement(node, network));
        }
    }

    private void addGroupElement(List<AspectElement> elements, CyNetwork network, CyGroup group) throws JsonProcessingException {
        String name = null;
        CyRow row = network.getRow((CyIdentifiable)group.getGroupNode());
        if (row != null) {
            name = (String)row.get("name", String.class);
        }
        if (name == null) {
            name = (String)row.get("shared name", String.class);
        }
        boolean isCollapsed = this.collapsed_groups.contains(group);
        Long subnetId = this.getAspectSubnetworkId(network);
        CyGroupsElement group_element = new CyGroupsElement(CxUtil.getElementId((CyIdentifiable)group.getGroupNode(), network, this.useCxId), subnetId, name);
        group.getExternalEdgeList().forEach(edge -> group_element.addExternalEdge(CxUtil.getElementId((CyIdentifiable)edge, network, this.useCxId)));
        group.getInternalEdgeList().forEach(e -> group_element.addInternalEdge(CxUtil.getElementId((CyIdentifiable)e, network, this.useCxId)));
        group.getNodeList().forEach(n -> group_element.addNode(CxUtil.getElementId((CyIdentifiable)n, network, this.useCxId)));
        group_element.set_isCollapsed(isCollapsed);
        elements.add((AspectElement)group_element);
    }

    private void addNodeAttributesElement(List<AspectElement> elements, CyNetwork network, CyNode node, String name, Object value) {
        if (value == null) {
            return;
        }
        if (Settings.isIgnore(name, Settings.IGNORE_NODE_ATTRIBUTES, value)) {
            return;
        }
        if (this.nodeColumns != null && !this.nodeColumns.contains(name)) {
            return;
        }
        Long nodeId = CxUtil.getElementId((CyIdentifiable)node, network, this.useCxId);
        Long subnetworkId = this.getAspectSubnetworkId(network);
        ATTRIBUTE_DATA_TYPE type = AttributesAspectUtils.determineDataType((Object)value);
        if (!type.isSingleValueType()) {
            ArrayList<String> attr_values = new ArrayList<String>();
            for (Object v : (List)value) {
                attr_values.add(String.valueOf(v));
            }
            if (!attr_values.isEmpty()) {
                elements.add((AspectElement)new NodeAttributesElement(subnetworkId, nodeId, name, attr_values, type));
            }
        } else {
            elements.add((AspectElement)new NodeAttributesElement(subnetworkId, nodeId, name, String.valueOf(value), type));
        }
    }

    private void addEdgeAttributesElement(List<AspectElement> elements, CyNetwork network, CyEdge edge, String name, Object value) {
        if (value == null || value instanceof String && ((String)value).length() == 0 || name.startsWith("node::Source_") || name.startsWith("node::Target_")) {
            return;
        }
        if (Settings.isIgnore(name, Settings.IGNORE_EDGE_ATTRIBUTES, value)) {
            return;
        }
        if (this.edgeColumns != null && !this.edgeColumns.contains(name)) {
            return;
        }
        Long edgeId = CxUtil.getElementId((CyIdentifiable)edge, network, this.useCxId);
        Long subnetworkId = this.getAspectSubnetworkId(network);
        if (value instanceof List) {
            ArrayList<String> attr_values = new ArrayList<String>();
            for (Object v : (List)value) {
                attr_values.add(String.valueOf(v));
            }
            if (!attr_values.isEmpty()) {
                elements.add((AspectElement)new EdgeAttributesElement(subnetworkId, edgeId, name, attr_values, AttributesAspectUtils.determineDataType((Object)value)));
            }
        } else {
            elements.add((AspectElement)new EdgeAttributesElement(subnetworkId, edgeId, name, String.valueOf(value), AttributesAspectUtils.determineDataType((Object)value)));
        }
    }

    private void writeCxIds() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode data = mapper.createObjectNode();
        CyRootNetwork root = this.subnetworks.get(0).getRootNetwork();
        if (!CxUtil.hasCxIds((CyNetwork)root)) {
            return;
        }
        for (CySubNetwork net : this.subnetworks) {
            Long cxId;
            String suid;
            for (CyNode node : net.getNodeList()) {
                suid = String.valueOf(node.getSUID());
                cxId = CxUtil.getCxId((CyIdentifiable)node, root);
                if (cxId == null) continue;
                data.put(suid, cxId);
            }
            for (CyEdge edge : net.getEdgeList()) {
                suid = String.valueOf(edge.getSUID());
                cxId = CxUtil.getCxId((CyIdentifiable)edge, root);
                if (cxId == null) continue;
                data.put(suid, cxId);
            }
        }
        if (data.size() > 0) {
            OpaqueElement element = new OpaqueElement("CX Element ID", data);
            this.writer.startAspectFragment("CX Element ID");
            this.writer.writeOpaqueAspectElement(element);
            this.writer.endAspectFragment();
        }
    }

    private final void writeSubNetworks() throws IOException {
        ArrayList<AspectElement> cySubnetworkElements = new ArrayList<AspectElement>();
        ArrayList<AspectElement> networkRelationsElements = new ArrayList<AspectElement>();
        for (CySubNetwork subnet : this.subnetworks) {
            List<CyNetworkView> views = this.view != null ? Arrays.asList(this.view) : this._networkview_manager.getNetworkViews((CyNetwork)subnet);
            HashSet edge_suids = new HashSet();
            HashSet node_suids = new HashSet();
            for (CyNetworkView view : views) {
                VisualLexicon _lexicon = CxUtil.getLexicon(view);
                this.writeCartesianLayout(view);
                this.writeVisualProperties(view, _lexicon);
                view.getEdgeViews().forEach(ev -> edge_suids.add(((CyEdge)ev.getModel()).getSUID()));
                view.getNodeViews().forEach(nv -> node_suids.add(((CyNode)nv.getModel()).getSUID()));
            }
            if (this.writeSiblings || views.size() > 1) {
                this.addNetworkRelationsElements(networkRelationsElements, subnet);
            }
            if (!this.writeSiblings) continue;
            SubNetworkElement subnetwork_element = new SubNetworkElement(subnet.getSUID());
            subnetwork_element.setEdges(new ArrayList(edge_suids));
            subnetwork_element.setNodes(new ArrayList(node_suids));
            cySubnetworkElements.add((AspectElement)subnetwork_element);
        }
        if (!cySubnetworkElements.isEmpty()) {
            this.writeAspectElements(cySubnetworkElements);
        }
        if (!networkRelationsElements.isEmpty()) {
            this.writeAspectElements(networkRelationsElements);
        }
    }

    private final void writeCartesianLayout(CyNetworkView view) throws IOException {
        CyNetwork network = (CyNetwork)view.getModel();
        ArrayList<AspectElement> elements = new ArrayList<AspectElement>(network.getNodeCount());
        boolean z_used = false;
        for (View node_view : view.getNodeViews()) {
            Double z = (Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION);
            if (z == null || !(Math.abs(z) > 1.0E-9)) continue;
            z_used = true;
            break;
        }
        Long viewId = this.getViewId(view);
        for (View node_view : view.getNodeViews()) {
            Long nodeId = CxUtil.getElementId((CyIdentifiable)node_view.getModel(), network, this.useCxId);
            if (z_used) {
                elements.add((AspectElement)new CartesianLayoutElement(nodeId, viewId, ((Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION)).doubleValue(), ((Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION)).doubleValue(), ((Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION)).doubleValue()));
                continue;
            }
            Double x = (Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
            Double y = (Double)node_view.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
            elements.add((AspectElement)new CartesianLayoutElement(nodeId, viewId, x.toString(), y.toString()));
        }
        this.writeAspectElements(elements);
    }

    private final void writeVisualProperties(CyNetworkView view, VisualLexicon lexicon) throws IOException {
        HashSet<VisualPropertyType> types = new HashSet<VisualPropertyType>();
        types.add(VisualPropertyType.NETWORK);
        types.add(VisualPropertyType.NODES);
        types.add(VisualPropertyType.EDGES);
        types.add(VisualPropertyType.NODES_DEFAULT);
        types.add(VisualPropertyType.EDGES_DEFAULT);
        Long viewId = this.getViewId(view);
        List<AspectElement> elements = VisualPropertiesGatherer.gatherVisualPropertiesAsAspectElements(view, lexicon, types, viewId, this.useCxId, this.taskMonitor);
        this.writeAspectElements(elements);
    }

    private void writeCX2VisualProperties(CXWriter cx2Writer) throws NdexException, JsonGenerationException, JsonMappingException, IOException {
        VisualPropertyMapping cx2Mapping;
        String value_str;
        String idStr;
        String[] desiredKeys;
        if (this.view == null) {
            return;
        }
        VisualLexicon lexicon = CxUtil.getLexicon(this.view);
        CxVisualProperty cx2VisualProps = new CxVisualProperty();
        VisualEditorProperties editorProps = new VisualEditorProperties();
        CXToCX2VisualPropertyConverter cvtr = CXToCX2VisualPropertyConverter.getInstance();
        VisualMappingManager vmm = CyServiceModule.getService(VisualMappingManager.class);
        VisualStyle current_visual_style = vmm.getVisualStyle(this.view);
        Set all_visual_properties = lexicon.getAllVisualProperties();
        VisualPropertiesGatherer.addCx2EditorPropsDependency("nodeCustomGraphicsSizeSync", current_visual_style, editorProps);
        VisualPropertiesGatherer.addCx2EditorPropsDependency("nodeSizeLocked", current_visual_style, editorProps);
        VisualPropertiesGatherer.addCx2EditorPropsDependency("arrowColorMatchesEdge", current_visual_style, editorProps);
        Map rawProps = editorProps.getProperties();
        boolean nodeSizeLocked = rawProps.get("nodeSizeLocked").equals(Boolean.TRUE);
        boolean arrowColorMatchesEdge = rawProps.get("arrowColorMatchesEdge").equals(Boolean.TRUE);
        DefaultVisualProperties defaultProps = new DefaultVisualProperties();
        cx2VisualProps.setDefaultProps(defaultProps);
        HashMap<String, String> cx1Style = new HashMap<String, String>();
        for (String[] visual_property : all_visual_properties) {
            String value_str2;
            if (visual_property.getTargetDataType() != CyNetwork.class || (value_str2 = VisualPropertiesGatherer.getSerializableVisualProperty((View<? extends CyIdentifiable>)this.view, visual_property)) == null || CxioUtil.isEmpty((String)value_str2)) continue;
            cx1Style.put(visual_property.getIdString(), value_str2);
        }
        defaultProps.setNetworkProperties(cvtr.convertNetworkVPs(cx1Style));
        for (String key : desiredKeys = new String[]{"NETWORK_CENTER_X_LOCATION", "NETWORK_CENTER_Y_LOCATION", "NETWORK_SCALE_FACTOR"}) {
            String v = (String)cx1Style.get(key);
            if (v == null) continue;
            rawProps.put(key, Double.valueOf(v));
        }
        cx2Writer.writeFullAspectFragment(Arrays.asList(editorProps));
        cx1Style.clear();
        CyTable table = ((CyNetwork)this.view.getModel()).getTable(CyNode.class, "USER");
        for (VisualProperty visual_property : all_visual_properties) {
            if (visual_property.getTargetDataType() != CyNode.class) continue;
            idStr = visual_property.getIdString();
            value_str = VisualPropertiesGatherer.getDefaultPropertyAsString(current_visual_style, visual_property);
            if (value_str != null && !CxioUtil.isEmpty((String)value_str)) {
                cx1Style.put(idStr, value_str);
            }
            if ((cx2Mapping = VisualPropertiesGatherer.getCX2Mapping(current_visual_style, visual_property, table, this.taskMonitor)) == null) continue;
            if (idStr.equals("NODE_SIZE")) {
                if (!nodeSizeLocked) continue;
                cx2VisualProps.getNodeMappings().put("NODE_WIDTH", cx2Mapping);
                cx2VisualProps.getNodeMappings().put("NODE_HEIGHT", cx2Mapping);
                continue;
            }
            if (nodeSizeLocked && idStr.equals("NODE_WIDTH") && idStr.equals("NODE_HEIGHT")) continue;
            cx2VisualProps.getNodeMappings().put(cvtr.getNewEdgeOrNodeProperty(idStr), cx2Mapping);
        }
        if (nodeSizeLocked) {
            CXToCX2VisualPropertyConverter.cvtCx1NodeSize(cx1Style);
        }
        defaultProps.setNodeProperties(cvtr.convertEdgeOrNodeVPs(cx1Style));
        cx1Style.clear();
        table = ((CyNetwork)this.view.getModel()).getTable(CyEdge.class, "USER");
        for (VisualProperty visual_property : all_visual_properties) {
            String cx2VP;
            idStr = visual_property.getIdString();
            if (visual_property.getTargetDataType() != CyEdge.class) continue;
            value_str = VisualPropertiesGatherer.getDefaultPropertyAsString(current_visual_style, visual_property);
            if (value_str != null && !CxioUtil.isEmpty((String)value_str)) {
                cx1Style.put(visual_property.getIdString(), value_str);
            }
            if ((cx2Mapping = VisualPropertiesGatherer.getCX2Mapping(current_visual_style, visual_property, table, this.taskMonitor)) == null) continue;
            if (idStr.equals("EDGE_UNSELECTED_PAINT")) {
                if (!arrowColorMatchesEdge) continue;
                cx2VisualProps.getEdgeMappings().put("EDGE_SOURCE_ARROW_COLOR", cx2Mapping);
                cx2VisualProps.getEdgeMappings().put("EDGE_LINE_COLOR", cx2Mapping);
                cx2VisualProps.getEdgeMappings().put("EDGE_TARGET_ARROW_COLOR", cx2Mapping);
                continue;
            }
            if (arrowColorMatchesEdge && (idStr.equals("EDGE_SOURCE_ARROW_UNSELECTED_PAINT") || idStr.equals("EDGE_STROKE_UNSELECTED_PAINT") || idStr.equals("EDGE_TARGET_ARROW_UNSELECTED_PAINT")) || (cx2VP = cvtr.getNewEdgeOrNodeProperty(idStr)) == null) continue;
            cx2VisualProps.getEdgeMappings().put(cx2VP, cx2Mapping);
        }
        if (arrowColorMatchesEdge) {
            CXToCX2VisualPropertyConverter.cvtCx1EdgeColor(cx1Style);
        }
        defaultProps.setEdgeProperties(cvtr.convertEdgeOrNodeVPs(cx1Style));
        cx2Writer.writeFullAspectFragment(Arrays.asList(cx2VisualProps));
        List<CxNodeBypass> nodeBypasses = VisualPropertiesGatherer.getNodeBypasses(this.view, all_visual_properties, this.useCxId, nodeSizeLocked);
        cx2Writer.writeFullAspectFragment(nodeBypasses);
        List<CxEdgeBypass> edgeBypasses = VisualPropertiesGatherer.getEdgeBypasses(this.view, all_visual_properties, this.useCxId, arrowColorMatchesEdge);
        cx2Writer.writeFullAspectFragment(edgeBypasses);
    }

    private EdgesElement createEdgeElement(CyEdge edge, CyNetwork network) {
        Long cxId = CxUtil.getElementId((CyIdentifiable)edge, network, this.useCxId);
        Long sourceId = CxUtil.getElementId((CyIdentifiable)edge.getSource(), network, this.useCxId);
        Long targetId = CxUtil.getElementId((CyIdentifiable)edge.getTarget(), network, this.useCxId);
        String interaction = null;
        if (this.writeSiblings) {
            CyRow row = network.getRow((CyIdentifiable)edge, "USER");
            interaction = (String)row.get("shared interaction", String.class);
        } else {
            interaction = (String)network.getRow((CyIdentifiable)edge).get("interaction", String.class);
        }
        EdgesElement element = new EdgesElement(cxId, sourceId, targetId, interaction);
        return element;
    }

    private NodesElement createNodeElement(CyNode node, CyNetwork network) throws JsonProcessingException {
        Long cxId = CxUtil.getElementId((CyIdentifiable)node, network, this.useCxId);
        String attName = this.writeSiblings ? "shared name" : "name";
        String name = CxExporter.getNodeAttributeValue(network, node, attName, String.class);
        String repr = CxExporter.getNodeAttributeValue(network, node, "represents", String.class);
        return new NodesElement(cxId.longValue(), name, repr);
    }

    private void writeAspectElements(List<AspectElement> elements) throws IOException {
        AspectElement el;
        JsonElement json_el;
        JsonObject obj;
        if (elements == null || elements.isEmpty()) {
            return;
        }
        Gson gson = new Gson();
        Iterator<AspectElement> iterator = elements.iterator();
        while (iterator.hasNext() && (obj = (json_el = gson.toJsonTree((Object)(el = iterator.next()))).getAsJsonObject()).has(this.ID_STRING)) {
            Long id = obj.get(this.ID_STRING).getAsLong();
            Long max = Math.max(id, this.idCounters.getOrDefault(el.getAspectName(), 0L));
            this.idCounters.put(el.getAspectName(), max);
        }
        long t0 = System.currentTimeMillis();
        this.writer.writeAspectElements(elements);
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, elements.get(0).getAspectName(), elements.size());
        }
    }

    private final List<CySubNetwork> makeSubNetworkList(CySubNetwork subnet) {
        ArrayList<CySubNetwork> subnets = new ArrayList<CySubNetwork>();
        if (this.writeSiblings) {
            CyRootNetwork root = subnet.getRootNetwork();
            for (CySubNetwork s : root.getSubNetworkList()) {
                String name = CxUtil.getNetworkName((CyNetwork)s);
                if (name == null) continue;
                subnets.add(s);
            }
        } else {
            subnets = new ArrayList();
            subnets.add(subnet);
        }
        return subnets;
    }

    private Long getAspectSubnetworkId(CyNetwork net) {
        if (this.writeSiblings && !(net instanceof CyRootNetwork)) {
            return net.getSUID();
        }
        return null;
    }

    private Long getViewId(CyNetworkView view) {
        CyNetwork network = (CyNetwork)view.getModel();
        CyNetworkViewManager view_manager = CyServiceModule.getService(CyNetworkViewManager.class);
        if (this.writeSiblings || view_manager.getNetworkViews(network).size() > 1) {
            return view.getSUID();
        }
        return null;
    }

    private Set<CyGroup> expandGroups() {
        HashSet<CyGroup> groups = new HashSet<CyGroup>();
        for (CySubNetwork net : this.subnetworks) {
            this.group_manager.getGroupSet((CyNetwork)net).forEach(group -> {
                if (group.isCollapsed((CyNetwork)net)) {
                    groups.add((CyGroup)group);
                    group.expand((CyNetwork)net);
                }
            });
        }
        this.group_manager.getGroupSet(this.baseNetwork).forEach(group -> {
            if (group.isCollapsed(this.baseNetwork)) {
                groups.add((CyGroup)group);
                group.expand(this.baseNetwork);
            }
        });
        return groups;
    }

    private static final <T> T getNodeAttributeValue(CyNetwork network, CyNode node, String colName, Class<? extends T> type) {
        CyTable table = network.getTable(CyNode.class, "USER");
        CyColumn col = table.getColumn(colName);
        CyRow row = table.getRow((Object)node.getSUID());
        if (col != null && row != null) {
            if (col.getType() == List.class) {
                return (T)row.getList(colName, type);
            }
            return (T)row.get(colName, type);
        }
        return null;
    }

    public void setNodeColumnFilter(List<String> selectedValues) {
        if (selectedValues != null && !selectedValues.isEmpty()) {
            this.nodeColumns = selectedValues;
        }
    }

    public void setEdgeColumnFilter(List<String> selectedValues) {
        if (selectedValues != null && !selectedValues.isEmpty()) {
            this.edgeColumns = selectedValues;
        }
    }

    public void setNetworkColumnFilter(List<String> selectedValues) {
        if (selectedValues != null && !selectedValues.isEmpty()) {
            this.networkColumns = selectedValues;
        }
    }

    private CxAttributeDeclaration getAttributeDeclarations() {
        CxAttributeDeclaration result = new CxAttributeDeclaration();
        for (CySubNetwork subnet : this.subnetworks) {
            Map<String, DeclarationEntry> networkAttributes = CxExporter.getTableAttributes((CyNetwork)subnet, "network_table");
            try {
                Map<String, DeclarationEntry> nodeAttributes;
                Map<String, DeclarationEntry> edgeAttributes;
                if (!networkAttributes.isEmpty()) {
                    result.add("networkAttributes", networkAttributes);
                }
                if (!(edgeAttributes = CxExporter.getTableAttributes((CyNetwork)subnet, "edge_table")).isEmpty()) {
                    result.add("edges", edgeAttributes);
                }
                if ((nodeAttributes = CxExporter.getTableAttributes((CyNetwork)subnet, "node_table")).isEmpty()) break;
                result.add("nodes", nodeAttributes);
                break;
            }
            catch (NdexException ndexException) {
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeNetworkInCX2(Collection<String> aspects, OutputStream out) throws IOException, NdexException {
        Collection<String> outputAspects = aspects;
        if (aspects == null || aspects.isEmpty()) {
            outputAspects = AspectSet.getCx2AspectNames();
        }
        if (outputAspects.size() != AspectSet.getCx2AspectNames().size()) {
            this.omitOpaqueAspects = true;
        }
        String net_type = "subnetwork";
        String id_type = this.useCxId ? "CX IDs" : "SUIDs";
        CySubNetwork subNet = this.subnetworks.get(0);
        CyApplicationManager appManager = CyServiceModule.getService(CyApplicationManager.class);
        if (this.view == null) {
            CyNetworkView currentView = appManager.getCurrentNetworkView();
            Collection views = this._networkview_manager.getNetworkViews((CyNetwork)subNet);
            if (!views.isEmpty()) {
                CyNetworkView firstView = null;
                int counter = 0;
                for (CyNetworkView v : views) {
                    if (counter == 0) {
                        firstView = v;
                    }
                    if (v.getSUID().equals(currentView.getSUID())) {
                        this.view = v;
                        break;
                    }
                    ++counter;
                }
                if (this.view == null && firstView != null) {
                    this.view = firstView;
                }
            } else {
                this.view = null;
            }
        }
        this.logger.info("Exporting network as " + net_type + " with " + id_type);
        this.logger.info("Aspect filter: " + String.valueOf(outputAspects));
        this.logger.info("NodeCol filter: " + String.valueOf(this.nodeColumns));
        this.logger.info("EdgeCol filter: " + String.valueOf(this.edgeColumns));
        this.logger.info("NetworkCol filter: " + String.valueOf(this.networkColumns));
        CySessionManager session_manager = CyServiceModule.getService(CySessionManager.class);
        session_manager.getCurrentSession();
        CXWriter cx2Writer = new CXWriter(out, false);
        CxAttributeDeclaration attrDecls = this.getAttributeDeclarations();
        List<CxMetadata> metadata = this.getCx2Metadata(aspects, attrDecls);
        cx2Writer.writeMetadata(metadata);
        String msg = null;
        boolean success = true;
        this.collapsed_groups = this.expandGroups();
        try {
            if (!attrDecls.getDeclarations().isEmpty()) {
                cx2Writer.writeFullAspectFragment(Arrays.asList(attrDecls));
            }
            if (attrDecls.getAttributesInAspect("networkAttributes") != null) {
                this.writeCx2NetworkAttributes(cx2Writer);
            }
            this.writeCx2Nodes(cx2Writer, subNet);
            this.writeCx2Edges(cx2Writer);
            this.writeCX2VisualProperties(cx2Writer);
            this.writeTableVisualStyles(cx2Writer);
        }
        catch (Exception e) {
            e.printStackTrace();
            msg = "Failed to create cx network: " + e.getMessage();
            success = false;
        }
        finally {
            this.collapsed_groups.forEach(group -> {
                for (CyNetwork net : group.getNetworkSet()) {
                    if (!(net instanceof CySubNetwork)) continue;
                    group.collapse(net);
                }
            });
        }
        if (success) {
            cx2Writer.finish();
        } else {
            cx2Writer.printError(msg);
        }
    }
}

