/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cxio;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Paint;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.cytoscape.io.internal.CxPreferences;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cx_reader.ViewMaker;
import org.cytoscape.io.internal.cxio.CxUtil;
import org.cytoscape.io.internal.cxio.Settings;
import org.cytoscape.io.internal.nicecy.NiceCyRootNetwork;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.BooleanVisualProperty;
import org.cytoscape.view.presentation.property.DoubleVisualProperty;
import org.cytoscape.view.presentation.property.IntegerVisualProperty;
import org.cytoscape.view.presentation.property.ObjectPositionVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.ndexbio.cx2.aspect.element.core.AttributeDeclaredAspect;
import org.ndexbio.cx2.aspect.element.core.ComplexVPValue;
import org.ndexbio.cx2.aspect.element.core.CxAspectElement;
import org.ndexbio.cx2.aspect.element.core.CxAttributeDeclaration;
import org.ndexbio.cx2.aspect.element.core.CxEdge;
import org.ndexbio.cx2.aspect.element.core.CxEdgeBypass;
import org.ndexbio.cx2.aspect.element.core.CxNetworkAttribute;
import org.ndexbio.cx2.aspect.element.core.CxNode;
import org.ndexbio.cx2.aspect.element.core.CxNodeBypass;
import org.ndexbio.cx2.aspect.element.core.CxOpaqueAspectElement;
import org.ndexbio.cx2.aspect.element.core.CxVisualProperty;
import org.ndexbio.cx2.aspect.element.core.DeclarationEntry;
import org.ndexbio.cx2.aspect.element.core.MappingDefinition;
import org.ndexbio.cx2.aspect.element.core.VisualPropertyMapping;
import org.ndexbio.cx2.aspect.element.core.VisualPropertyTable;
import org.ndexbio.cx2.aspect.element.cytoscape.AbstractTableVisualProperty;
import org.ndexbio.cx2.aspect.element.cytoscape.DefaultTableType;
import org.ndexbio.cx2.aspect.element.cytoscape.VisualEditorProperties;
import org.ndexbio.cx2.converter.CX2ToCXVisualPropertyConverter;
import org.ndexbio.cx2.io.CXReader;
import org.ndexbio.cxio.aspects.datamodels.ATTRIBUTE_DATA_TYPE;
import org.ndexbio.model.exceptions.NdexException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cx2Importer {
    private static final Logger logger = LoggerFactory.getLogger((String)"CX2 Importer");
    private InputStream input;
    private CyNetwork base;
    private CxAttributeDeclaration attrDecls;
    private boolean createView;
    private CyNetworkView currentView;
    private CyTable baseNodeTable;
    private CyTable baseEdgeTable;
    private CyTable baseNetworkTable;
    private Map<Long, Long> nodeIdMap;
    private Map<Long, Long> edgeIdMap;
    private Map<Long, CxNode> cxNodes;
    private CxVisualProperty visualProperties;
    private List<CxNodeBypass> nodeBypasses;
    private List<CxEdgeBypass> edgeBypasses;
    private Map<String, Collection<CxOpaqueAspectElement>> opaqueAspects;
    private String name;
    private VisualEditorProperties editorProperties;
    private boolean hasLayout;
    private boolean nodeSizeLocked;
    private boolean arrowColorMatchesEdges;
    private String collectionName;
    private AbstractTableVisualProperty tableStyle;

    public Cx2Importer(InputStream in, boolean createView) {
        this.input = in;
        this.createView = createView;
        this.nodeIdMap = new TreeMap<Long, Long>();
        this.edgeIdMap = new TreeMap<Long, Long>();
        this.cxNodes = new TreeMap<Long, CxNode>();
        this.hasLayout = false;
        this.base = null;
        this.currentView = null;
        this.visualProperties = null;
        this.nodeBypasses = new LinkedList<CxNodeBypass>();
        this.edgeBypasses = new LinkedList<CxEdgeBypass>();
        this.opaqueAspects = new HashMap<String, Collection<CxOpaqueAspectElement>>();
        this.name = null;
        this.editorProperties = null;
        this.nodeSizeLocked = false;
        this.arrowColorMatchesEdges = false;
        this.baseNodeTable = null;
        this.baseEdgeTable = null;
        this.baseNetworkTable = null;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public CyNetwork importNetwork() throws IOException, NdexException {
        long t0 = System.currentTimeMillis();
        long nodeIdCounter = 0L;
        long edgeIdCounter = 0L;
        CXReader cxreader = new CXReader(this.input);
        CyNetworkFactory network_factory = CyServiceModule.getService(CyNetworkFactory.class);
        this.base = network_factory.createNetwork();
        block22: for (CxAspectElement elmt : cxreader) {
            switch (elmt.getAspectName()) {
                case "attributeDeclarations": {
                    this.attrDecls = (CxAttributeDeclaration)elmt;
                    if (this.attrDecls.getDeclarations().isEmpty()) continue block22;
                    this.initializeTables();
                    continue block22;
                }
                case "nodes": {
                    this.createNode((CxNode)elmt);
                    continue block22;
                }
                case "edges": {
                    CxEdge ee = (CxEdge)elmt;
                    this.createEdge(ee);
                    continue block22;
                }
                case "networkAttributes": {
                    this.createNetworkAttribute((CxNetworkAttribute)elmt);
                    continue block22;
                }
                case "visualProperties": {
                    this.visualProperties = (CxVisualProperty)elmt;
                    this.visualProperties.evaluate();
                    continue block22;
                }
                case "nodeBypasses": {
                    this.nodeBypasses.add((CxNodeBypass)elmt);
                    continue block22;
                }
                case "edgeBypasses": {
                    this.edgeBypasses.add((CxEdgeBypass)elmt);
                    continue block22;
                }
                case "visualEditorProperties": {
                    if (this.editorProperties == null) {
                        this.editorProperties = (VisualEditorProperties)elmt;
                        continue block22;
                    }
                    throw new NdexException("Only one visualEditorProperties element is allowed in a CX2 network.");
                }
                case "tableVisualProperties": {
                    if (this.tableStyle == null) {
                        this.tableStyle = (AbstractTableVisualProperty)elmt;
                        continue block22;
                    }
                    throw new NdexException("Only one tableVisualProperties element is allowed in a CX2 network.");
                }
            }
            this.addOpaqueAspectElement((CxOpaqueAspectElement)elmt);
        }
        this.serializeOpaqueAspects();
        return this.base;
    }

    private void initializeTables() {
        if (this.attrDecls.getDeclarations().isEmpty()) {
            return;
        }
        this.baseNetworkTable = this.base.getDefaultNetworkTable();
        Cx2Importer.createTableAttrs((Map)this.attrDecls.getDeclarations().get("networkAttributes"), this.baseNetworkTable, Settings.cytoscapeBuiltinTableAttributes);
        this.baseNodeTable = this.base.getDefaultNodeTable();
        Cx2Importer.createTableAttrs((Map)this.attrDecls.getDeclarations().get("nodes"), this.baseNodeTable, Settings.cytoscapeBuiltinTableAttributes);
        this.baseEdgeTable = this.base.getDefaultEdgeTable();
        Cx2Importer.createTableAttrs((Map)this.attrDecls.getDeclarations().get("edges"), this.baseEdgeTable, Settings.cytoscapeBuiltinEdgeTableAttributes);
    }

    private static void createTableAttrs(Map<String, DeclarationEntry> attrsDecls, CyTable sharedTable, Set<String> cytoscapeBuiltInAttrs) {
        if (attrsDecls != null && !attrsDecls.isEmpty()) {
            for (Map.Entry<String, DeclarationEntry> e : attrsDecls.entrySet()) {
                String attrName = e.getKey();
                if (cytoscapeBuiltInAttrs.contains(attrName)) continue;
                ATTRIBUTE_DATA_TYPE dtype = e.getValue().getDataType();
                if (dtype == null) {
                    dtype = ATTRIBUTE_DATA_TYPE.STRING;
                }
                CxUtil.createColumn(sharedTable, attrName, CxUtil.getDataType(dtype), dtype.isSingleValueType());
            }
        }
    }

    private void createNode(CxNode node) throws NdexException {
        if (!this.hasLayout && node.getX() != null) {
            this.hasLayout = true;
        }
        Map attributeDeclarations = this.attrDecls.getAttributesInAspect("nodes");
        node.extendToFullNode(attributeDeclarations);
        node.validateAttribute(attributeDeclarations, true);
        Long nodesuid = this.nodeIdMap.get(node.getId());
        if (nodesuid == null) {
            CyNode cyNode = this.createCyNodeByCXId(node.getId());
            nodesuid = cyNode.getSUID();
        }
        CyRow localRow = this.baseNodeTable.getRow((Object)nodesuid);
        for (Map.Entry e : node.getAttributes().entrySet()) {
            String attrName = (String)e.getKey();
            if (attrName.equals("SUID")) continue;
            if (this.baseNodeTable.getColumn(attrName) != null) {
                localRow.set(attrName, e.getValue());
                continue;
            }
            throw new NdexException("Node attribute " + (String)e.getKey() + " is not declared.");
        }
        this.cxNodes.put(nodesuid, node);
    }

    private CyNode createCyNodeByCXId(Long cxNodeId) {
        CyNode cyNode = this.base.addNode();
        CxUtil.saveCxId((CyIdentifiable)cyNode, this.base, cxNodeId);
        this.nodeIdMap.put(cxNodeId, cyNode.getSUID());
        return cyNode;
    }

    private void createEdge(CxEdge edge) throws NdexException {
        Map attributeDeclarations = this.attrDecls.getAttributesInAspect("edges");
        edge.extendToFullNode(attributeDeclarations);
        edge.validateAttribute(attributeDeclarations, true);
        Long srcsuid = this.nodeIdMap.get(edge.getSource());
        CyNode src = srcsuid == null ? this.createCyNodeByCXId(edge.getSource()) : this.base.getNode(srcsuid.longValue());
        Long tgtsuid = this.nodeIdMap.get(edge.getTarget());
        CyNode tgt = tgtsuid == null ? this.createCyNodeByCXId(edge.getTarget()) : this.base.getNode(tgtsuid.longValue());
        CyEdge cyEdge = this.base.addEdge(src, tgt, true);
        CxUtil.saveCxId((CyIdentifiable)cyEdge, this.base, edge.getId());
        this.edgeIdMap.put(edge.getId(), cyEdge.getSUID());
        CyRow localRow = this.baseEdgeTable.getRow((Object)cyEdge.getSUID());
        for (Map.Entry e : edge.getAttributes().entrySet()) {
            if (((String)e.getKey()).equals("SUID")) continue;
            if (this.baseEdgeTable.getColumn((String)e.getKey()) != null) {
                localRow.set((String)e.getKey(), e.getValue());
                continue;
            }
            throw new NdexException("Edge attribute " + (String)e.getKey() + " is not declared.");
        }
        if (attributeDeclarations != null && !attributeDeclarations.containsKey("shared interaction") && attributeDeclarations.containsKey("interaction")) {
            Object v = edge.getAttributes().get("interaction");
            localRow.set("shared interaction", v);
        }
    }

    private void createNetworkAttribute(CxNetworkAttribute netAttrs) throws NdexException {
        CyRow localRow = this.baseNetworkTable.getRow((Object)this.base.getSUID());
        netAttrs.extendToFullNode(this.attrDecls.getAttributesInAspect("networkAttributes"));
        netAttrs.validateAttribute(this.attrDecls.getAttributesInAspect("networkAttributes"), true);
        for (Map.Entry e : netAttrs.getAttributes().entrySet()) {
            String attrName = (String)e.getKey();
            if (attrName.equals("SUID") || attrName.equals("selected")) continue;
            if (attrName.equals("name") || attrName.equals("__Annotations")) {
                localRow.set(attrName, e.getValue());
                if (!attrName.equals("name")) continue;
                this.name = (String)e.getValue();
                continue;
            }
            if (this.baseNetworkTable.getColumn((String)e.getKey()) != null) {
                localRow.set((String)e.getKey(), e.getValue());
                continue;
            }
            throw new NdexException("Network attribute " + (String)e.getKey() + " is not declared.");
        }
    }

    private void addOpaqueAspectElement(CxOpaqueAspectElement e) {
        Collection<CxOpaqueAspectElement> aspect = this.opaqueAspects.get(e.getAspectName());
        if (aspect == null) {
            aspect = new ArrayList<CxOpaqueAspectElement>();
        }
        aspect.add(e);
    }

    private void serializeOpaqueAspects() {
        ObjectMapper mapper = new ObjectMapper();
        this.opaqueAspects.forEach((name, opaque) -> {
            if (ArrayUtils.contains((Object[])NiceCyRootNetwork.UNSERIALIZED_OPAQUE_ASPECTS, (Object)name)) {
                return;
            }
            String column = "CX_OPAQUE::" + name;
            CyTable table = this.base.getTable(CyNetwork.class, "SHARED_ATTRS");
            try {
                String aspectStr = mapper.writeValueAsString(opaque);
                CxUtil.createColumn(table, name, String.class, true);
                table.getRow((Object)this.base.getSUID()).set(column, (Object)aspectStr);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        });
    }

    public String getNetworkName() {
        return this.name;
    }

    public CyNetworkView createView() throws Exception {
        if (this.createView) {
            CyNetworkViewFactory view_factory = CyServiceModule.getService(CyNetworkViewFactory.class);
            CyNetworkViewManager view_manager = CyServiceModule.getService(CyNetworkViewManager.class);
            this.currentView = view_factory.createNetworkView(this.base);
            this.currentView.setVisualProperty(BasicVisualLexicon.NETWORK_TITLE, (Object)this.name);
            this.makeView();
            view_manager.addNetworkView(this.currentView);
        }
        if (this.tableStyle != null) {
            Map tableStyles = this.tableStyle.getStylesInTable(DefaultTableType.Network);
            if (tableStyles != null) {
                NiceCyRootNetwork.addStyleToTable(this.base.getDefaultNetworkTable(), tableStyles);
            }
            if ((tableStyles = this.tableStyle.getStylesInTable(DefaultTableType.Node)) != null) {
                NiceCyRootNetwork.addStyleToTable(this.base.getDefaultNodeTable(), tableStyles);
            }
            if ((tableStyles = this.tableStyle.getStylesInTable(DefaultTableType.Edge)) != null) {
                NiceCyRootNetwork.addStyleToTable(this.base.getDefaultEdgeTable(), tableStyles);
            }
        }
        return this.currentView;
    }

    /*
     * WARNING - void declaration
     */
    private void makeView() throws NdexException {
        SortedMap cyVPs;
        Object v;
        Long suid;
        VisualMappingManager visual_mapping_manager = CyServiceModule.getService(VisualMappingManager.class);
        VisualStyleFactory visual_style_factory = CyServiceModule.getService(VisualStyleFactory.class);
        RenderingEngineManager rendering_engine_manager = CyServiceModule.getService(RenderingEngineManager.class);
        String doLayout = this.currentView.getEdgeViews().size() < CxPreferences.getLargeLayoutThreshold() ? "force-directed" : "grid";
        boolean have_default_visual_properties = this.visualProperties != null || !this.nodeBypasses.isEmpty() || !this.edgeBypasses.isEmpty();
        VisualStyle new_visual_style = visual_mapping_manager.getDefaultVisualStyle();
        if (have_default_visual_properties) {
            void var10_14;
            String viz_style_title_base;
            VisualStyle default_visual_style = visual_mapping_manager.getDefaultVisualStyle();
            new_visual_style = visual_style_factory.createVisualStyle(default_visual_style);
            String string = viz_style_title_base = ViewMaker.createTitleForNewVisualStyle(this.name);
            for (int counter = 1; counter < 101; ++counter) {
                if (!ViewMaker.containsVisualStyle((String)var10_14, visual_mapping_manager)) continue;
                String string2 = viz_style_title_base + "-" + counter;
            }
            new_visual_style.setTitle((String)var10_14);
        }
        if (this.hasLayout) {
            for (Map.Entry<Long, CxNode> e : this.cxNodes.entrySet()) {
                CyNode node = this.base.getNode(e.getKey().longValue());
                View view = this.currentView.getNodeView(node);
                if (view == null) continue;
                CxNode n = e.getValue();
                view.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)n.getX());
                view.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)n.getY());
                if (n.getZ() == null) continue;
                view.setVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION, (Object)n.getZ());
            }
            doLayout = null;
        }
        this.nodeSizeLocked = this.editorProperties != null && this.editorProperties.getProperties().get("nodeSizeLocked") != null && this.editorProperties.getProperties().get("nodeSizeLocked").equals(Boolean.TRUE);
        this.arrowColorMatchesEdges = this.editorProperties != null && this.editorProperties.getProperties().get("arrowColorMatchesEdge") != null && this.editorProperties.getProperties().get("arrowColorMatchesEdge").equals(Boolean.TRUE);
        VisualLexicon lexicon = rendering_engine_manager.getDefaultVisualLexicon();
        boolean fitContent = this.setNetworkVPFromVisualEditorProps(lexicon, new_visual_style);
        if (this.visualProperties != null) {
            Object m;
            VisualPropertyMapping visualPropertyMapping;
            this.setNetworkVPs(lexicon, this.visualProperties.getDefaultProps().getNetworkProperties(), new_visual_style);
            this.setNodeVPs(lexicon, this.visualProperties.getDefaultProps().getNodeProperties(), new_visual_style);
            this.setEdgeVPs(lexicon, this.visualProperties.getDefaultProps().getEdgeProperties(), new_visual_style);
            Map nodeMapping = this.visualProperties.getNodeMappings();
            if (this.nodeSizeLocked && (visualPropertyMapping = (VisualPropertyMapping)nodeMapping.remove("NODE_WIDTH")) != null) {
                nodeMapping.put("NODE_SIZE", visualPropertyMapping);
            }
            this.setMapping(CyNode.class, nodeMapping, lexicon, new_visual_style);
            Map map = this.visualProperties.getEdgeMappings();
            if (this.arrowColorMatchesEdges && (m = (VisualPropertyMapping)map.remove("EDGE_LINE_COLOR")) != null) {
                map.put(BasicVisualLexicon.EDGE_UNSELECTED_PAINT.getIdString(), m);
            }
            this.setMapping(CyEdge.class, map, lexicon, new_visual_style);
            if (this.editorProperties != null) {
                block4: for (Map.Entry entry : this.editorProperties.getProperties().entrySet()) {
                    String vpName = (String)entry.getKey();
                    if (vpName.startsWith("NETWORK_")) {
                        Object cyVPValue;
                        VisualProperty vp = lexicon.lookup(CyNetwork.class, vpName);
                        if (vp == null || (cyVPValue = Cx2Importer.getCyVPValueFromCX2VPValue(vp, entry.getValue())) == null) continue;
                        new_visual_style.setDefaultValue(vp, cyVPValue);
                        continue;
                    }
                    for (VisualPropertyDependency d : new_visual_style.getAllVisualPropertyDependencies()) {
                        if (!d.getIdString().equals(vpName)) continue;
                        try {
                            d.setDependency(((Boolean)entry.getValue()).booleanValue());
                            continue block4;
                        }
                        catch (Exception ex) {
                            throw new NdexException("could not parse boolean from '" + vpName + "'");
                        }
                    }
                }
            }
        }
        for (CxNodeBypass cxNodeBypass : this.nodeBypasses) {
            suid = this.nodeIdMap.get(cxNodeBypass.getId());
            CyNode cyNode = this.base.getNode(suid.longValue());
            VisualPropertyTable vps = cxNodeBypass.getVisualProperties();
            View nv = this.currentView.getNodeView(cyNode);
            if (this.nodeSizeLocked && (v = vps.get("NODE_WIDTH")) != null) {
                vps.getVisualProperties().put("NODE_SIZE", v);
            }
            cyVPs = CX2ToCXVisualPropertyConverter.getInstance().convertEdgeOrNodeVPs(vps);
            ViewMaker.setVisualProperties(lexicon, cyVPs, nv, CyNode.class);
        }
        for (CxEdgeBypass cxEdgeBypass : this.edgeBypasses) {
            suid = this.edgeIdMap.get(cxEdgeBypass.getId());
            CyEdge cyEdge = this.base.getEdge(suid.longValue());
            View ev = this.currentView.getEdgeView(cyEdge);
            VisualPropertyTable vps = cxEdgeBypass.getVisualProperties();
            if (this.arrowColorMatchesEdges && (v = vps.get("EDGE_LINE_COLOR")) != null) {
                vps.getVisualProperties().put(BasicVisualLexicon.EDGE_PAINT.getIdString(), v);
            }
            cyVPs = CX2ToCXVisualPropertyConverter.getInstance().convertEdgeOrNodeVPs(vps);
            ViewMaker.setVisualProperties(lexicon, cyVPs, ev, CyEdge.class);
        }
        if (have_default_visual_properties) {
            visual_mapping_manager.addVisualStyle(new_visual_style);
            visual_mapping_manager.setVisualStyle(new_visual_style, this.currentView);
        }
        ViewMaker.applyStyle(new_visual_style, this.currentView, doLayout, fitContent);
    }

    private boolean setNetworkVPFromVisualEditorProps(VisualLexicon lexicon, VisualStyle style) throws NdexException {
        if (this.editorProperties == null) {
            return false;
        }
        int count = 0;
        Map defaults = this.editorProperties.getProperties();
        if (defaults != null) {
            String[] desiredKeys;
            for (String key : desiredKeys = new String[]{"NETWORK_CENTER_X_LOCATION", "NETWORK_CENTER_Y_LOCATION", "NETWORK_SCALE_FACTOR"}) {
                VisualProperty vp;
                Object cyVPValue;
                if (!defaults.containsKey(key) || (cyVPValue = Cx2Importer.getCyVPValueFromCX2VPValue(vp = lexicon.lookup(CyNetwork.class, key), defaults.get(key))) == null) continue;
                style.setDefaultValue(vp, cyVPValue);
                ++count;
            }
        }
        return count != 3;
    }

    private void setNetworkVPs(VisualLexicon lexicon, Map<String, Object> defaults, VisualStyle style) throws NdexException {
        if (defaults != null) {
            for (Map.Entry<String, Object> entry : defaults.entrySet()) {
                Object cyVPValue;
                VisualProperty vp;
                String cyVPName = CX2ToCXVisualPropertyConverter.getInstance().getCx1NetworkPropertyName(entry.getKey());
                if (cyVPName == null || (vp = lexicon.lookup(CyNetwork.class, cyVPName)) == null || (cyVPValue = Cx2Importer.getCyVPValueFromCX2VPValue(vp, entry.getValue())) == null) continue;
                style.setDefaultValue(vp, cyVPValue);
            }
        }
    }

    private void setNodeVPs(VisualLexicon lexicon, VisualPropertyTable defaults, VisualStyle style) throws NdexException {
        if (defaults != null) {
            SortedMap cyVPTable = CX2ToCXVisualPropertyConverter.getInstance().convertEdgeOrNodeVPs(defaults);
            for (Map.Entry entry : cyVPTable.entrySet()) {
                Object cyVPValue;
                VisualProperty vp = lexicon.lookup(CyNode.class, (String)entry.getKey());
                if (vp == null || (cyVPValue = vp.parseSerializableString((String)entry.getValue())) == null) continue;
                style.setDefaultValue(vp, cyVPValue);
            }
            if (this.nodeSizeLocked) {
                VisualProperty vp = BasicVisualLexicon.NODE_SIZE;
                Object v = defaults.get("NODE_WIDTH");
                if (v != null) {
                    Object cyVPValue = Cx2Importer.getCyVPValueFromCX2VPValue(vp, v);
                    style.setDefaultValue(vp, (Object)((Double)cyVPValue));
                }
            }
        }
    }

    private void setEdgeVPs(VisualLexicon lexicon, VisualPropertyTable defaults, VisualStyle style) throws NdexException {
        if (defaults != null) {
            SortedMap cyVPTable = CX2ToCXVisualPropertyConverter.getInstance().convertEdgeOrNodeVPs(defaults);
            for (Map.Entry entry : cyVPTable.entrySet()) {
                Object cyVPValue;
                VisualProperty vp = lexicon.lookup(CyEdge.class, (String)entry.getKey());
                if (vp == null || (cyVPValue = vp.parseSerializableString((String)entry.getValue())) == null) continue;
                style.setDefaultValue(vp, cyVPValue);
            }
            if (this.arrowColorMatchesEdges) {
                VisualProperty vp = BasicVisualLexicon.EDGE_UNSELECTED_PAINT;
                Object v = defaults.get("EDGE_LINE_COLOR");
                if (v != null) {
                    Paint cyVPValue = (Paint)Cx2Importer.getCyVPValueFromCX2VPValue(vp, v);
                    style.setDefaultValue(vp, (Object)cyVPValue);
                }
            }
        }
    }

    private void setDefaultVisualPropertiesAndMappings(VisualLexicon lexicon, VisualPropertyTable defaults, Map<String, VisualPropertyMapping> mappings, VisualStyle style, Class my_class) throws NdexException {
        if (defaults != null) {
            for (Map.Entry entry : defaults.getVisualProperties().entrySet()) {
                Object cyVPValue;
                VisualProperty vp = lexicon.lookup(my_class, (String)entry.getKey());
                if (vp == null || (cyVPValue = Cx2Importer.getCyVPValueFromCX2VPValue(vp, entry.getValue())) == null) continue;
                style.setDefaultValue(vp, cyVPValue);
            }
        }
    }

    public static <T> T getCyVPValueFromCX2VPValue(VisualProperty<T> vp, Object cx2Value) throws NdexException {
        if (vp instanceof ObjectPositionVisualProperty) {
            String sv = ((ComplexVPValue)cx2Value).toCX1String();
            return (T)vp.parseSerializableString(sv);
        }
        if (vp.getIdString().startsWith("NODE_CUSTOMGRAPHICS_SIZE_", 0)) {
            return null;
        }
        if (cx2Value instanceof String) {
            return (T)vp.parseSerializableString((String)cx2Value);
        }
        if (vp instanceof DoubleVisualProperty) {
            return (T)Double.valueOf(((Number)cx2Value).doubleValue());
        }
        if (vp instanceof BooleanVisualProperty) {
            return (T)cx2Value;
        }
        if (vp instanceof IntegerVisualProperty) {
            return (T)Integer.valueOf(((Number)cx2Value).intValue());
        }
        return null;
    }

    private static VisualProperty getCyVPFromCX2VPName(Class myClass, VisualLexicon lexicon, String cx2Name) {
        String cx1Name = CX2ToCXVisualPropertyConverter.getInstance().getCx1EdgeOrNodeProperty(cx2Name);
        if (cx1Name != null) {
            return lexicon.lookup(myClass, cx1Name);
        }
        return lexicon.lookup(myClass, cx2Name);
    }

    private void setMapping(Class myClass, Map<String, VisualPropertyMapping> mappings, VisualLexicon lexicon, VisualStyle style) throws NdexException {
        for (Map.Entry<String, VisualPropertyMapping> mapping : mappings.entrySet()) {
            String cx2VpName = mapping.getKey();
            VisualProperty vp = Cx2Importer.getCyVPFromCX2VPName(myClass, lexicon, cx2VpName);
            if (vp == null) continue;
            MappingDefinition defination = mapping.getValue().getMappingDef();
            String attrName = defination.getAttributeName();
            switch (mapping.getValue().getType()) {
                case PASSTHROUGH: {
                    ATTRIBUTE_DATA_TYPE dtype = this.getAttrDataType(myClass, attrName);
                    if (dtype == null) {
                        dtype = defination.getAttributeType();
                    }
                    ViewMaker.addPasstroughMapping(style, vp, attrName, CxUtil.getDataType(dtype));
                    break;
                }
                case DISCRETE: {
                    this.addDiscreteMapping(myClass, lexicon, defination, style, vp, cx2VpName);
                    break;
                }
                case CONTINUOUS: {
                    this.addContinuousMapping(myClass, lexicon, defination, style, vp, cx2VpName);
                    break;
                }
            }
        }
    }

    private void addDiscreteMapping(Class<?> typeClass, VisualLexicon lexicon, MappingDefinition def, VisualStyle style, VisualProperty vp, String cx2VpName) throws NdexException {
        String colName = def.getAttributeName();
        ATTRIBUTE_DATA_TYPE dtype = this.getAttrDataType(typeClass, colName);
        if (dtype == null) {
            dtype = def.getAttributeType();
        }
        DiscreteMapping dmf = (DiscreteMapping)ViewMaker.vmf_factory_d.createVisualMappingFunction(colName, CxUtil.getDataType(dtype), vp);
        for (Map mappingEntry : def.getMapppingList()) {
            ATTRIBUTE_DATA_TYPE elmtDType = dtype.isSingleValueType() ? dtype : dtype.elementType();
            Object v = AttributeDeclaredAspect.processAttributeValue((ATTRIBUTE_DATA_TYPE)elmtDType, mappingEntry.get("v"));
            try {
                String cyValue = CX2ToCXVisualPropertyConverter.getInstance().getCx1EdgeOrNodePropertyValue(cx2VpName, mappingEntry.get("vp"));
                dmf.putMapValue(v, vp.parseSerializableString(cyValue));
            }
            catch (IllegalArgumentException e) {
                throw new NdexException("Failed to parse value for mapping " + colName + " on " + cx2VpName + " : " + e.getMessage());
            }
        }
        style.addVisualMappingFunction((VisualMappingFunction)dmf);
    }

    private void addContinuousMapping(Class<?> typeClass, VisualLexicon lexicon, MappingDefinition def, VisualStyle style, VisualProperty vp, String cx2VpName) throws NdexException {
        String colName = def.getAttributeName();
        ATTRIBUTE_DATA_TYPE dtype = this.getAttrDataType(typeClass, colName);
        if (dtype == null) {
            dtype = def.getAttributeType();
        }
        ContinuousMapping cmf = (ContinuousMapping)ViewMaker.vmf_factory_c.createVisualMappingFunction(colName, CxUtil.getDataType(dtype), vp);
        int counter = 0;
        Object L = null;
        Object E = null;
        Object G = null;
        Object ov = null;
        CX2ToCXVisualPropertyConverter vpCvtr = CX2ToCXVisualPropertyConverter.getInstance();
        for (Map m : def.getMapppingList()) {
            Object minV = m.get("min");
            Object maxV = m.get("max");
            Boolean includeMin = (Boolean)m.get("includeMin");
            Boolean includeMax = (Boolean)m.get("includeMax");
            Object minVP = m.get("minVPValue");
            Object maxVP = m.get("maxVPValue");
            if (minVP == null && maxVP == null) {
                throw new NdexException("minVPValue and maxVPValue are both missing in CONTINUOUS mapping of " + cx2VpName + " on column " + colName);
            }
            if (counter == 0) {
                if (minV != null) {
                    ov = AttributeDeclaredAspect.processAttributeValue((ATTRIBUTE_DATA_TYPE)dtype, minV);
                    E = L = vp.parseSerializableString(vpCvtr.getCx1EdgeOrNodePropertyValue(cx2VpName, minVP));
                    G = L;
                    point = new BoundaryRangeValues(L, E, G);
                    cmf.addPoint(Cx2Importer.cvtValueForContinuousMapping(ov), point);
                    ov = AttributeDeclaredAspect.processAttributeValue((ATTRIBUTE_DATA_TYPE)dtype, maxV);
                    E = L = vp.parseSerializableString(vpCvtr.getCx1EdgeOrNodePropertyValue(cx2VpName, maxVP));
                    G = L;
                    point = new BoundaryRangeValues(L, E, G);
                    cmf.addPoint(Cx2Importer.cvtValueForContinuousMapping(ov), point);
                }
                L = vp.parseSerializableString(vpCvtr.getCx1EdgeOrNodePropertyValue(cx2VpName, maxVP));
                ov = AttributeDeclaredAspect.processAttributeValue((ATTRIBUTE_DATA_TYPE)dtype, maxV);
                if (includeMax.booleanValue()) {
                    E = L;
                }
            } else {
                G = vp.parseSerializableString(vpCvtr.getCx1EdgeOrNodePropertyValue(cx2VpName, minVP));
                if (includeMin.booleanValue()) {
                    E = G;
                }
                point = new BoundaryRangeValues(L, E, G);
                cmf.addPoint(Cx2Importer.cvtValueForContinuousMapping(ov), point);
                if (maxV != null) {
                    ov = AttributeDeclaredAspect.processAttributeValue((ATTRIBUTE_DATA_TYPE)dtype, maxV);
                    L = vp.parseSerializableString(vpCvtr.getCx1EdgeOrNodePropertyValue(cx2VpName, maxVP));
                    E = includeMax != false ? L : null;
                }
            }
            ++counter;
        }
        style.addVisualMappingFunction((VisualMappingFunction)cmf);
    }

    private static Object cvtValueForContinuousMapping(Object v) {
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        return v;
    }

    private ATTRIBUTE_DATA_TYPE getAttrDataType(Class<?> typeClass, String attrName) throws NdexException {
        DeclarationEntry d;
        Map decls = null;
        decls = typeClass.equals(CyNode.class) ? this.attrDecls.getAttributesInAspect("nodes") : (typeClass.equals(CyEdge.class) ? this.attrDecls.getAttributesInAspect("edges") : this.attrDecls.getAttributesInAspect("networkAttributes"));
        if (decls != null && (d = (DeclarationEntry)decls.get(attrName)) != null) {
            return d.getDataType();
        }
        return null;
    }
}

