/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_writer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cxio.CxUtil;
import org.cytoscape.io.internal.cxio.VisualPropertyType;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.TaskMonitor;
import org.ndexbio.cx2.aspect.element.core.CxEdgeBypass;
import org.ndexbio.cx2.aspect.element.core.CxNodeBypass;
import org.ndexbio.cx2.aspect.element.core.MappingDefinition;
import org.ndexbio.cx2.aspect.element.core.VPMappingType;
import org.ndexbio.cx2.aspect.element.core.VisualPropertyMapping;
import org.ndexbio.cx2.aspect.element.core.VisualPropertyTable;
import org.ndexbio.cx2.aspect.element.cytoscape.VisualEditorProperties;
import org.ndexbio.cx2.converter.CXToCX2VisualPropertyConverter;
import org.ndexbio.cxio.aspects.datamodels.ATTRIBUTE_DATA_TYPE;
import org.ndexbio.cxio.aspects.datamodels.CyVisualPropertiesElement;
import org.ndexbio.cxio.core.interfaces.AspectElement;
import org.ndexbio.cxio.util.CxioUtil;
import org.ndexbio.model.exceptions.NdexException;

public final class VisualPropertiesGatherer {
    private static final Logger logger = Logger.getLogger((String)"VisualPropertiesGatherer");
    private static final Set<String> ignoredProperties = new HashSet<String>(Arrays.asList("NODE", "EDGE", "NETWORK", "NODE_CUSTOMPAINT_1", "NODE_CUSTOMPAINT_2", "NODE_CUSTOMPAINT_3", "NODE_CUSTOMPAINT_4", "NODE_CUSTOMPAINT_5", "NODE_CUSTOMPAINT_6", "NODE_CUSTOMPAINT_7", "NODE_CUSTOMPAINT_8", "NODE_CUSTOMPAINT_9"));
    public static final char COMMA = ',';

    public static final List<AspectElement> gatherVisualPropertiesAsAspectElements(CyNetworkView view, VisualLexicon lexicon, Set<VisualPropertyType> types, Long viewId, boolean use_cxId, TaskMonitor taskMonitor) throws JsonProcessingException {
        ArrayList<AspectElement> elements = new ArrayList<AspectElement>();
        VisualMappingManager vmm = CyServiceModule.getService(VisualMappingManager.class);
        VisualStyle current_visual_style = vmm.getVisualStyle(view);
        if (lexicon == null) {
            throw new IllegalArgumentException("VisualLexicon is not initialized. This should not happen");
        }
        Set all_visual_properties = lexicon.getAllVisualProperties();
        if (current_visual_style == null) {
            throw new IllegalArgumentException("Failed to get Visual Style from view " + String.valueOf(view));
        }
        if (types.contains((Object)VisualPropertyType.NETWORK)) {
            VisualPropertiesGatherer.gatherNetworkVisualProperties(view, elements, current_visual_style, all_visual_properties, viewId);
        }
        if (types.contains((Object)VisualPropertyType.NODES_DEFAULT)) {
            VisualPropertiesGatherer.gatherNodesDefaultVisualProperties(view, elements, current_visual_style, all_visual_properties, viewId, taskMonitor);
        }
        if (types.contains((Object)VisualPropertyType.EDGES_DEFAULT)) {
            VisualPropertiesGatherer.gatherEdgesDefaultVisualProperties(view, elements, current_visual_style, all_visual_properties, viewId, taskMonitor);
        }
        if (types.contains((Object)VisualPropertyType.NODES)) {
            VisualPropertiesGatherer.gatherNodeVisualProperties(view, elements, all_visual_properties, viewId, use_cxId);
        }
        if (types.contains((Object)VisualPropertyType.EDGES)) {
            VisualPropertiesGatherer.gatherEdgeVisualProperties(view, elements, all_visual_properties, viewId, use_cxId);
        }
        return elements;
    }

    private static final <T> void addProperties(View<? extends CyIdentifiable> view, VisualProperty<T> vp, CyVisualPropertiesElement cvp) {
        if (!view.isSet(vp) || !view.isValueLocked(vp)) {
            return;
        }
        try {
            String value_str = VisualPropertiesGatherer.getSerializableVisualProperty(view, vp);
            if (CxioUtil.isEmpty((String)value_str)) {
                return;
            }
            String id_string = vp.getIdString();
            if (ignoredProperties.contains(id_string)) {
                logger.info((Object)("Need to add handler for Property: " + id_string + " " + value_str));
            } else {
                cvp.putProperty(id_string, value_str);
            }
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Writing %s(%s) = %s caused Error:\n%s", vp.getDisplayName(), vp.getTargetDataType(), view.getVisualProperty(vp), e.getMessage());
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> String getSerializableVisualProperty(View<? extends CyIdentifiable> view, VisualProperty<T> vp) {
        Object prop = view.getVisualProperty(vp);
        if (prop == null) {
            return null;
        }
        String val = null;
        try {
            val = vp.toSerializableString(prop);
        }
        catch (ClassCastException e) {
            val = String.valueOf(prop);
            String message = String.format("Class cast exception for %s: %s(%s) = %s. Error: %s\n", vp.getClass(), vp.getDisplayName(), vp.getTargetDataType(), view.getVisualProperty(vp), e.getMessage());
            logger.info((Object)message);
        }
        return val;
    }

    private static final <T> void addPropertiesNetwork(View<? extends CyIdentifiable> view, VisualStyle style, VisualProperty<T> vp, CyVisualPropertiesElement cvp) {
        String value_str = VisualPropertiesGatherer.getSerializableVisualProperty(view, vp);
        if (CxioUtil.isEmpty((String)value_str)) {
            return;
        }
        String id_string = vp.getIdString();
        if (view.isSet(vp) && view.isValueLocked(vp)) {
            if (ignoredProperties.contains(id_string)) {
                throw new RuntimeException("Failed to add property " + String.valueOf(vp));
            }
            cvp.putProperty(id_string, value_str);
        } else if (!ignoredProperties.contains(id_string)) {
            cvp.putProperty(id_string, value_str);
        }
    }

    private static final <T> void addDefaultProperties(VisualStyle style, VisualProperty<T> vp, CyVisualPropertiesElement cvp) {
        String id_string;
        String value_str;
        Object vp_value = style.getDefaultValue(vp);
        if (vp_value != null && !CxioUtil.isEmpty((String)(value_str = vp.toSerializableString(vp_value))) && !ignoredProperties.contains(id_string = vp.getIdString())) {
            cvp.putProperty(id_string, value_str);
        }
    }

    public static final <T> String getDefaultPropertyAsString(VisualStyle style, VisualProperty<T> vp) {
        String value_str;
        String id_string = vp.getIdString();
        if (ignoredProperties.contains(id_string)) {
            return null;
        }
        Object vp_value = style.getDefaultValue(vp);
        if (vp_value != null && !CxioUtil.isEmpty((String)(value_str = vp.toSerializableString(vp_value)))) {
            return value_str;
        }
        return null;
    }

    private static String escapeString(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (curChar == ',') {
                result.append(',');
            }
            result.append(curChar);
        }
        return result.toString();
    }

    private static final <T> void addMappings(VisualStyle style, VisualProperty<T> vp, CyVisualPropertiesElement cvp, CyTable table, TaskMonitor taskMonitor) {
        VisualMappingFunction mapping = style.getVisualMappingFunction(vp);
        if (mapping == null) {
            return;
        }
        String col = mapping.getMappingColumnName();
        if (mapping instanceof PassthroughMapping) {
            PassthroughMapping pm = (PassthroughMapping)mapping;
            String type = null;
            try {
                type = VisualPropertiesGatherer.toAttributeType(pm.getMappingColumnType(), table, col);
            }
            catch (IOException e) {
                logger.info((Object)("WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding passthrough mapping. " + e.getMessage()));
                return;
            }
            if (!CxUtil.dataTypeIsValid(vp, type)) {
                if (taskMonitor != null) {
                    taskMonitor.showMessage(TaskMonitor.Level.WARN, "Pass through mapping for " + vp.getIdString() + " on column '" + col + "' is not valid. Ignoring it.");
                }
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("COL");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(col));
            sb.append(",");
            sb.append("T");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(type));
            cvp.putMapping(vp.getIdString(), "PASSTHROUGH", sb.toString());
        } else if (mapping instanceof DiscreteMapping) {
            DiscreteMapping dm = (DiscreteMapping)mapping;
            String type = null;
            try {
                type = VisualPropertiesGatherer.toAttributeType(dm.getMappingColumnType(), table, col);
            }
            catch (IOException e) {
                logger.info((Object)("WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding discrete mapping. " + e.getMessage()));
                return;
            }
            Map map = dm.getAll();
            StringBuilder sb = new StringBuilder();
            sb.append("COL");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(col));
            sb.append(",");
            sb.append("T");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(type));
            int counter = 0;
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                try {
                    sb.append(",K=");
                    sb.append(counter);
                    sb.append("=");
                    sb.append(VisualPropertiesGatherer.escapeString(entry.getKey().toString()));
                    sb.append(",V=");
                    sb.append(counter);
                    sb.append("=");
                    sb.append(VisualPropertiesGatherer.escapeString(vp.toSerializableString(value)));
                }
                catch (Exception e) {
                    logger.info((Object)("could not add discrete mapping entry: " + String.valueOf(value)));
                    e.printStackTrace();
                    return;
                }
                ++counter;
            }
            cvp.putMapping(vp.getIdString(), "DISCRETE", sb.toString());
        } else if (mapping instanceof ContinuousMapping) {
            ContinuousMapping cm = (ContinuousMapping)mapping;
            String type = null;
            try {
                type = VisualPropertiesGatherer.toAttributeType(cm.getMappingColumnType(), table, col);
            }
            catch (IOException e) {
                logger.info((Object)("WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding continuous mapping." + e.getMessage()));
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("COL");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(col));
            sb.append(",");
            sb.append("T");
            sb.append("=");
            sb.append(VisualPropertiesGatherer.escapeString(type));
            int counter = 0;
            for (ContinuousMappingPoint cp : cm.getAllPoints()) {
                Object lesser = cp.getRange().lesserValue;
                Object equal = cp.getRange().equalValue;
                Object greater = cp.getRange().greaterValue;
                sb.append(",L=");
                sb.append(counter);
                sb.append("=");
                sb.append(VisualPropertiesGatherer.escapeString(vp.toSerializableString(lesser)));
                sb.append(",E=");
                sb.append(counter);
                sb.append("=");
                sb.append(VisualPropertiesGatherer.escapeString(vp.toSerializableString(equal)));
                sb.append(",G=");
                sb.append(counter);
                sb.append("=");
                sb.append(VisualPropertiesGatherer.escapeString(vp.toSerializableString(greater)));
                sb.append(",OV=");
                sb.append(counter);
                sb.append("=");
                sb.append(VisualPropertiesGatherer.escapeString(cp.getValue().toString()));
                ++counter;
            }
            cvp.putMapping(vp.getIdString(), "CONTINUOUS", sb.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> VisualPropertyMapping getCX2Mapping(VisualStyle style, VisualProperty<T> vp, CyTable table, TaskMonitor taskMonitor) throws NdexException {
        VisualMappingFunction mapping = style.getVisualMappingFunction(vp);
        if (mapping == null) {
            return null;
        }
        String col = mapping.getMappingColumnName();
        String vpName = vp.getIdString();
        String catVPStr = vpName.equals("NODE_SIZE") ? "NODE_HEIGHT" : (vpName.equals("EDGE_UNSELECTED_PAINT") ? "EDGE_STROKE_UNSELECTED_PAINT" : vpName);
        VisualPropertyMapping cx2Mapping = new VisualPropertyMapping();
        MappingDefinition def = new MappingDefinition(col);
        cx2Mapping.setMappingDef(def);
        CXToCX2VisualPropertyConverter cvtr = CXToCX2VisualPropertyConverter.getInstance();
        if (mapping instanceof PassthroughMapping) {
            cx2Mapping.setType(VPMappingType.PASSTHROUGH);
            PassthroughMapping pm = (PassthroughMapping)mapping;
            String type = null;
            try {
                type = VisualPropertiesGatherer.toAttributeType(pm.getMappingColumnType(), table, col);
                if (type == null) return cx2Mapping;
                if (CxUtil.dataTypeIsValid(vp, type)) {
                    def.setAttributeType(ATTRIBUTE_DATA_TYPE.fromCxLabel((String)type));
                    return cx2Mapping;
                }
                if (taskMonitor == null) return null;
                taskMonitor.showMessage(TaskMonitor.Level.WARN, "Pass through mapping for " + vp.getIdString() + " on column '" + col + "' is not valid. Ignoring it.");
                return null;
            }
            catch (IOException e) {
                if (taskMonitor == null) return null;
                taskMonitor.showMessage(TaskMonitor.Level.WARN, "WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding passthrough mapping. " + e.getMessage());
                return null;
            }
        }
        if (mapping instanceof DiscreteMapping) {
            cx2Mapping.setType(VPMappingType.DISCRETE);
            DiscreteMapping dm = (DiscreteMapping)mapping;
            String type = null;
            try {
                type = VisualPropertiesGatherer.toAttributeType(dm.getMappingColumnType(), table, col);
                if (type != null) {
                    def.setAttributeType(ATTRIBUTE_DATA_TYPE.fromCxLabel((String)type));
                }
            }
            catch (IOException e) {
                logger.info((Object)("WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding discrete mapping. " + e.getMessage()));
                return null;
            }
            Map map = dm.getAll();
            ArrayList mappingList = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                HashMap<String, Object> mapEntry = new HashMap<String, Object>();
                Object newVP = cvtr.getNewEdgeOrNodePropertyValue(catVPStr, vp.toSerializableString(value));
                if (newVP == null) continue;
                mapEntry.put("v", entry.getKey());
                mapEntry.put("vp", newVP);
                mappingList.add(mapEntry);
            }
            if (mappingList.isEmpty()) return cx2Mapping;
            def.setMapppingList(mappingList);
            return cx2Mapping;
        }
        if (!(mapping instanceof ContinuousMapping)) throw new NdexException("Mapping type on column " + col + " is not supported by CX2.");
        cx2Mapping.setType(VPMappingType.CONTINUOUS);
        ContinuousMapping cm = (ContinuousMapping)mapping;
        String type = null;
        try {
            type = VisualPropertiesGatherer.toAttributeType(cm.getMappingColumnType(), table, col);
            if (type != null) {
                def.setAttributeType(ATTRIBUTE_DATA_TYPE.fromCxLabel((String)type));
            }
        }
        catch (IOException e) {
            logger.info((Object)("WARNING: problem with mapping/column '" + col + "': column not present, ignoring corresponding continuous mapping." + e.getMessage()));
            return null;
        }
        ArrayList m = new ArrayList();
        Object min = null;
        Boolean includeMin = null;
        Object minVP = null;
        int counter = 0;
        HashMap<String, Object> currentMapping = new HashMap<String, Object>();
        for (ContinuousMappingPoint cp : cm.getAllPoints()) {
            Object L = cp.getRange().lesserValue;
            Object LO = cvtr.getNewEdgeOrNodePropertyValue(catVPStr, vp.toSerializableString(L));
            Object E = cp.getRange().equalValue;
            Object G = cp.getRange().greaterValue;
            if (G == null) break;
            Object GO = cvtr.getNewEdgeOrNodePropertyValue(catVPStr, vp.toSerializableString(G));
            Object OV = cp.getValue();
            Object OVO = cp.getValue();
            if (counter == 0) {
                currentMapping.put("includeMin", Boolean.FALSE);
                currentMapping.put("includeMax", E.equals(L));
                currentMapping.put("maxVPValue", LO);
                currentMapping.put("max", OVO);
                m.add(currentMapping);
            } else {
                currentMapping.put("includeMin", includeMin);
                currentMapping.put("includeMax", E.equals(L));
                currentMapping.put("minVPValue", minVP);
                currentMapping.put("min", min);
                currentMapping.put("maxVPValue", LO);
                currentMapping.put("max", OVO);
                m.add(currentMapping);
            }
            includeMin = E.equals(G);
            min = OVO;
            minVP = GO;
            currentMapping = new HashMap();
            ++counter;
        }
        currentMapping.put("includeMin", includeMin);
        currentMapping.put("includeMax", Boolean.FALSE);
        currentMapping.put("minVPValue", minVP);
        currentMapping.put("min", min);
        m.add(currentMapping);
        if (m.isEmpty()) return cx2Mapping;
        def.setMapppingList(m);
        return cx2Mapping;
    }

    private static void gatherEdgesDefaultVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, VisualStyle current_visual_style, Set<VisualProperty<?>> all_visual_properties, Long viewId, TaskMonitor taskMonitor) {
        CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.EDGES_DEFAULT.asString(), viewId, viewId);
        for (VisualProperty<?> visual_property : all_visual_properties) {
            if (visual_property.getTargetDataType() != CyEdge.class) continue;
            VisualPropertiesGatherer.addDefaultProperties(current_visual_style, visual_property, e);
            CyTable table = ((CyNetwork)view.getModel()).getTable(CyEdge.class, "USER");
            VisualPropertiesGatherer.addMappings(current_visual_style, visual_property, e, table, taskMonitor);
        }
        VisualPropertiesGatherer.addDependency("arrowColorMatchesEdge", current_visual_style, e);
        visual_properties.add((AspectElement)e);
    }

    private static void gatherEdgeVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, Set<VisualProperty<?>> all_visual_properties, Long viewId, boolean use_cxId) throws JsonProcessingException {
        for (View edge_view : view.getEdgeViews()) {
            CyEdge edge = (CyEdge)edge_view.getModel();
            CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.EDGES.asString(), CxUtil.getElementId((CyIdentifiable)edge, (CyNetwork)((CySubNetwork)view.getModel()), use_cxId), viewId);
            for (VisualProperty<?> visual_property : all_visual_properties) {
                if (visual_property.getTargetDataType() != CyEdge.class) continue;
                VisualPropertiesGatherer.addProperties((View<? extends CyIdentifiable>)edge_view, visual_property, e);
            }
            if (e.getProperties() == null || e.getProperties().isEmpty()) continue;
            visual_properties.add((AspectElement)e);
        }
    }

    private static void gatherNetworkVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, VisualStyle current_visual_style, Set<VisualProperty<?>> all_visual_properties, Long viewId) {
        CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.NETWORK.asString(), viewId, viewId);
        for (VisualProperty<?> visual_property : all_visual_properties) {
            if (visual_property.getTargetDataType() != CyNetwork.class) continue;
            VisualPropertiesGatherer.addPropertiesNetwork((View<? extends CyIdentifiable>)view, current_visual_style, visual_property, e);
        }
        visual_properties.add((AspectElement)e);
    }

    private static void gatherNodesDefaultVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, VisualStyle current_visual_style, Set<VisualProperty<?>> all_visual_properties, Long viewId, TaskMonitor taskMonitor) {
        CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.NODES_DEFAULT.asString(), viewId, viewId);
        for (VisualProperty<?> visual_property : all_visual_properties) {
            if (visual_property.getTargetDataType() != CyNode.class) continue;
            VisualPropertiesGatherer.addDefaultProperties(current_visual_style, visual_property, e);
            CyTable table = ((CyNetwork)view.getModel()).getTable(CyNode.class, "USER");
            VisualPropertiesGatherer.addMappings(current_visual_style, visual_property, e, table, taskMonitor);
        }
        VisualPropertiesGatherer.addDependency("nodeCustomGraphicsSizeSync", current_visual_style, e);
        VisualPropertiesGatherer.addDependency("nodeSizeLocked", current_visual_style, e);
        visual_properties.add((AspectElement)e);
    }

    private static final void addDependency(String id_string, VisualStyle style, CyVisualPropertiesElement vpe) {
        for (VisualPropertyDependency d : style.getAllVisualPropertyDependencies()) {
            if (!d.getIdString().equals(id_string)) continue;
            vpe.putDependency(id_string, String.valueOf(d.isDependencyEnabled()));
            return;
        }
    }

    public static void addCx2EditorPropsDependency(String id_string, VisualStyle style, VisualEditorProperties props) {
        for (VisualPropertyDependency d : style.getAllVisualPropertyDependencies()) {
            if (!d.getIdString().equals(id_string)) continue;
            props.getProperties().put(id_string, d.isDependencyEnabled());
        }
    }

    private static void gatherNodeVisualProperties(CyNetworkView view, List<AspectElement> visual_properties, Set<VisualProperty<?>> all_visual_properties, Long viewId, boolean use_cxId) {
        for (View node_view : view.getNodeViews()) {
            CyNode cy_node = (CyNode)node_view.getModel();
            CyVisualPropertiesElement e = new CyVisualPropertiesElement(VisualPropertyType.NODES.asString(), CxUtil.getElementId((CyIdentifiable)cy_node, (CyNetwork)view.getModel(), use_cxId), viewId);
            for (VisualProperty<?> visual_property : all_visual_properties) {
                if (visual_property.getTargetDataType() != CyNode.class) continue;
                VisualPropertiesGatherer.addProperties((View<? extends CyIdentifiable>)node_view, visual_property, e);
            }
            if (e.getProperties() == null || e.getProperties().isEmpty()) continue;
            visual_properties.add((AspectElement)e);
        }
    }

    public static List<CxNodeBypass> getNodeBypasses(CyNetworkView view, Set<VisualProperty<?>> all_visual_properties, boolean use_cxId, boolean nodeSizeLocked) throws NdexException {
        LinkedList<CxNodeBypass> nodeByPasses = new LinkedList<CxNodeBypass>();
        List filteredVPs = all_visual_properties.stream().filter(x -> x.getTargetDataType() == CyNode.class).collect(Collectors.toList());
        for (View node_view : view.getNodeViews()) {
            HashMap<String, String> cx1VPTable = new HashMap<String, String>();
            for (VisualProperty visual_property : filteredVPs) {
                String id_string;
                String value_str;
                if (!node_view.isSet(visual_property) || !node_view.isValueLocked(visual_property) || CxioUtil.isEmpty((String)(value_str = VisualPropertiesGatherer.getSerializableVisualProperty((View<? extends CyIdentifiable>)node_view, visual_property))) || (id_string = visual_property.getIdString()).equals("NODE") || id_string.equals("EDGE") || id_string.equals("NETWORK")) continue;
                cx1VPTable.put(id_string, value_str);
            }
            if (cx1VPTable.isEmpty()) continue;
            CyNode cy_node = (CyNode)node_view.getModel();
            Long nodeId = CxUtil.getElementId((CyIdentifiable)cy_node, (CyNetwork)view.getModel(), use_cxId);
            if (nodeSizeLocked) {
                CXToCX2VisualPropertyConverter.cvtCx1NodeSize(cx1VPTable);
            }
            VisualPropertyTable t = CXToCX2VisualPropertyConverter.getInstance().convertEdgeOrNodeVPs(cx1VPTable);
            nodeByPasses.add(new CxNodeBypass(nodeId, t));
        }
        return nodeByPasses;
    }

    public static List<CxEdgeBypass> getEdgeBypasses(CyNetworkView view, Set<VisualProperty<?>> all_visual_properties, boolean use_cxId, boolean arrowColorMatchesEdge) throws NdexException {
        LinkedList<CxEdgeBypass> edgeByPasses = new LinkedList<CxEdgeBypass>();
        List filteredVPs = all_visual_properties.stream().filter(x -> x.getTargetDataType() == CyEdge.class).collect(Collectors.toList());
        for (View edgeView : view.getEdgeViews()) {
            HashMap<String, String> cx1VPTable = new HashMap<String, String>();
            for (VisualProperty visual_property : filteredVPs) {
                String id_string;
                String value_str;
                if (!edgeView.isSet(visual_property) || !edgeView.isValueLocked(visual_property) || CxioUtil.isEmpty((String)(value_str = VisualPropertiesGatherer.getSerializableVisualProperty((View<? extends CyIdentifiable>)edgeView, visual_property))) || (id_string = visual_property.getIdString()).equals("NODE") || id_string.equals("EDGE") || id_string.equals("NETWORK")) continue;
                cx1VPTable.put(id_string, value_str);
            }
            if (cx1VPTable.isEmpty()) continue;
            CyEdge cyEdge = (CyEdge)edgeView.getModel();
            Long edgeId = CxUtil.getElementId((CyIdentifiable)cyEdge, (CyNetwork)view.getModel(), use_cxId);
            if (arrowColorMatchesEdge) {
                CXToCX2VisualPropertyConverter.cvtCx1EdgeColor(cx1VPTable);
            }
            VisualPropertyTable t = CXToCX2VisualPropertyConverter.getInstance().convertEdgeOrNodeVPs(cx1VPTable);
            edgeByPasses.add(new CxEdgeBypass(edgeId, t));
        }
        return edgeByPasses;
    }

    private static final String toAttributeType(Class<?> attr_class, CyTable table, String col_name) throws IOException {
        ATTRIBUTE_DATA_TYPE attrType = null;
        try {
            attrType = CxUtil.toAttributeType(attr_class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (attrType != null) {
            return attrType.toString();
        }
        if (Number.class.isAssignableFrom(attr_class) || List.class.isAssignableFrom(attr_class)) {
            Class col_type = null;
            CyColumn col = null;
            if (table != null && col_name != null) {
                col = table.getColumn(col_name);
                if (col != null) {
                    col_type = table.getColumn(col_name).getType();
                } else {
                    throw new IOException("failed to obtain column '" + col_name + "'");
                }
            }
            if (col_type != null) {
                logger.info((Object)("mapping type is '" + String.valueOf(attr_class) + "' will use (from table column) '" + String.valueOf(col_type) + "' instead"));
                if (List.class.isAssignableFrom(col_type)) {
                    Class elmt_type = col.getListElementType();
                    return CxUtil.toListAttributeType(elmt_type).toString();
                }
                return CxUtil.toAttributeType(col_type).toString();
            }
            throw new IllegalStateException("failed to obtain type for mapping from table");
        }
        throw new IllegalArgumentException("don't know how to deal with type '" + String.valueOf(attr_class) + "' for column " + col_name);
    }
}

