/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_reader;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.cytoscape.io.internal.CxPreferences;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cx_reader.StringParser;
import org.cytoscape.io.internal.cxio.Settings;
import org.cytoscape.io.internal.cxio.TimingUtil;
import org.cytoscape.io.internal.nicecy.NiceCyRootNetwork;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;
import org.ndexbio.cxio.aspects.datamodels.CartesianLayoutElement;
import org.ndexbio.cxio.aspects.datamodels.CyVisualPropertiesElement;
import org.ndexbio.cxio.aspects.datamodels.Mapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ViewMaker {
    private static final Logger logger = LoggerFactory.getLogger((String)"CX ViewMaker");
    public static final Pattern DIRECT_NET_PROPS_PATTERN = Pattern.compile("GRAPH_VIEW_(ZOOM|CENTER_(X|Y))|NETWORK_(WIDTH|HEIGHT|SCALE_FACTOR|CENTER_(X|Y|Z)_LOCATION)");
    public static final VisualMappingFunctionFactory vmf_factory_c = CyServiceModule.getContinuousMapping();
    public static final VisualMappingFunctionFactory vmf_factory_d = CyServiceModule.getDiscreteMapping();
    public static final VisualMappingFunctionFactory vmf_factory_p = CyServiceModule.getPassthroughMapping();

    private static boolean applyCartesianLayout(CyNetworkView view, CyNode node, CartesianLayoutElement position) {
        View node_view;
        if (position == null || view == null) {
            return false;
        }
        if (position != null && (node_view = view.getNodeView(node)) != null) {
            node_view.setVisualProperty(BasicVisualLexicon.NODE_X_LOCATION, (Object)position.getX());
            node_view.setVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION, (Object)position.getY());
            if (position.isZset()) {
                node_view.setVisualProperty(BasicVisualLexicon.NODE_Z_LOCATION, (Object)position.getZ());
            }
        }
        return true;
    }

    public static CyNetworkView applyStyle(VisualStyle style, CyNetworkView network_view, String layout, boolean fitContent) {
        if (layout != null && CxPreferences.getApplyLayout() != CxPreferences.ApplyLayoutEnum.NEVER) {
            CyLayoutAlgorithmManager layout_manager = CyServiceModule.getService(CyLayoutAlgorithmManager.class);
            CyLayoutAlgorithm algorithm = layout_manager.getLayout(layout);
            TaskIterator ti = algorithm.createTaskIterator(network_view, algorithm.getDefaultLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, null);
            DialogTaskManager task_manager = CyServiceModule.getService(DialogTaskManager.class);
            task_manager.execute(ti);
            network_view.updateView();
        }
        style.apply(network_view);
        network_view.updateView();
        if (fitContent) {
            network_view.fitContent();
        } else {
            network_view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION, (Object)((Double)style.getDefaultValue(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION)));
            network_view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION, (Object)((Double)style.getDefaultValue(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION)));
            network_view.setVisualProperty(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION, (Object)((Double)style.getDefaultValue(BasicVisualLexicon.NETWORK_CENTER_Z_LOCATION)));
            network_view.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)((Double)style.getDefaultValue(BasicVisualLexicon.NETWORK_SCALE_FACTOR)));
        }
        return network_view;
    }

    public static final void addContinuousMapping(VisualStyle style, VisualProperty vp, StringParser sp, String col, String type, Class<?> type_class) {
        ContinuousMapping cmf = (ContinuousMapping)vmf_factory_c.createVisualMappingFunction(col, type_class, vp);
        if (cmf != null) {
            String ov;
            int counter = 0;
            while ((ov = sp.get("OV=" + counter)) != null) {
                String l = sp.get("L=" + counter);
                String e = sp.get("E=" + counter);
                String g = sp.get("G=" + counter);
                if (l != null && e != null && g != null) {
                    Object lp = vp.parseSerializableString(l);
                    Object ep = vp.parseSerializableString(e);
                    Object gp = vp.parseSerializableString(g);
                    Object value = vp.parseSerializableString(ov);
                    try {
                        value = ViewMaker.toContinuousPointValue(ov, type);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (lp != null && ep != null && gp != null && value != null) {
                        BoundaryRangeValues point = new BoundaryRangeValues(lp, ep, gp);
                        cmf.addPoint(value, point);
                    } else {
                        logger.warn("could not parse from string in continuous mapping for col '" + col + "'");
                    }
                } else {
                    logger.warn("could not get expected values in continuous mapping for col '" + col + "'");
                }
                ++counter;
            }
            style.addVisualMappingFunction((VisualMappingFunction)cmf);
        } else {
            logger.warn("could not create continuous mapping for col '" + col + "'");
        }
    }

    public static final void addDiscreteMapping(VisualStyle style, VisualProperty vp, StringParser sp, String col, String type, Class<?> type_class) {
        DiscreteMapping dmf = (DiscreteMapping)vmf_factory_d.createVisualMappingFunction(col, type_class, vp);
        try {
            String k;
            if (dmf == null) {
                throw new RuntimeException("createVisualMappingFunction returned null");
            }
            int counter = 0;
            while ((k = sp.get("K=" + counter)) != null) {
                String v = sp.get("V=" + counter);
                if (v == null) {
                    logger.info("error: discrete mapping function string is corrupt for ");
                }
                Object key = ViewMaker.toTypeValue(k, type);
                try {
                    Object pv = vp.parseSerializableString(v);
                    if (pv != null) {
                        dmf.putMapValue(key, pv);
                    } else {
                        logger.info("Could not parse serializable string from discrete mapping value '" + v + "'");
                        dmf.putMapValue(key, pv);
                    }
                }
                catch (NullPointerException e) {
                    throw new RuntimeException("Unable to parse serializable string " + String.valueOf(key) + " " + type + " from " + v);
                }
                ++counter;
            }
            style.addVisualMappingFunction((VisualMappingFunction)dmf);
        }
        catch (RuntimeException e) {
            logger.info("Failed to create discrete mapping for " + col + ": " + e.getMessage());
        }
    }

    public static final void addPasstroughMapping(VisualStyle style, VisualProperty vp, String col, Class<?> type_class) {
        try {
            PassthroughMapping pmf = (PassthroughMapping)vmf_factory_p.createVisualMappingFunction(col, type_class, vp);
            style.addVisualMappingFunction((VisualMappingFunction)pmf);
        }
        catch (NullPointerException e) {
            logger.warn("could not create passthrough mapping for col '" + col + "'");
        }
    }

    public static final String createTitleForNewVisualStyle(String network_collection_name) {
        String viz_style_title = "new-Style";
        if (network_collection_name != null) {
            viz_style_title = network_collection_name.toLowerCase().endsWith(".cx") ? String.format("%s-Style", network_collection_name.substring(0, network_collection_name.length() - 3)) : String.format("%s-Style", network_collection_name);
        }
        return viz_style_title;
    }

    public static final void removeVisualStyle(String viz_style_title, VisualMappingManager visual_mapping_manager) {
        for (VisualStyle vs : visual_mapping_manager.getAllVisualStyles()) {
            if (!vs.getTitle().equalsIgnoreCase(viz_style_title)) continue;
            visual_mapping_manager.removeVisualStyle(vs);
            break;
        }
    }

    public static final boolean containsVisualStyle(String viz_style_title, VisualMappingManager visual_mapping_manager) {
        for (VisualStyle vs : visual_mapping_manager.getAllVisualStyles()) {
            if (!vs.getTitle().equalsIgnoreCase(viz_style_title)) continue;
            return true;
        }
        return false;
    }

    private static void parseVisualProperty(String key, String value, VisualLexicon lexicon, VisualStyle style, Class<? extends CyIdentifiable> my_class) throws IOException {
        VisualProperty vp = lexicon.lookup(my_class, key);
        if (vp != null) {
            Object parsed_value = null;
            try {
                parsed_value = vp.parseSerializableString(value);
                if (parsed_value != null) {
                    style.setDefaultValue(vp, parsed_value);
                }
            }
            catch (Exception e) {
                logger.info("Could not parse serializable string from '" + value + "' for '" + key + "'");
            }
        }
    }

    public static final void setDefaultVisualPropertiesAndMappings(VisualLexicon lexicon, CyVisualPropertiesElement visProp, VisualStyle style, Class my_class) {
        if (visProp == null) {
            return;
        }
        SortedMap props = visProp.getProperties();
        SortedMap maps = visProp.getMappings();
        SortedMap dependencies = visProp.getDependencies();
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                try {
                    ViewMaker.parseVisualProperty((String)entry.getKey(), (String)entry.getValue(), lexicon, style, my_class);
                }
                catch (IOException e) {
                    logger.warn("Failed to parse visual property: " + String.valueOf(e));
                }
            }
        }
        if (maps != null) {
            for (Map.Entry entry : maps.entrySet()) {
                try {
                    ViewMaker.parseVisualMapping((String)entry.getKey(), (Mapping)entry.getValue(), lexicon, style, my_class);
                }
                catch (IOException e) {
                    logger.warn("Failed to parse visual mapping: " + String.valueOf(e));
                }
            }
        }
        if (dependencies != null) {
            for (Map.Entry entry : dependencies.entrySet()) {
                try {
                    ViewMaker.parseVisualDependency((String)entry.getKey(), (String)entry.getValue(), style);
                }
                catch (IOException e) {
                    logger.warn("Failed to parse visual dependency: " + String.valueOf(e));
                }
            }
        }
    }

    private static void parseVisualDependency(String k, String v, VisualStyle style) throws IOException {
        if (k == null || v == null) {
            return;
        }
        for (VisualPropertyDependency d : style.getAllVisualPropertyDependencies()) {
            if (!d.getIdString().equals(k)) continue;
            try {
                d.setDependency(Boolean.parseBoolean(v));
            }
            catch (Exception e) {
                throw new IOException("could not parse boolean from '" + v + "'");
            }
        }
    }

    private static void parseVisualMapping(String mapping_target, Mapping mapping, VisualLexicon lexicon, VisualStyle style, Class<? extends CyIdentifiable> my_class) throws IOException {
        String mapping_type = mapping.getType();
        VisualProperty vp = lexicon.lookup(my_class, mapping_target);
        StringParser sp = new StringParser(mapping.getDefinition());
        String col = sp.get("COL");
        String type = sp.get("T");
        Class<?> type_class = ViewMaker.toClass(type);
        if (vp == null) {
            return;
        }
        if (mapping_type.equals("PASSTHROUGH")) {
            ViewMaker.addPasstroughMapping(style, vp, col, type_class);
        } else if (mapping_type.equals("CONTINUOUS")) {
            ViewMaker.addContinuousMapping(style, vp, sp, col, type, type_class);
        } else if (mapping_type.equals("DISCRETE")) {
            ViewMaker.addDiscreteMapping(style, vp, sp, col, type, type_class);
        } else {
            throw new IOException("unknown mapping type: " + mapping_type);
        }
    }

    public static final void setEdgeVisualProperties(CyNetworkView view, VisualLexicon lexicon, CyEdge edge, List<CyVisualPropertiesElement> edgeProps) {
        if (edgeProps == null) {
            return;
        }
        edgeProps.forEach(vpe -> {
            SortedMap props;
            if (vpe != null && (props = vpe.getProperties()) != null) {
                View v = view.getEdgeView(edge);
                ViewMaker.setVisualProperties(lexicon, props, v, CyEdge.class);
            }
        });
    }

    public static final void setNodeVisualProperties(CyNetworkView view, VisualLexicon lexicon, CyNode node, List<CyVisualPropertiesElement> nodeProps) {
        if (nodeProps == null) {
            return;
        }
        nodeProps.forEach(vpe -> {
            SortedMap props = vpe.getProperties();
            if (props != null) {
                View v = view.getNodeView(node);
                ViewMaker.setVisualProperties(lexicon, props, v, CyNode.class);
            }
        });
    }

    public static final void setVisualProperties(VisualLexicon lexicon, SortedMap<String, String> props, View view, Class my_class) {
        if (props == null) {
            return;
        }
        for (Map.Entry<String, String> entry : props.entrySet()) {
            Object parsed_value;
            VisualProperty vp = lexicon.lookup(my_class, entry.getKey());
            if (vp == null || (parsed_value = vp.parseSerializableString(entry.getValue())) == null) continue;
            if (ViewMaker.shouldSetAsLocked(vp)) {
                view.setLockedValue(vp, parsed_value);
                continue;
            }
            view.setVisualProperty(vp, parsed_value);
        }
    }

    public static final boolean shouldSetAsLocked(VisualProperty vp) {
        if (vp.getTargetDataType() == CyNode.class) {
            if (vp == BasicVisualLexicon.NODE_X_LOCATION || vp == BasicVisualLexicon.NODE_Y_LOCATION || vp == BasicVisualLexicon.NODE_Z_LOCATION) {
                return false;
            }
        } else if (vp.getTargetDataType() == CyNetwork.class) {
            return !DIRECT_NET_PROPS_PATTERN.matcher(vp.getIdString()).matches();
        }
        return true;
    }

    public static final Class<?> toClass(String type) {
        if (type.equals("string")) {
            return String.class;
        }
        if (type.equals("integer")) {
            return Integer.class;
        }
        if (type.equals("long")) {
            return Long.class;
        }
        if (type.equals("double") || type.equals("float")) {
            return Double.class;
        }
        if (type.equals("boolean")) {
            return Boolean.class;
        }
        if (type.startsWith("list_of_")) {
            return List.class;
        }
        throw new IllegalArgumentException("don't know how to deal with type '" + type + "'");
    }

    public static final Object toContinuousPointValue(String s, String type) throws NumberFormatException {
        if (type.equals("string")) {
            return s;
        }
        if (type.equals("integer")) {
            return Double.valueOf(s);
        }
        if (type.equals("long")) {
            return Double.valueOf(s);
        }
        if (type.equals("double") || type.equals("float")) {
            return Double.valueOf(s);
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(s);
        }
        throw new IllegalArgumentException("don't know how to deal with type '" + type + "'");
    }

    public static final Object toTypeValue(String s, String type) throws NumberFormatException {
        if (type.equals("string")) {
            return s;
        }
        if (type.equals("integer")) {
            return Double.valueOf(s).intValue();
        }
        if (type.equals("long")) {
            return Double.valueOf(s).longValue();
        }
        if (type.equals("double") || type.equals("float")) {
            return Double.valueOf(s);
        }
        if (type.equals("boolean")) {
            return Boolean.valueOf(s);
        }
        throw new IllegalArgumentException("don't know how to deal with type '" + type + "'");
    }

    public static void makeView(CyNetworkView view, NiceCyRootNetwork niceCy, Map<Long, CartesianLayoutElement> cartesianLayout, Map<String, CyVisualPropertiesElement> visualProperties, Map<Long, List<CyVisualPropertiesElement>> nodeBypass, Map<Long, List<CyVisualPropertiesElement>> edgeBypass) {
        VisualMappingManager visual_mapping_manager = CyServiceModule.getService(VisualMappingManager.class);
        VisualStyleFactory visual_style_factory = CyServiceModule.getService(VisualStyleFactory.class);
        RenderingEngineManager rendering_engine_manager = CyServiceModule.getService(RenderingEngineManager.class);
        long t0 = System.currentTimeMillis();
        String doLayout = view.getEdgeViews().size() < CxPreferences.getLargeLayoutThreshold() ? "force-directed" : "grid";
        boolean have_default_visual_properties = visualProperties != null || nodeBypass != null || edgeBypass != null;
        VisualStyle new_visual_style = visual_mapping_manager.getDefaultVisualStyle();
        if (have_default_visual_properties) {
            VisualStyle default_visual_style = visual_mapping_manager.getDefaultVisualStyle();
            new_visual_style = visual_style_factory.createVisualStyle(default_visual_style);
            CyRootNetwork root = ((CySubNetwork)view.getModel()).getRootNetwork();
            String name = (String)root.getRow((CyIdentifiable)root).get("name", String.class);
            String viz_style_title_base = ViewMaker.createTitleForNewVisualStyle(name);
            Object viz_style_title = viz_style_title_base;
            for (int counter = 1; counter < 101; ++counter) {
                if (!ViewMaker.containsVisualStyle((String)viz_style_title, visual_mapping_manager)) continue;
                viz_style_title = viz_style_title_base + "-" + counter;
            }
            new_visual_style.setTitle((String)viz_style_title);
        }
        VisualLexicon lexicon = rendering_engine_manager.getDefaultVisualLexicon();
        CyVisualPropertiesElement networkVisualProperties = visualProperties.get("network");
        ViewMaker.setDefaultVisualPropertiesAndMappings(lexicon, networkVisualProperties, new_visual_style, CyNetwork.class);
        boolean fitContent = networkVisualProperties != null && !networkVisualProperties.getProperties().containsKey(BasicVisualLexicon.NETWORK_CENTER_X_LOCATION.getIdString()) && !networkVisualProperties.getProperties().containsKey(BasicVisualLexicon.NETWORK_CENTER_Y_LOCATION.getIdString()) && !networkVisualProperties.getProperties().containsKey(BasicVisualLexicon.NETWORK_SCALE_FACTOR.getIdString());
        System.out.println("FitContent = " + fitContent);
        ViewMaker.setDefaultVisualPropertiesAndMappings(lexicon, visualProperties.get("nodes:default"), new_visual_style, CyNode.class);
        ViewMaker.setDefaultVisualPropertiesAndMappings(lexicon, visualProperties.get("edges:default"), new_visual_style, CyEdge.class);
        nodeBypass.forEach((suid, props) -> {
            CyNode node = niceCy.getNode((Long)suid);
            ViewMaker.setNodeVisualProperties(view, lexicon, node, props);
        });
        edgeBypass.forEach((suid, props) -> {
            CyEdge edge = niceCy.getEdge((Long)suid);
            ViewMaker.setEdgeVisualProperties(view, lexicon, edge, props);
        });
        for (Long suid2 : cartesianLayout.keySet()) {
            CyNode node = niceCy.getNode(suid2);
            if (!ViewMaker.applyCartesianLayout(view, node, cartesianLayout.get(suid2))) continue;
            doLayout = null;
        }
        if (have_default_visual_properties) {
            visual_mapping_manager.addVisualStyle(new_visual_style);
            visual_mapping_manager.setVisualStyle(new_visual_style, view);
        }
        ViewMaker.applyStyle(new_visual_style, view, doLayout, fitContent);
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, "time to make view", -1);
        }
    }
}

