/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.cytoscape.io.internal.CyServiceModule;
import org.cytoscape.io.internal.cxio.CxImporter;
import org.cytoscape.io.internal.cxio.Settings;
import org.cytoscape.io.internal.cxio.TimingUtil;
import org.cytoscape.io.internal.nicecy.NiceCyRootNetwork;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.util.ListSingleSelection;
import org.ndexbio.model.cx.NiceCXNetwork;

public class CytoscapeCxNetworkReader
extends AbstractCyNetworkReader {
    private CyNetwork[] _networks;
    private String _network_collection_name;
    private NiceCyRootNetwork niceCy;
    protected final NiceCXNetwork niceCX;
    final CxImporter cx_importer = new CxImporter();
    private Boolean createView = null;

    public void setCreateView(Boolean createView) {
        this.createView = createView;
    }

    public CytoscapeCxNetworkReader(InputStream input_stream, String network_collection_name, CyNetworkViewFactory networkview_factory, CyNetworkFactory network_factory, CyNetworkManager network_manager, CyRootNetworkManager root_network_manager) {
        super(input_stream, networkview_factory, network_factory, network_manager, root_network_manager);
        if (input_stream == null) {
            throw new IllegalArgumentException("input stream must not be null");
        }
        try {
            this.niceCX = this.cx_importer.getCXNetworkFromStream(input_stream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to import file as CX");
        }
        this._network_collection_name = network_collection_name;
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        System.out.println("Creating view for " + String.valueOf(network));
        List<CyNetworkView> views = this.niceCy.createViews(network, this.createView);
        if (views.isEmpty()) {
            CyNetworkViewFactory view_factory = CyServiceModule.getService(CyNetworkViewFactory.class);
            CyNetworkView createdView = view_factory.createNetworkView(network);
            return createdView;
        }
        try {
            this.niceCy.addTableVisualStyles(network);
        }
        catch (Exception e) {
            System.out.println("Failed to create table style for " + String.valueOf(network) + ": " + e.getMessage());
        }
        return views.get(0);
    }

    public CyNetwork[] getNetworks() {
        return this._networks;
    }

    public void run(TaskMonitor taskMonitor) throws IOException {
        System.out.println("create view value: " + this.createView);
        long t0 = System.currentTimeMillis();
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, "total time parsing", -1);
        }
        if (this.getRootNetwork() != null) {
            System.out.println("CX Support is changing to disallow import into existing collections");
            this.setRootNetworkList(new ListSingleSelection((Object[])new String[0]));
        }
        long t1 = System.currentTimeMillis();
        this.niceCy = new NiceCyRootNetwork(this.niceCX);
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t1, "Time to create NiceCyNetwork", -1);
        }
        if (this.niceCy.getNetworkName() == null) {
            if (this._network_collection_name == null) {
                this._network_collection_name = "Unnamed CX Network";
            }
            this.niceCy.setNetworkName(this._network_collection_name);
        }
        t1 = System.currentTimeMillis();
        List<CyNetwork> importedNetworks = this.niceCy.apply();
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t1, "Time to create networks in Cytoscape", -1);
        }
        this._networks = new CyNetwork[importedNetworks.size()];
        importedNetworks.toArray(this._networks);
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, "total time to build network(s) (not views)", -1);
        }
    }
}

