/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.io.internal.cx_reader;

import java.io.IOException;
import java.io.InputStream;
import org.cytoscape.io.internal.cxio.Cx2Importer;
import org.cytoscape.io.internal.cxio.Settings;
import org.cytoscape.io.internal.cxio.TimingUtil;
import org.cytoscape.io.read.AbstractCyNetworkReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewFactory;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.util.ListSingleSelection;
import org.ndexbio.model.exceptions.NdexException;
import org.slf4j.LoggerFactory;

public class CytoscapeCx2NetworkReader
extends AbstractCyNetworkReader {
    private CyNetwork[] _networks;
    private String _network_collection_name;
    private Cx2Importer cx2Importer;
    private Boolean createView = null;

    public void setCreateView(Boolean createView) {
        this.createView = createView;
    }

    public CytoscapeCx2NetworkReader(InputStream input_stream, String network_collection_name, CyNetworkViewFactory networkview_factory, CyNetworkFactory network_factory, CyNetworkManager network_manager, CyRootNetworkManager root_network_manager) {
        super(input_stream, networkview_factory, network_factory, network_manager, root_network_manager);
        this.cx2Importer = new Cx2Importer(input_stream, true);
        this._network_collection_name = network_collection_name;
        this._networks = null;
        this.createView = Boolean.TRUE;
    }

    public CyNetworkView buildCyNetworkView(CyNetwork network) {
        try {
            return this.cx2Importer.createView();
        }
        catch (Exception e) {
            LoggerFactory.getLogger((String)"CX2 Importer").error(e.getMessage());
            return null;
        }
    }

    public CyNetwork[] getNetworks() {
        return this._networks;
    }

    public void run(TaskMonitor taskMonitor) throws IOException, NdexException {
        System.out.println("create view value: " + this.createView);
        long t0 = System.currentTimeMillis();
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, "total time parsing", -1);
        }
        if (this.getRootNetwork() != null) {
            System.out.println("CX Support is changing to disallow import into existing collections");
            this.setRootNetworkList(new ListSingleSelection((Object[])new String[0]));
        }
        long t1 = System.currentTimeMillis();
        CyNetwork newSubnetwork = this.cx2Importer.importNetwork();
        if (this.cx2Importer.getNetworkName() == null) {
            if (this._network_collection_name == null) {
                this._network_collection_name = "Unnamed CX Network";
            }
            this.cx2Importer.setCollectionName(this._network_collection_name);
        }
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t1, "Time to create NiceCyNetwork", -1);
        }
        this._networks = new CyNetwork[1];
        this._networks[0] = newSubnetwork;
        if (Settings.INSTANCE.isTiming()) {
            TimingUtil.reportTimeDifference(t0, "total time to build network(s) (not views)", -1);
        }
    }
}

